/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.search;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Unit;
import tim.prune.function.search.GenericDownloaderFunction;
import tim.prune.function.search.SearchOsmPoisXmlHandler;
import tim.prune.function.search.SearchResult;

public class SearchOsmPoisFunction
extends GenericDownloaderFunction {
    private static final int MAX_DISTANCE = 250;
    private double _searchLatitude = 0.0;
    private double _searchLongitude = 0.0;

    public SearchOsmPoisFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.searchosmpois";
    }

    @Override
    protected String getColumnKey(int n) {
        if (n == 0) {
            return "dialog.osmpois.column.name";
        }
        return "dialog.osmpois.column.type";
    }

    @Override
    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        if (dataPoint == null) {
            this._searchLatitude = this._app.getViewport().getCentreLatitude();
            this._searchLongitude = this._app.getViewport().getCentreLongitude();
        } else {
            this._searchLatitude = dataPoint.getLatitude().getDouble();
            this._searchLongitude = dataPoint.getLongitude().getDouble();
        }
        this.submitSearch(this._searchLatitude, this._searchLongitude);
        if (this._errorMessage == null && this._trackListModel.isEmpty()) {
            this._errorMessage = I18nManager.getText("dialog.osmpois.nonefound");
        }
        this._statusLabel.setText(this._errorMessage == null ? "" : this._errorMessage);
        this.finishedSearch();
    }

    /*
     * WARNING - void declaration
     */
    private void submitSearch(double d, double d2) {
        Object object;
        Object object3;
        Object object4;
        String string = "around:250," + d + "," + d2;
        String string2 = "http://overpass-api.de/api/interpreter?data=(node(" + string + ")[\"amenity\"][\"name\"];" + "node(" + string + ")[\"railway\"][\"name\"];" + "node(" + string + ")[\"highway\"][\"name\"];" + ");out%20qt;";
        SearchOsmPoisXmlHandler searchOsmPoisXmlHandler = new SearchOsmPoisXmlHandler();
        try {
            object4 = new URL(string2);
            object3 = SAXParserFactory.newInstance().newSAXParser();
            try {
                Throwable object22 = null;
                Iterator<SearchResult> iterator = null;
                try {
                    object = ((URL)object4).openStream();
                    try {
                        ((SAXParser)object3).parse((InputStream)object, (DefaultHandler)searchOsmPoisXmlHandler);
                    }
                    finally {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                }
                catch (Throwable throwable) {
                    void var10_11;
                    if (object22 == null) {
                        Throwable exception = throwable;
                    } else if (object22 != throwable) {
                        object22.addSuppressed(throwable);
                    }
                    throw var10_11;
                }
            }
            catch (Exception exception) {
                this._errorMessage = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
            }
        }
        catch (MalformedURLException | ParserConfigurationException | SAXException exception) {}
        object4 = new DataPoint(Latitude.make(this._searchLatitude), Longitude.make(this._searchLongitude));
        object3 = this.getConfig().getUnitSet().getDistanceUnit();
        for (SearchResult searchResult : searchOsmPoisXmlHandler.getPointList()) {
            object = new DataPoint(Latitude.make(searchResult.getLatitude()), Longitude.make(searchResult.getLongitude()));
            double d3 = DataPoint.calculateRadiansBetween((DataPoint)object4, (DataPoint)object);
            searchResult.setLength(Distance.convertRadiansToDistance(d3, (Unit)object3));
        }
        ArrayList<SearchResult> arrayList = searchOsmPoisXmlHandler.getPointList();
        this._trackListModel.addTracks(arrayList, true);
        this._trackListModel.setShowPointTypes(true);
    }
}

