/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.awt;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.glu.gl2.GLUgl2;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import com.jogamp.opengl.util.texture.awt.AWTTextureData;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

public class TextureRenderer {
    private final boolean alpha;
    private final boolean intensity;
    private boolean mipmap;
    private boolean smoothing = true;
    private boolean smoothingChanged;
    private BufferedImage image;
    private Texture texture;
    private AWTTextureData textureData;
    private boolean mustReallocateTexture;
    private Rectangle dirtyRegion;
    private final GLUgl2 glu = new GLUgl2();
    private float r = 1.0f;
    private float g = 1.0f;
    private float b = 1.0f;
    private float a = 1.0f;
    private float[] compArray;

    public TextureRenderer(int n, int n2, boolean bl) {
        this(n, n2, bl, false);
    }

    public TextureRenderer(int n, int n2, boolean bl, boolean bl2) {
        this(n, n2, bl, false, bl2);
    }

    private TextureRenderer(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.alpha = bl;
        this.intensity = bl2;
        this.mipmap = bl3;
        this.init(n, n2);
    }

    public static TextureRenderer createAlphaOnlyRenderer(int n, int n2) {
        return TextureRenderer.createAlphaOnlyRenderer(n, n2, false);
    }

    public static TextureRenderer createAlphaOnlyRenderer(int n, int n2, boolean bl) {
        return new TextureRenderer(n, n2, false, true, bl);
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public Dimension getSize() {
        return this.getSize(null);
    }

    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        dimension.setSize(this.image.getWidth(), this.image.getHeight());
        return dimension;
    }

    public void setSize(int n, int n2) throws GLException {
        this.init(n, n2);
    }

    public void setSize(Dimension dimension) throws GLException {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSmoothing(boolean bl) {
        this.smoothing = bl;
        this.smoothingChanged = true;
    }

    public boolean getSmoothing() {
        return this.smoothing;
    }

    public Graphics2D createGraphics() {
        return this.image.createGraphics();
    }

    public Image getImage() {
        return this.image;
    }

    public void markDirty(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (this.dirtyRegion == null) {
            this.dirtyRegion = rectangle;
        } else {
            this.dirtyRegion.add(rectangle);
        }
    }

    public Texture getTexture() throws GLException {
        if (this.dirtyRegion != null) {
            this.sync(this.dirtyRegion.x, this.dirtyRegion.y, this.dirtyRegion.width, this.dirtyRegion.height);
            this.dirtyRegion = null;
        }
        this.ensureTexture();
        return this.texture;
    }

    public void dispose() throws GLException {
        if (this.texture != null) {
            this.texture.destroy(GLContext.getCurrentGL());
            this.texture = null;
        }
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    public void beginOrthoRendering(int n, int n2) throws GLException {
        this.beginOrthoRendering(n, n2, true);
    }

    public void beginOrthoRendering(int n, int n2, boolean bl) throws GLException {
        this.beginRendering(true, n, n2, bl);
    }

    public void begin3DRendering() throws GLException {
        this.beginRendering(false, 0, 0, false);
    }

    public void setColor(float f, float f2, float f3, float f4) throws GLException {
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        this.r = f * f4;
        this.g = f2 * f4;
        this.b = f3 * f4;
        this.a = f4;
        gL2.glColor4f(this.r, this.g, this.b, this.a);
    }

    public void setColor(Color color) throws GLException {
        if (this.compArray == null) {
            this.compArray = new float[4];
        }
        color.getRGBComponents(this.compArray);
        this.setColor(this.compArray[0], this.compArray[1], this.compArray[2], this.compArray[3]);
    }

    public void drawOrthoRect(int n, int n2) throws GLException {
        this.drawOrthoRect(n, n2, 0, 0, this.getWidth(), this.getHeight());
    }

    public void drawOrthoRect(int n, int n2, int n3, int n4, int n5, int n6) throws GLException {
        this.draw3DRect(n, n2, 0.0f, n3, n4, n5, n6, 1.0f);
    }

    public void draw3DRect(float f, float f2, float f3, int n, int n2, int n3, int n4, float f4) throws GLException {
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        Texture texture = this.getTexture();
        TextureCoords textureCoords = texture.getSubImageTexCoords(n, n2, n + n3, n2 + n4);
        gL2.glBegin(7);
        gL2.glTexCoord2f(textureCoords.left(), textureCoords.bottom());
        gL2.glVertex3f(f, f2, f3);
        gL2.glTexCoord2f(textureCoords.right(), textureCoords.bottom());
        gL2.glVertex3f(f + (float)n3 * f4, f2, f3);
        gL2.glTexCoord2f(textureCoords.right(), textureCoords.top());
        gL2.glVertex3f(f + (float)n3 * f4, f2 + (float)n4 * f4, f3);
        gL2.glTexCoord2f(textureCoords.left(), textureCoords.top());
        gL2.glVertex3f(f, f2 + (float)n4 * f4, f3);
        gL2.glEnd();
    }

    public void endOrthoRendering() throws GLException {
        this.endRendering(true);
    }

    public void end3DRendering() throws GLException {
        this.endRendering(false);
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.mipmap;
    }

    private void beginRendering(boolean bl, int n, int n2, boolean bl2) {
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        int n3 = 0x46000 | (bl ? 4352 : 0);
        gL2.glPushAttrib(n3);
        gL2.glDisable(2896);
        if (bl) {
            if (bl2) {
                gL2.glDisable(2929);
            }
            gL2.glDisable(2884);
            gL2.glMatrixMode(5889);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            this.glu.gluOrtho2D(0.0f, n, 0.0f, n2);
            gL2.glMatrixMode(5888);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
            gL2.glMatrixMode(5890);
            gL2.glPushMatrix();
            gL2.glLoadIdentity();
        }
        gL2.glEnable(3042);
        gL2.glBlendFunc(1, 771);
        Texture texture = this.getTexture();
        texture.enable(gL2);
        texture.bind(gL2);
        gL2.glTexEnvi(8960, 8704, 8448);
        gL2.glColor4f(this.r, this.g, this.b, this.a);
        if (this.smoothingChanged) {
            this.smoothingChanged = false;
            if (this.smoothing) {
                texture.setTexParameteri(gL2, 10240, 9729);
                if (this.mipmap) {
                    texture.setTexParameteri(gL2, 10241, 9987);
                } else {
                    texture.setTexParameteri(gL2, 10241, 9729);
                }
            } else {
                texture.setTexParameteri(gL2, 10241, 9728);
                texture.setTexParameteri(gL2, 10240, 9728);
            }
        }
    }

    private void endRendering(boolean bl) {
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        Texture texture = this.getTexture();
        texture.disable(gL2);
        if (bl) {
            gL2.glMatrixMode(5889);
            gL2.glPopMatrix();
            gL2.glMatrixMode(5888);
            gL2.glPopMatrix();
            gL2.glMatrixMode(5890);
            gL2.glPopMatrix();
        }
        gL2.glPopAttrib();
    }

    private void init(int n, int n2) {
        int n3;
        GL2 gL2 = GLContext.getCurrentGL().getGL2();
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
        int n4 = n3 = this.intensity ? 32841 : 0;
        int n5 = this.intensity ? 10 : (this.alpha ? 3 : 1);
        this.image = new BufferedImage(n, n2, n5);
        this.textureData = new AWTTextureData(gL2.getGLProfile(), n3, 0, this.mipmap, this.image);
        this.mustReallocateTexture = true;
    }

    private void sync(int n, int n2, int n3, int n4) throws GLException {
        boolean bl = this.ensureTexture();
        if (!bl) {
            this.texture.updateSubImage(GLContext.getCurrentGL(), this.textureData, 0, n, n2, n, n2, n3, n4);
        }
    }

    private boolean ensureTexture() {
        GL gL = GLContext.getCurrentGL();
        if (this.mustReallocateTexture) {
            if (this.texture != null) {
                this.texture.destroy(gL);
                this.texture = null;
            }
            this.mustReallocateTexture = false;
        }
        if (this.texture == null) {
            this.texture = TextureIO.newTexture(this.textureData);
            if (this.mipmap && !this.texture.isUsingAutoMipmapGeneration()) {
                this.texture.destroy(gL);
                this.mipmap = false;
                this.textureData.setMipmap(false);
                this.texture = TextureIO.newTexture(this.textureData);
            }
            if (!this.smoothing) {
                this.texture.setTexParameteri(gL, 10241, 9728);
                this.texture.setTexParameteri(gL, 10240, 9728);
            }
            return true;
        }
        return false;
    }
}

