/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.Region;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.font.Font;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.Vec3f;
import com.jogamp.opengl.math.Vec4f;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.PrintStream;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.graph.curve.opengl.VBORegion2PMSAAES2;
import jogamp.graph.curve.opengl.VBORegion2PVBAAES2;
import jogamp.graph.curve.opengl.VBORegionSPES2;
import jogamp.opengl.Debug;

public abstract class GLRegion
extends Region {
    public static final int defaultVerticesCount = 64;
    public static final int defaultIndicesCount = 64;
    protected static final float growthFactor = 1.618f;
    private static final boolean DEBUG_BUFFER = Debug.debug("graph.curve.Buffer");
    private final int gl_idx_type = this.usesI32Idx() ? 5125 : 5123;
    protected final TextureSequence colorTexSeq;
    protected int curVerticesCap = 0;
    protected int curIndicesCap = 0;
    protected int growCount = 0;
    protected GLArrayDataServer vpc_ileave = null;
    protected GLArrayDataWrapper gca_VerticesAttr = null;
    protected GLArrayDataWrapper gca_CurveParamsAttr = null;
    protected GLArrayDataWrapper gca_ColorsAttr = null;
    protected GLArrayDataServer indicesBuffer = null;
    private int lastRenderModes = 0;

    public static GLRegion create(GLProfile gLProfile, int n, TextureSequence textureSequence, int n2, int n3, int n4) {
        if (null != textureSequence) {
            n |= 0x400;
        } else if (Region.hasColorTexture(n)) {
            throw new IllegalArgumentException("COLORTEXTURE_RENDERING_BIT set but null TextureSequence");
        }
        if (GLRegion.isVBAA(n)) {
            return new VBORegion2PVBAAES2(gLProfile, n, textureSequence, n2, n3, n4);
        }
        if (GLRegion.isMSAA(n)) {
            return new VBORegion2PMSAAES2(gLProfile, n, textureSequence, n2, n3, n4);
        }
        return new VBORegionSPES2(gLProfile, n, textureSequence, n3, n4);
    }

    public static GLRegion create(GLProfile gLProfile, int n, TextureSequence textureSequence, int n2, int n3) {
        return GLRegion.create(gLProfile, n, textureSequence, 0, n2, n3);
    }

    public static GLRegion create(GLProfile gLProfile, int n, TextureSequence textureSequence) {
        return GLRegion.create(gLProfile, n, textureSequence, 64, 64);
    }

    public static GLRegion create(GLProfile gLProfile, int n, TextureSequence textureSequence, OutlineShape outlineShape) {
        int[] nArray = Region.countOutlineShape(outlineShape, new int[2]);
        return GLRegion.create(gLProfile, n, textureSequence, nArray[0], nArray[1]);
    }

    public static GLRegion create(GLProfile gLProfile, int n, TextureSequence textureSequence, Font font, CharSequence charSequence) {
        final int[] nArray = new int[]{0, 0};
        Font.GlyphVisitor2 glyphVisitor2 = new Font.GlyphVisitor2(){

            @Override
            public final void visit(char c, Font.Glyph glyph) {
                Region.countOutlineShape(glyph.getShape(), nArray);
            }
        };
        font.processString(glyphVisitor2, charSequence);
        return GLRegion.create(gLProfile, n, textureSequence, nArray[0], nArray[1]);
    }

    protected GLRegion(GLProfile gLProfile, int n, TextureSequence textureSequence) {
        super(n, gLProfile.isGL2ES3());
        this.colorTexSeq = textureSequence;
    }

    protected final int glIdxType() {
        return this.gl_idx_type;
    }

    public GLArrayDataServer createInterleaved(boolean bl, int n, int n2, boolean bl2, int n3, int n4) {
        if (bl) {
            return GLArrayDataServer.createGLSLInterleavedMapped(n, n2, bl2, n3, n4);
        }
        return GLArrayDataServer.createGLSLInterleaved(n, n2, bl2, n3, n4);
    }

    public void addInterleavedVertexAndNormalArrays(GLArrayDataServer gLArrayDataServer, int n) {
        gLArrayDataServer.addGLSLSubArray("vertices", n, 34962);
        gLArrayDataServer.addGLSLSubArray("normals", n, 34962);
    }

    protected final void initBuffer(int n, int n2) {
        this.indicesBuffer = GLArrayDataServer.createData(3, this.glIdxType(), n2, 35044, 34963);
        this.indicesBuffer.setGrowthFactor(1.618f);
        this.curIndicesCap = this.indicesBuffer.getElemCapacity();
        boolean bl = this.hasColorChannel();
        int n3 = 6 + (bl ? 4 : 0);
        this.vpc_ileave = GLArrayDataServer.createGLSLInterleaved(n3, 5126, false, n, 35044);
        this.vpc_ileave.setGrowthFactor(1.618f);
        this.gca_VerticesAttr = this.vpc_ileave.addGLSLSubArray("gca_Vertices", 3, 34962);
        this.gca_CurveParamsAttr = this.vpc_ileave.addGLSLSubArray("gca_CurveParams", 3, 34962);
        if (bl) {
            this.gca_ColorsAttr = this.vpc_ileave.addGLSLSubArray("gca_Colors", 4, 34962);
        }
        this.curVerticesCap = this.vpc_ileave.getElemCapacity();
        this.growCount = 0;
    }

    @Override
    public final boolean growBuffer(int n, int n2) {
        boolean bl = false;
        if (!DEBUG_BUFFER) {
            if (this.curIndicesCap < this.indicesBuffer.elemPosition() + n2) {
                this.indicesBuffer.growIfNeeded(n2 * this.indicesBuffer.getCompsPerElem());
                this.curIndicesCap = this.indicesBuffer.getElemCapacity();
                bl = true;
            }
            if (this.curVerticesCap < this.vpc_ileave.elemPosition() + n) {
                this.vpc_ileave.growIfNeeded(n * this.vpc_ileave.getCompsPerElem());
                this.curVerticesCap = this.vpc_ileave.getElemCapacity();
                bl = true;
            }
        } else {
            if (this.curIndicesCap < this.indicesBuffer.elemPosition() + n2) {
                System.err.printf("GLRegion: Buffer grow - Indices: %d < ( %d = %d + %d ); Status: %s%n", this.curIndicesCap, this.indicesBuffer.elemPosition() + n2, this.indicesBuffer.elemPosition(), n2, this.indicesBuffer.elemStatsToString());
                this.indicesBuffer.growIfNeeded(n2 * this.indicesBuffer.getCompsPerElem());
                System.err.println("GLRegion: Grew Indices 0x" + Integer.toHexString(this.hashCode()) + ": " + this.curIndicesCap + " -> " + this.indicesBuffer.getElemCapacity() + ", " + this.indicesBuffer.elemStatsToString());
                Thread.dumpStack();
                this.curIndicesCap = this.indicesBuffer.getElemCapacity();
                bl = true;
            }
            if (this.curVerticesCap < this.vpc_ileave.elemPosition() + n) {
                System.err.printf("GLRegion: Buffer grow - Vertices: %d < ( %d = %d + %d ); Status: %s%n", this.curVerticesCap, this.gca_VerticesAttr.elemPosition() + n, this.gca_VerticesAttr.elemPosition(), n, this.gca_VerticesAttr.elemStatsToString());
                this.vpc_ileave.growIfNeeded(n * this.vpc_ileave.getCompsPerElem());
                System.err.println("GLRegion: Grew Vertices 0x" + Integer.toHexString(this.hashCode()) + ": " + this.curVerticesCap + " -> " + this.gca_VerticesAttr.getElemCapacity() + ", " + this.gca_VerticesAttr.elemStatsToString());
                this.curVerticesCap = this.vpc_ileave.getElemCapacity();
                bl = true;
            }
        }
        if (bl) {
            ++this.growCount;
            return true;
        }
        return false;
    }

    @Override
    public final boolean setBufferCapacity(int n, int n2) {
        boolean bl = false;
        if (this.curIndicesCap < n2) {
            this.indicesBuffer.reserve(n2);
            this.curIndicesCap = this.indicesBuffer.getElemCapacity();
            bl = true;
        }
        if (this.curVerticesCap < n) {
            this.vpc_ileave.reserve(n);
            this.curVerticesCap = this.vpc_ileave.getElemCapacity();
            bl = true;
        }
        return bl;
    }

    @Override
    public final void printBufferStats(PrintStream printStream) {
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        printStream.println("GLRegion: idx32 " + this.usesI32Idx() + ", obj 0x" + Integer.toHexString(this.hashCode()));
        GLRegion.printAndCount(printStream, "  indices ", this.indicesBuffer, nArray, nArray2);
        printStream.println();
        GLRegion.printAndCount(printStream, "  ileave ", this.vpc_ileave, nArray, nArray2);
        printStream.println();
        GLRegion.print(printStream, "  - vertices ", this.gca_VerticesAttr);
        printStream.println();
        GLRegion.print(printStream, "  - params ", this.gca_CurveParamsAttr);
        printStream.println();
        GLRegion.print(printStream, "  - color ", this.gca_ColorsAttr);
        printStream.println();
        float f = (float)nArray[0] / (float)nArray2[0];
        printStream.printf("  total [bytes %,d / %,d], filled[%.1f%%, left %.1f%%], grow-cnt %d, obj 0x%x%n", nArray[0], nArray2[0], Float.valueOf(f * 100.0f), Float.valueOf((1.0f - f) * 100.0f), this.growCount, this.hashCode());
    }

    private static void printAndCount(PrintStream printStream, String string, GLArrayData gLArrayData, int[] nArray, int[] nArray2) {
        printStream.print(string + "[");
        if (null != gLArrayData) {
            printStream.print(gLArrayData.fillStatsToString());
            nArray[0] = nArray[0] + gLArrayData.getByteCount();
            nArray2[0] = nArray2[0] + gLArrayData.getByteCapacity();
            printStream.print("]");
        } else {
            printStream.print("null]");
        }
    }

    private static void print(PrintStream printStream, String string, GLArrayData gLArrayData) {
        printStream.print(string + "[");
        if (null != gLArrayData) {
            printStream.print(gLArrayData.fillStatsToString());
            printStream.print("]");
        } else {
            printStream.print("null]");
        }
    }

    public abstract void setTextureUnit(int var1);

    @Override
    protected final void pushVertex(Vec3f vec3f, Vec3f vec3f2, Vec4f vec4f) {
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f);
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f2);
        if (this.hasColorChannel()) {
            if (null != vec4f) {
                GLRegion.put4f((FloatBuffer)this.vpc_ileave.getBuffer(), vec4f);
            } else {
                throw new IllegalArgumentException("Null color given for COLOR_CHANNEL rendering mode");
            }
        }
    }

    @Override
    protected final void pushVertices(Vec3f vec3f, Vec3f vec3f2, Vec3f vec3f3, Vec3f vec3f4, Vec3f vec3f5, Vec3f vec3f6, Vec4f vec4f) {
        boolean bl = this.hasColorChannel();
        if (bl && null == vec4f) {
            throw new IllegalArgumentException("Null color given for COLOR_CHANNEL rendering mode");
        }
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f);
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f4);
        if (bl) {
            GLRegion.put4f((FloatBuffer)this.vpc_ileave.getBuffer(), vec4f);
        }
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f2);
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f5);
        if (bl) {
            GLRegion.put4f((FloatBuffer)this.vpc_ileave.getBuffer(), vec4f);
        }
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f3);
        GLRegion.put3f((FloatBuffer)this.vpc_ileave.getBuffer(), vec3f6);
        if (bl) {
            GLRegion.put4f((FloatBuffer)this.vpc_ileave.getBuffer(), vec4f);
        }
    }

    @Override
    protected final void pushIndex(int n) {
        if (this.usesI32Idx()) {
            this.indicesBuffer.puti(n);
        } else {
            this.indicesBuffer.puts((short)n);
        }
    }

    @Override
    protected final void pushIndices(int n, int n2, int n3) {
        if (this.usesI32Idx()) {
            GLRegion.put3i((IntBuffer)this.indicesBuffer.getBuffer(), n, n2, n3);
        } else {
            GLRegion.put3s((ShortBuffer)this.indicesBuffer.getBuffer(), (short)n, (short)n2, (short)n3);
        }
    }

    public final GLRegion clear(GL2ES2 gL2ES2) {
        this.lastRenderModes = 0;
        if (DEBUG_INSTANCE) {
            System.err.println("GLRegion Clear: " + this);
        }
        if (null != this.indicesBuffer) {
            this.indicesBuffer.clear(gL2ES2);
        }
        if (null != this.vpc_ileave) {
            this.vpc_ileave.clear(gL2ES2);
        }
        this.clearImpl(gL2ES2);
        this.clearImpl();
        return this;
    }

    protected abstract void clearImpl(GL2ES2 var1);

    public final void destroy(GL2ES2 gL2ES2) {
        this.clear(gL2ES2);
        if (null != this.vpc_ileave) {
            this.vpc_ileave.destroy(gL2ES2);
            this.vpc_ileave = null;
        }
        if (null != this.gca_VerticesAttr) {
            this.gca_VerticesAttr.destroy(gL2ES2);
            this.gca_VerticesAttr = null;
        }
        if (null != this.gca_CurveParamsAttr) {
            this.gca_CurveParamsAttr.destroy(gL2ES2);
            this.gca_CurveParamsAttr = null;
        }
        if (null != this.gca_ColorsAttr) {
            this.gca_ColorsAttr.destroy(gL2ES2);
            this.gca_ColorsAttr = null;
        }
        if (null != this.indicesBuffer) {
            this.indicesBuffer.destroy(gL2ES2);
            this.indicesBuffer = null;
        }
        this.curVerticesCap = 0;
        this.curIndicesCap = 0;
        this.growCount = 0;
        this.destroyImpl(gL2ES2);
    }

    protected abstract void destroyImpl(GL2ES2 var1);

    public final void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer, int[] nArray) {
        int n = null == nArray || 0 == nArray[0] ? this.getRenderModes() & 0xFFFFFFFC : (0 > nArray[0] ? this.getRenderModes() & 0xFFFFF9FC : this.getRenderModes());
        if (this.lastRenderModes != n) {
            this.markShapeDirty();
            this.markStateDirty();
        }
        if (this.isShapeDirty()) {
            this.updateImpl(gL2ES2, n);
        }
        this.drawImpl(gL2ES2, regionRenderer, n, nArray);
        this.clearDirtyBits(3);
        this.lastRenderModes = n;
    }

    protected abstract void updateImpl(GL2ES2 var1, int var2);

    protected abstract void drawImpl(GL2ES2 var1, RegionRenderer var2, int var3, int[] var4);
}

