/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class IdentifierValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private String stringValue = null;

    public IdentifierValue() {
        super(CSSValue.Type.IDENT);
    }

    public IdentifierValue(String string) {
        super(CSSValue.Type.IDENT);
        this.stringValue = string;
        this.setPlainCssText(string);
    }

    protected IdentifierValue(IdentifierValue identifierValue) {
        super(identifierValue);
        this.stringValue = identifierValue.stringValue;
        this.setPlainCssText(identifierValue.getCssText());
    }

    @Override
    public void setCssText(String string) throws DOMException {
        LexicalUnit lexicalUnit;
        this.checkModifiableProperty();
        if (string == null || string.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        CSSParser cSSParser = new CSSParser();
        try {
            lexicalUnit = cSSParser.parsePropertyValue(new StringReader(string));
        }
        catch (IOException iOException) {
            lexicalUnit = null;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(5, "Bad identifier: " + string);
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT || lexicalUnit.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an identifier: " + string);
        }
        PrimitiveValue.LexicalSetter lexicalSetter = this.newLexicalSetter();
        lexicalSetter.setLexicalUnit(lexicalUnit);
    }

    @Override
    public String getMinifiedCssText(String string) {
        return ParseHelper.safeEscape(this.stringValue, false);
    }

    @Override
    public String getStringValue() {
        return this.stringValue;
    }

    @Override
    public void setStringValue(CSSValue.Type type, String string) throws DOMException {
        this.checkModifiableProperty();
        if (type != CSSValue.Type.IDENT) {
            throw new DOMException(13, "This value is an identifier. To have a new type, set it at the style-declaration level.");
        }
        if (string == null || string.length() == 0) {
            throw new DOMException(5, "Null or empty value.");
        }
        this.setStringValue(string);
        this.setPlainCssText(this.escape(this.stringValue));
    }

    private void setStringValue(String string) {
        this.stringValue = string.intern();
    }

    private String escape(String string) throws DOMException {
        return ParseHelper.safeEscape(string);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax) {
        switch (cSSValueSyntax.getCategory()) {
            case customIdent: {
                return CSSValueSyntax.Match.TRUE;
            }
            case IDENT: {
                return cSSValueSyntax.getName().equals(this.getStringValue()) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case color: {
                String string = this.getStringValue().toLowerCase(Locale.ROOT);
                return ColorIdentifiers.getInstance().isColorIdentifier(string) ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        String string = this.getStringValue().toLowerCase(Locale.ROOT);
        String string2 = "transparent".equals(string) ? "rgba(0,0,0,0)" : ColorIdentifiers.getInstance().getColor(string);
        if (string2 != null) {
            ValueFactory valueFactory = new ValueFactory();
            try {
                StyleValue styleValue = valueFactory.parseProperty(string2);
                if (styleValue.getCssValueType() == CSSValue.CssType.TYPED && styleValue.getPrimitiveType() == CSSValue.Type.COLOR) {
                    return ((TypedValue)styleValue).toRGBColor();
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        throw new DOMException(15, "Not an RGB Color");
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        String string = this.getStringValue();
        n2 = 31 * n2 + (string == null ? 0 : string.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        IdentifierValue identifierValue = (IdentifierValue)object;
        String string = this.getStringValue();
        String string2 = identifierValue.getStringValue();
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public IdentifierValue clone() {
        return new IdentifierValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(IdentifierValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            String string = lexicalUnit.getStringValue();
            IdentifierValue.this.setStringValue(string);
            if (lexicalUnit instanceof LexicalUnit) {
                IdentifierValue.this.setPlainCssText(lexicalUnit.getCssText());
            } else {
                IdentifierValue.this.setPlainCssText(IdentifierValue.this.escape(IdentifierValue.this.stringValue));
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
    }
}

