/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import org.w3c.dom.DOMException;

class PowFunctionUnitImpl
extends MathFunctionUnitImpl {
    private static final long serialVersionUID = 1L;

    public PowFunctionUnitImpl(int n) {
        super(n);
    }

    @Override
    public Dimension dimension(DimensionalAnalyzer dimensionalAnalyzer) throws DOMException {
        if (this.parameters == null) {
            throw new DOMException(12, "Missing argument in pow() function.");
        }
        Dimension dimension = dimensionalAnalyzer.expressionDimension(this.parameters.shallowClone());
        if (dimension != null && dimension.category != CSSValueSyntax.Category.number) {
            LexicalUnitImpl lexicalUnitImpl = this.parameters.nextLexicalUnit;
            if (lexicalUnitImpl == null || lexicalUnitImpl.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                throw new DOMException(12, "Expected comma in pow() function.");
            }
            LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl.nextLexicalUnit;
            if (lexicalUnitImpl2 == null) {
                throw new DOMException(12, "Missing argument in pow() function.");
            }
            if (lexicalUnitImpl2.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                dimension.exponent *= lexicalUnitImpl2.getIntegerValue();
            } else if (lexicalUnitImpl2.getLexicalUnitType() == LexicalUnit.LexicalType.REAL) {
                dimension.exponent = Math.round((float)dimension.exponent * lexicalUnitImpl2.getFloatValue());
            }
        }
        return dimension;
    }

    @Override
    PowFunctionUnitImpl instantiateLexicalUnit() {
        return new PowFunctionUnitImpl(this.getMathFunctionIndex());
    }
}

