/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Locale;
import java.util.Set;

class MaskBuilder
extends ShorthandBuilder {
    private StyleValue mskimage;
    private StyleValue mskposition;
    private StyleValue msksize;
    private StyleValue mskrepeat;
    private StyleValue mskorigin;
    private StyleValue mskclip;
    private StyleValue mskcomposite;
    private StyleValue mskmode;
    private boolean appended = false;

    MaskBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("mask", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 14;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        stringBuilder.append(this.getShorthandName()).append(':');
        this.mskimage = this.getCSSValue("mask-image");
        this.mskposition = this.computeMultipleSubproperty("mask-image", "mask-position");
        this.msksize = this.computeMultipleSubproperty("mask-image", "mask-size");
        this.mskrepeat = this.computeMultipleSubproperty("mask-image", "mask-repeat");
        this.mskorigin = this.computeMultipleSubproperty("mask-image", "mask-origin");
        this.mskclip = this.computeMultipleSubproperty("mask-image", "mask-clip");
        this.mskcomposite = this.computeMultipleSubproperty("mask-image", "mask-composite");
        this.mskmode = this.computeMultipleSubproperty("mask-image", "mask-mode");
        CSSValue.CssType cssType = this.mskimage.getCssValueType();
        if (cssType == CSSValue.CssType.LIST && ((ValueList)this.mskimage).isCommaSeparated()) {
            if (!this.appendLayered(stringBuilder, set, ((ValueList)this.mskimage).getLength())) {
                return 1;
            }
        } else {
            byte by = this.checkForCssKeyword(CSSValue.Type.INHERIT);
            if (by == 1) {
                stringBuilder.append("inherit");
                this.appendPriority(stringBuilder, bl);
                BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
                DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
                this.serializeMaskBorderIfNot(CSSValue.Type.INHERIT, bufferSimpleWriter, declarationFormattingContext, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            byte by2 = this.checkForCssKeyword(CSSValue.Type.REVERT);
            if (by2 == 1) {
                stringBuilder.append("revert");
                this.appendPriority(stringBuilder, bl);
                BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
                DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
                this.serializeMaskBorderIfNot(CSSValue.Type.REVERT, bufferSimpleWriter, declarationFormattingContext, bl);
                return 0;
            }
            if (by2 == 2) {
                return 1;
            }
            if (!this.appendImage(stringBuilder, this.mskimage)) {
                return 1;
            }
            if (!this.appendSingleLayer(stringBuilder, set)) {
                return 1;
            }
            if (!this.appended) {
                stringBuilder.append("none");
            }
        }
        this.appendPriority(stringBuilder, bl);
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        this.serializeMaskBorderIfNotInitial(bufferSimpleWriter, declarationFormattingContext, bl);
        return 0;
    }

    private StyleValue computeMultipleSubproperty(String string, String string2) {
        return this.getParentStyle().computeBoundProperty(string, string2, this.getCSSValue(string2));
    }

    private byte checkForCssKeyword(CSSValue.Type type) {
        int n = 0;
        if (MaskBuilder.isCssValueOfType(type, this.mskimage)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskposition)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.msksize)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskrepeat)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskorigin)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskclip)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskcomposite)) {
            n = (byte)(n + 1);
        }
        if (MaskBuilder.isCssValueOfType(type, this.mskmode)) {
            n = (byte)(n + 1);
        }
        switch (n) {
            case 0: {
                return 0;
            }
            case 8: {
                return 1;
            }
        }
        return 2;
    }

    private void appendText(StringBuilder stringBuilder, String string) {
        if (this.appended) {
            stringBuilder.append(' ');
        } else {
            this.appended = true;
        }
        stringBuilder.append(string);
    }

    private boolean appendLayered(StringBuilder stringBuilder, Set<String> set, int n) {
        int n2 = n - 1;
        if (!this.appendLayer(stringBuilder, set, 0, n2)) {
            return false;
        }
        for (int i = 1; i <= n2; ++i) {
            this.appended = false;
            stringBuilder.append(',');
            if (this.appendLayer(stringBuilder, set, i, n2)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder stringBuilder, Set<String> set, int n, int n2) {
        StyleValue styleValue;
        StyleValue styleValue2;
        StyleValue styleValue3;
        if (set.contains("mask-image") && !this.appendImage(stringBuilder, ((ValueList)this.mskimage).item(n))) {
            return false;
        }
        ValueList valueList = (ValueList)this.mskposition;
        StyleValue styleValue4 = set.contains("mask-position") ? valueList.item(n) : null;
        if (!this.appendPositionSize(stringBuilder, styleValue4, styleValue3 = set.contains("mask-size") ? ((ValueList)this.msksize).item(n) : null)) {
            return false;
        }
        if (set.contains("mask-repeat") && !this.appendRepeat(stringBuilder, ((ValueList)this.mskrepeat).item(n))) {
            return false;
        }
        boolean bl = set.contains("mask-clip");
        if ((set.contains("mask-origin") || bl) && !this.appendOriginClip(stringBuilder, styleValue2 = ((ValueList)this.mskorigin).item(n), styleValue = bl ? ((ValueList)this.mskclip).item(n) : null)) {
            return false;
        }
        if (set.contains("mask-composite") && !this.appendNonInheritedPty(stringBuilder, (valueList = (ValueList)this.mskcomposite).item(n), "mask-composite")) {
            return false;
        }
        if (set.contains("mask-mode") && !this.appendNonInheritedPty(stringBuilder, (valueList = (ValueList)this.mskmode).item(n), "mask-mode")) {
            return false;
        }
        int n3 = stringBuilder.length();
        if (n3 == 5 || stringBuilder.charAt(n3 - 1) == ',') {
            stringBuilder.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder stringBuilder, Set<String> set) {
        StyleValue styleValue;
        StyleValue styleValue2;
        StyleValue styleValue3;
        StyleValue styleValue4 = set.contains("mask-position") ? this.valueOrFirstItem(this.mskposition) : null;
        if (!this.appendPositionSize(stringBuilder, styleValue4, styleValue3 = set.contains("mask-size") ? this.valueOrFirstItem(this.msksize) : null)) {
            return false;
        }
        if (set.contains("mask-repeat") && !this.appendRepeat(stringBuilder, this.valueOrFirstItem(this.mskrepeat))) {
            return false;
        }
        boolean bl = set.contains("mask-clip");
        if ((set.contains("mask-origin") || bl) && !this.appendOriginClip(stringBuilder, styleValue2 = this.valueOrFirstItem(this.mskorigin), styleValue = bl ? this.valueOrFirstItem(this.mskclip) : null)) {
            return false;
        }
        if (set.contains("mask-composite") && !this.appendNonInheritedPty(stringBuilder, this.valueOrFirstItem(this.mskcomposite), "mask-composite")) {
            return false;
        }
        return !set.contains("mask-mode") || this.appendNonInheritedPty(stringBuilder, this.valueOrFirstItem(this.mskmode), "mask-mode");
    }

    private StyleValue valueOrFirstItem(StyleValue styleValue) {
        ValueList valueList;
        if (styleValue.getCssValueType() == CSSValue.CssType.LIST && (valueList = (ValueList)styleValue).isCommaSeparated()) {
            return valueList.item(0);
        }
        return styleValue;
    }

    private boolean appendImage(StringBuilder stringBuilder, StyleValue styleValue) {
        if (!this.isRevertValue(styleValue) && this.shorthandMaskImage(styleValue)) {
            this.appended = this.appendImage(stringBuilder, this.appended, styleValue);
            return true;
        }
        return false;
    }

    private boolean shorthandMaskImage(StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        if (cssType == CSSValue.CssType.TYPED) {
            TypedValue typedValue = (TypedValue)styleValue;
            CSSValue.Type type = typedValue.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                String string = typedValue.getStringValue();
                return "none".equalsIgnoreCase(string);
            }
            return MaskBuilder.isImagePrimitiveValue(typedValue);
        }
        return cssType == CSSValue.CssType.KEYWORD;
    }

    private boolean appendPositionSize(StringBuilder stringBuilder, StyleValue styleValue, StyleValue styleValue2) {
        Object object;
        boolean bl = false;
        if (styleValue != null) {
            object = styleValue.getCssValueType();
            String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
            if (this.isRevertValue(styleValue)) {
                return false;
            }
            if (object == CSSValue.CssType.TYPED) {
                this.appendText(stringBuilder, string);
                bl = true;
            } else if (object == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)styleValue;
                if (valueList.isCommaSeparated() || string.indexOf(92) != -1) {
                    return false;
                }
                if (!("0% 0%".equals(string) || "left top".equals(string) || "top left".equals(string))) {
                    if (valueList.getLength() != 2 || !"center".equals(valueList.item(1).getCssText())) {
                        this.appendText(stringBuilder, string);
                    } else {
                        this.appendText(stringBuilder, valueList.item(0).getCssText());
                    }
                    bl = true;
                }
            } else if (object == CSSValue.CssType.PROXY) {
                return false;
            }
        }
        if (styleValue2 != null) {
            if (!this.isRevertValue(styleValue2) && !MaskBuilder.isUnknownIdentifier("mask-size", styleValue2) && styleValue2.getCssValueType() != CSSValue.CssType.PROXY) {
                object = styleValue2.getMinifiedCssText("mask-size").toLowerCase(Locale.ROOT);
                if (!("auto".equals(object) || "auto auto".equals(object) || "initial".equals(object) || "unset".equals(object))) {
                    if (!bl) {
                        if (styleValue == null) {
                            styleValue = this.getCSSValue("mask-position");
                        }
                        this.appendText(stringBuilder, styleValue.getMinifiedCssText("mask-position"));
                    }
                    stringBuilder.append('/').append((String)object);
                    bl = true;
                }
            } else {
                return false;
            }
        }
        if (bl) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendRepeat(StringBuilder stringBuilder, StyleValue styleValue) {
        CSSValue.CssType cssType = styleValue.getCssValueType();
        String string = styleValue.getCssText().toLowerCase(Locale.ROOT);
        if (!MaskBuilder.isIdentOrKeyword(styleValue) || MaskBuilder.isUnknownIdentifier("mask-repeat", styleValue) || this.isRevertValue(styleValue) || string.indexOf(92) != -1) {
            return false;
        }
        if (cssType == CSSValue.CssType.TYPED) {
            if (!"repeat".equals(string)) {
                this.appendText(stringBuilder, string);
            }
        } else if (cssType == CSSValue.CssType.LIST) {
            ValueList valueList = (ValueList)styleValue;
            if (valueList.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(string)) {
                if ("no-repeat no-repeat".equals(string)) {
                    this.appendText(stringBuilder, "no-repeat");
                } else if ("space space".equals(string)) {
                    this.appendText(stringBuilder, "space");
                } else if ("round round".equals(string)) {
                    this.appendText(stringBuilder, "round");
                } else if ("repeat no-repeat".equals(string)) {
                    this.appendText(stringBuilder, "repeat-x");
                } else if ("no-repeat repeat".equals(string)) {
                    this.appendText(stringBuilder, "repeat-y");
                } else {
                    this.appendText(stringBuilder, string);
                }
            }
        }
        return true;
    }

    private boolean appendNonInheritedPty(StringBuilder stringBuilder, StyleValue styleValue, String string) {
        if (!this.isRevertValue(styleValue) && !MaskBuilder.isUnknownIdentifier(string, styleValue) && styleValue.getCssValueType() != CSSValue.CssType.PROXY) {
            String string2 = styleValue.getMinifiedCssText(string).toLowerCase(Locale.ROOT);
            if (this.isNotInitialValue(styleValue, string) && !"initial".equals(string2) && !"unset".equals(string2)) {
                this.appendText(stringBuilder, string2);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendOriginClip(StringBuilder stringBuilder, StyleValue styleValue, StyleValue styleValue2) {
        String string;
        boolean bl;
        String string2;
        boolean bl2;
        block14: {
            block15: {
                block13: {
                    block11: {
                        block12: {
                            block10: {
                                if (styleValue2 != null) break block10;
                                bl2 = true;
                                string2 = "border-box";
                                break block11;
                            }
                            if (styleValue2.getCssValueType() != CSSValue.CssType.KEYWORD) break block12;
                            switch (styleValue2.getPrimitiveType()) {
                                case INITIAL: 
                                case UNSET: {
                                    bl2 = true;
                                    string2 = "border-box";
                                    break block11;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        string2 = styleValue2.getMinifiedCssText().toLowerCase(Locale.ROOT);
                        bl2 = "border-box".equals(string2);
                    }
                    if (styleValue != null) break block13;
                    bl = true;
                    string = "border-box";
                    break block14;
                }
                if (styleValue.getCssValueType() != CSSValue.CssType.KEYWORD) break block15;
                switch (styleValue.getPrimitiveType()) {
                    case INITIAL: 
                    case UNSET: {
                        bl = true;
                        string = "border-box";
                        break block14;
                    }
                    default: {
                        return false;
                    }
                }
            }
            string = styleValue.getMinifiedCssText().toLowerCase(Locale.ROOT);
            bl = "border-box".equals(string);
        }
        if (!bl || !bl2) {
            if (MaskBuilder.getShorthandDatabase().isIdentifierValue("mask-origin", string) && MaskBuilder.getShorthandDatabase().isIdentifierValue("mask-clip", string2)) {
                this.appendText(stringBuilder, string);
                if (!string.equals(string2)) {
                    this.appendText(stringBuilder, string2);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isRevertValue(StyleValue styleValue) {
        return MaskBuilder.isCssValueOfType(CSSValue.Type.REVERT, styleValue);
    }

    private void serializeMaskBorderIfNot(CSSValue.Type type, BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, boolean bl) {
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-source", bl);
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-slice", bl);
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-width", bl);
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-outset", bl);
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-repeat", bl);
        this.appendDeclarationIfNotKeyword(type, bufferSimpleWriter, declarationFormattingContext, "mask-border-mode", bl);
    }

    private void serializeMaskBorderIfNotInitial(BufferSimpleWriter bufferSimpleWriter, DeclarationFormattingContext declarationFormattingContext, boolean bl) {
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-source", bl);
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-slice", bl);
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-width", bl);
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-outset", bl);
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-repeat", bl);
        this.appendDeclarationIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "mask-border-mode", bl);
    }
}

