/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSRectValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class RectValue
extends ComponentValue
implements CSSRectValue {
    private static final long serialVersionUID = 1L;
    protected Value top;
    protected Value right;
    protected Value bottom;
    protected Value left;

    public RectValue(Value value, Value value2, Value value3, Value value4) {
        this.setTop(value);
        this.setRight(value2);
        this.setBottom(value3);
        this.setLeft(value4);
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.RECT;
    }

    public String getCssText() {
        return "rect(" + this.top.getCssText() + ", " + this.right.getCssText() + ", " + this.bottom.getCssText() + ", " + this.left.getCssText() + ')';
    }

    public Value getTop() throws DOMException {
        return this.top;
    }

    public Value getRight() throws DOMException {
        return this.right;
    }

    public Value getBottom() throws DOMException {
        return this.bottom;
    }

    public Value getLeft() throws DOMException {
        return this.left;
    }

    void setTop(Value value) {
        this.top = this.component(value);
    }

    Value component(Value value) throws DOMSyntaxException {
        short s = value.getUnitType();
        if (s != 2 && s != 0 && !CSSUnit.isLengthUnitType((short)s) && value.getPrimitiveType() != CSSValue.Type.IDENT) {
            throw new DOMSyntaxException("rect() component must be a length or percentage.");
        }
        if (value.getModificationHandler() != null) {
            value = ((AbstractValue)value).clone();
        }
        this.componentize(value);
        return value;
    }

    void setRight(Value value) {
        this.right = this.component(value);
    }

    void setBottom(Value value) {
        this.bottom = this.component(value);
    }

    void setLeft(Value value) {
        this.left = this.component(value);
    }

    @Override
    public RectValue getRectValue() throws DOMException {
        return this;
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int n) throws DOMException {
        switch (n) {
            case 0: {
                return this.getTop();
            }
            case 1: {
                return this.getRight();
            }
            case 2: {
                return this.getBottom();
            }
            case 3: {
                return this.getLeft();
            }
        }
        return null;
    }

    @Override
    public RectValue clone() {
        RectValue rectValue = new RectValue(this.top, this.right, this.bottom, this.left);
        return rectValue;
    }
}

