/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class Undefined
implements Serializable {
    private static final long serialVersionUID = 9195680630202616767L;
    public static final Object instance = new Undefined();
    private static final int instanceHash = System.identityHashCode(instance);
    public static final Scriptable SCRIPTABLE_UNDEFINED = new Scriptable(){

        @Override
        public String getClassName() {
            return "undefined";
        }

        @Override
        public Object get(String string, Scriptable scriptable) {
            return NOT_FOUND;
        }

        @Override
        public Object get(int n, Scriptable scriptable) {
            return NOT_FOUND;
        }

        @Override
        public boolean has(String string, Scriptable scriptable) {
            return false;
        }

        @Override
        public boolean has(int n, Scriptable scriptable) {
            return false;
        }

        @Override
        public void put(String string, Scriptable scriptable, Object object) {
        }

        @Override
        public void put(int n, Scriptable scriptable, Object object) {
        }

        @Override
        public void delete(String string) {
        }

        @Override
        public void delete(int n) {
        }

        @Override
        public Scriptable getPrototype() {
            return null;
        }

        @Override
        public void setPrototype(Scriptable scriptable) {
        }

        @Override
        public Scriptable getParentScope() {
            return null;
        }

        @Override
        public void setParentScope(Scriptable scriptable) {
        }

        @Override
        public Object[] getIds() {
            return ScriptRuntime.emptyArgs;
        }

        @Override
        public Object getDefaultValue(Class<?> clazz) {
            if (clazz == null || clazz == ScriptRuntime.StringClass) {
                return this.toString();
            }
            return null;
        }

        @Override
        public boolean hasInstance(Scriptable scriptable) {
            return false;
        }

        public String toString() {
            return "undefined";
        }

        public boolean equals(Object object) {
            return Undefined.isUndefined(object) || super.equals(object);
        }

        public int hashCode() {
            return instanceHash;
        }
    };

    private Undefined() {
    }

    public Object readResolve() {
        return instance;
    }

    public boolean equals(Object object) {
        return Undefined.isUndefined(object) || super.equals(object);
    }

    public int hashCode() {
        return instanceHash;
    }

    public static boolean isUndefined(Object object) {
        return instance == object || SCRIPTABLE_UNDEFINED == object;
    }
}

