/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.concurrent.locks.StampedLock;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMapContainer;

class ThreadSafeSlotMapContainer
extends SlotMapContainer {
    private final StampedLock lock = new StampedLock();

    ThreadSafeSlotMapContainer() {
    }

    ThreadSafeSlotMapContainer(int n) {
        super(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        long l = this.lock.tryOptimisticRead();
        int n = this.map.size();
        if (this.lock.validate(l)) {
            return n;
        }
        l = this.lock.readLock();
        try {
            int n2 = this.map.size();
            return n2;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    @Override
    public int dirtySize() {
        assert (this.lock.isReadLocked());
        return this.map.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        long l = this.lock.tryOptimisticRead();
        boolean bl = this.map.isEmpty();
        if (this.lock.validate(l)) {
            return bl;
        }
        l = this.lock.readLock();
        try {
            boolean bl2 = this.map.isEmpty();
            return bl2;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot modify(Object object, int n, int n2) {
        long l = this.lock.writeLock();
        try {
            this.checkMapSize();
            Slot slot = this.map.modify(object, n, n2);
            return slot;
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(Slot slot, Slot slot2) {
        long l = this.lock.writeLock();
        try {
            this.map.replace(slot, slot2);
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Slot query(Object object, int n) {
        long l = this.lock.tryOptimisticRead();
        Slot slot = this.map.query(object, n);
        if (this.lock.validate(l)) {
            return slot;
        }
        l = this.lock.readLock();
        try {
            Slot slot2 = this.map.query(object, n);
            return slot2;
        }
        finally {
            this.lock.unlockRead(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Slot slot) {
        long l = this.lock.writeLock();
        try {
            this.checkMapSize();
            this.map.add(slot);
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object object, int n) {
        long l = this.lock.writeLock();
        try {
            this.map.remove(object, n);
        }
        finally {
            this.lock.unlockWrite(l);
        }
    }

    @Override
    public long readLock() {
        return this.lock.readLock();
    }

    @Override
    public void unlockRead(long l) {
        this.lock.unlockRead(l);
    }

    @Override
    public Iterator<Slot> iterator() {
        assert (this.lock.isReadLocked());
        return this.map.iterator();
    }

    @Override
    protected void checkMapSize() {
        assert (this.lock.isWriteLocked());
        super.checkMapSize();
    }
}

