/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Comparator;

public final class Sorting {
    private static final int SMALLSORT = 16;
    private static final Sorting sorting = new Sorting();

    private Sorting() {
    }

    public static Sorting get() {
        return sorting;
    }

    public void insertionSort(Object[] objectArray, Comparator<Object> comparator) {
        Sorting.insertionSort(objectArray, 0, objectArray.length - 1, comparator);
    }

    private static void insertionSort(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        for (int i = n; i <= n2; ++i) {
            Object object = objectArray[i];
            for (int j = i - 1; j >= n && comparator.compare(objectArray[j], object) > 0; --j) {
                objectArray[j + 1] = objectArray[j];
            }
            objectArray[j + 1] = object;
        }
    }

    public void hybridSort(Object[] objectArray, Comparator<Object> comparator) {
        this.hybridSort(objectArray, 0, objectArray.length - 1, comparator, Sorting.log2(objectArray.length) * 2);
    }

    private void hybridSort(Object[] objectArray, int n, int n2, Comparator<Object> comparator, int n3) {
        if (n < n2) {
            if (n3 == 0 || n2 - n <= 16) {
                Sorting.insertionSort(objectArray, n, n2, comparator);
            } else {
                int n4 = this.partition(objectArray, n, n2, comparator);
                this.hybridSort(objectArray, n, n4, comparator, n3 - 1);
                this.hybridSort(objectArray, n4 + 1, n2, comparator, n3 - 1);
            }
        }
    }

    private int partition(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        int n3 = this.median(objectArray, n, n2, comparator);
        Object object = objectArray[n3];
        objectArray[n3] = objectArray[n];
        objectArray[n] = object;
        int n4 = n;
        int n5 = n2 + 1;
        while (true) {
            if (comparator.compare(objectArray[++n4], object) < 0 && n4 != n2) {
                continue;
            }
            while (comparator.compare(objectArray[--n5], object) >= 0 && n5 != n) {
            }
            if (n4 >= n5) break;
            Sorting.swap(objectArray, n4, n5);
        }
        Sorting.swap(objectArray, n, n5);
        return n5;
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static int log2(int n) {
        return (int)(Math.log10(n) / Math.log10(2.0));
    }

    public int median(Object[] objectArray, int n, int n2, Comparator<Object> comparator) {
        int n3 = n;
        int n4 = n + (n2 - n) / 2;
        if (comparator.compare(objectArray[n3], objectArray[n4]) > 0) {
            n3 = n4;
        }
        if (comparator.compare(objectArray[n3], objectArray[n2]) > 0) {
            n3 = n2;
        }
        if (n3 == n) {
            return comparator.compare(objectArray[n4], objectArray[n2]) < 0 ? n4 : n2;
        }
        if (n3 == n4) {
            return comparator.compare(objectArray[n], objectArray[n2]) < 0 ? n : n2;
        }
        return comparator.compare(objectArray[n], objectArray[n4]) < 0 ? n : n4;
    }
}

