/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.IconListComponent;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.ui.MouseEventActor;
import org.freeplane.view.swing.ui.mindmapmode.TrashBin;

public class MNodeDragListener
implements DragGestureListener {
    public void addDragListener(MainView mainView) {
        this.addDragListenerToComponent((Component)mainView);
    }

    public void addDragListener(IconListComponent iconListComponent) {
        this.addDragListenerToComponent((Component)iconListComponent);
    }

    private void addDragListenerToComponent(Component component) {
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(component, 0x40000003, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        TagIcon tag;
        Rectangle bounds;
        Component component = e.getComponent();
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, component);
        MapView mapView = nodeView.getMap();
        mapView.select();
        if (!nodeView.isSelected()) {
            MouseEventActor.INSTANCE.withMouseEvent(() -> nodeView.getMap().selectAsTheOnlyOneSelected(nodeView));
        }
        if (!(bounds = new Rectangle(0, 0, component.getWidth(), component.getHeight())).contains(e.getDragOrigin())) {
            return;
        }
        if (component instanceof MainView) {
            tag = ((MainView)component).getTagIconAt(e.getDragOrigin());
        } else {
            if (!(component instanceof IconListComponent)) return;
            Icon icon = ((IconListComponent)component).getIconAt(e.getDragOrigin());
            if (!(icon instanceof TagIcon)) return;
            tag = (TagIcon)icon;
        }
        if (tag != null) {
            this.startTagDrag(e, nodeView, tag);
            return;
        } else {
            this.startNodeDrag(e, nodeView);
        }
    }

    private void startTagDrag(DragGestureEvent e, final NodeView nodeView, TagIcon tagIcon) {
        int dragActionType = e.getDragAction();
        if (dragActionType == 0x40000000 || this.isLinkDragEvent(e)) {
            return;
        }
        Cursor cursor = this.getCursorByAction(dragActionType);
        final Tag tag = tagIcon.getTag().qualifiedTag();
        TagSelection t = new TagSelection(UUID.randomUUID(), tag.getContent() + ColorUtils.colorToRGBAString((Color)tag.getColor()));
        if ((e.getTriggerEvent().getModifiersEx() & 0x800) != 0) {
            cursor = DragSource.DefaultCopyDrop;
            dragActionType = 1;
            t.setDropAction(dragActionType);
        }
        try {
            BufferedImage image = new BufferedImage(tagIcon.getIconWidth(), tagIcon.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            tagIcon.paintIcon(e.getComponent(), (Graphics)graphics, 0, 0);
            final DragSourceListener trashBinListener = dragActionType == 2 ? TrashBin.INSTANCE.showTrashBin(e, () -> {}) : null;
            final int effectiveDragActionType = dragActionType;
            e.startDrag(cursor, image, new Point(), t, new DragSourceAdapter(){

                @Override
                public void dragDropEnd(DragSourceDropEvent dsde) {
                    if (trashBinListener != null) {
                        trashBinListener.dragDropEnd(dsde);
                    }
                    if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && effectiveDragActionType == 2) {
                        SwingUtilities.invokeLater(() -> MNodeDragListener.this.removeTag(nodeView.getNode(), tag));
                    }
                }
            });
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    private void removeTag(NodeModel node, Tag tag) {
        ((MIconController)IconController.getController()).removeTags(node, Collections.singleton(tag));
    }

    private void startNodeDrag(DragGestureEvent e, NodeView nodeView) {
        int dragActionType = e.getDragAction();
        if (dragActionType == 2 && nodeView.isRoot() && !this.isLinkDragEvent(e)) {
            return;
        }
        if (dragActionType == 0x40000000) {
            return;
        }
        Cursor cursor = this.getCursorByAction(dragActionType);
        Transferable t = MapClipboardController.getController().copy(Controller.getCurrentController().getSelection());
        if (this.isLinkDragEvent(e)) {
            cursor = DragSource.DefaultLinkDrop;
            ((MindMapNodesSelection)t).setDropAction(Integer.valueOf(0x40000000));
        } else if ((e.getTriggerEvent().getModifiersEx() & 0x800) != 0) {
            cursor = DragSource.DefaultCopyDrop;
            ((MindMapNodesSelection)t).setDropAction(Integer.valueOf(1));
        }
        try {
            e.startDrag(cursor, t, new DragSourceAdapter(){});
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    private boolean isLinkDragEvent(DragGestureEvent e) {
        return (e.getTriggerEvent().getModifiersEx() & 0x1000) != 0;
    }

    public Cursor getCursorByAction(int dragAction) {
        switch (dragAction) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }
}

