/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.undo.IActor;
import org.freeplane.core.util.ConfigurationUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.clipboard.ClipboardControllers;
import org.freeplane.features.clipboard.mindmapmode.MClipboardControllers;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.DocuMapAttribute;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FirstGroupNode;
import org.freeplane.features.map.FirstGroupNodeFlag;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.INodeSelectionListener;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.map.SummaryNodeFlag;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.mindmapmode.ConvertCloneToIndependentNodeAction;
import org.freeplane.features.map.mindmapmode.DeleteAction;
import org.freeplane.features.map.mindmapmode.MMapModel;
import org.freeplane.features.map.mindmapmode.NewChildAction;
import org.freeplane.features.map.mindmapmode.NewFreeNodeAction;
import org.freeplane.features.map.mindmapmode.NewMapViewAction;
import org.freeplane.features.map.mindmapmode.NewPreviousSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSiblingAction;
import org.freeplane.features.map.mindmapmode.NewSummaryAction;
import org.freeplane.features.map.mindmapmode.NodeDownAction;
import org.freeplane.features.map.mindmapmode.NodeUpAction;
import org.freeplane.features.map.mindmapmode.SummaryGroupEdgeListAdder;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.mode.mindmapmode.MModeController;
import org.freeplane.features.nodelocation.mindmapmode.MLocationController;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.mindmapmode.MNoteController;
import org.freeplane.features.styles.LogicalStyleKeys;
import org.freeplane.features.styles.LogicalStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.features.styles.mindmapmode.NewNodeStyle;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.features.ui.ViewController;
import org.freeplane.features.url.NodeAndMapReference;
import org.freeplane.features.url.mindmapmode.MFileManager;
import org.freeplane.features.url.mindmapmode.MapLoader;
import org.freeplane.main.addons.AddOnsController;
import org.freeplane.n3.nanoxml.XMLException;
import org.freeplane.n3.nanoxml.XMLParseException;

public class MMapController
extends MapController {
    public static final int NEW_CHILD = 2;
    public static final int NEW_SIBLING_BEFORE = 4;
    public static final int NEW_SIBLING_BEHIND = 3;
    public static final String RESOURCES_CONVERT_TO_CURRENT_VERSION = "convert_to_current_version";
    private WeakHashMap<MMapModel, Void> loadedMaps = new WeakHashMap();
    private static final List<String> foldingSavedOptions = Arrays.asList("always_save_folding", "save_folding_if_map_is_changed");

    public MMapController(ModeController modeController) {
        super(modeController);
        this.createActions(modeController);
        this.addNodeSelectionListener(new INodeSelectionListener(){

            public void onSelect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                if (ResourceController.getResourceController().getBooleanProperty("display_node_id")) {
                    viewController.addStatusInfo("display_node_id", "ID=" + node.createID(), null);
                }
            }

            public void onDeselect(NodeModel node) {
                ViewController viewController = Controller.getCurrentController().getViewController();
                viewController.addStatusInfo("display_node_id", null, null);
            }
        });
    }

    public NodeModel addNewNode(int newNodeMode) {
        NodeModel newNode;
        KeyEvent currentKeyEvent = this.getCurrentKeyEvent();
        this.stopInlineEditing();
        IMapSelection selection = Controller.getCurrentController().getSelection();
        NodeModel targetNode = selection.getSelected();
        switch (newNodeMode) {
            case 3: 
            case 4: {
                if (!targetNode.isRoot()) {
                    int index;
                    NodeModel parent = targetNode.getParentNode();
                    int childPosition = parent.getIndex(targetNode);
                    if (newNodeMode == 3) {
                        ++childPosition;
                    }
                    if ((newNode = this.addNewNode(parent, index = childPosition, (NodeModel node) -> {
                        node.setSide(targetNode.getSide());
                        NewNodeStyle.assignStyleToNewNode(node);
                    })) == null) {
                        return null;
                    }
                    if (ResourceController.getResourceController().getBooleanProperty("copyFormatToNewSibling")) {
                        this.copyFormat(targetNode, newNode);
                    }
                    this.select(newNode);
                    this.startEditing(newNode, currentKeyEvent);
                    break;
                }
                newNodeMode = 2;
            }
            case 2: {
                NodeModel.Side newChildSide;
                NodeModel.Side side;
                int position;
                boolean targetFolded = this.isFolded(targetNode);
                Controller controller = this.getModeController().getController();
                IMapViewManager mapViewManager = controller.getMapViewManager();
                if (targetFolded) {
                    if (!targetNode.isRoot() && mapViewManager.hasHiddenChildren(targetNode.getParentNode())) {
                        mapViewManager.hideChildren(targetNode);
                        targetNode.setFolded(false);
                    } else {
                        this.unfold(targetNode, controller.getSelection().getFilter());
                    }
                }
                if ((newNode = this.addNewNode(targetNode, position = this.findNewNodePosition(targetNode), arg_0 -> MMapController.lambda$addNewNode$1(side = (newChildSide = targetNode.suggestNewChildSide(selection.getSelectionRoot())), arg_0))) == null) {
                    return null;
                }
                if (ResourceController.getResourceController().getBooleanProperty("copyFormatToNewChild")) {
                    this.copyFormat(targetNode, newNode);
                }
                this.select(newNode);
                this.startEditing(newNode, currentKeyEvent);
                break;
            }
            default: {
                newNode = null;
            }
        }
        return newNode;
    }

    public int findNewNodePosition(NodeModel targetNode) {
        boolean placeAsFirstChild = this.placesNewChildFirst(targetNode);
        IMapViewManager mapViewManager = this.getModeController().getController().getMapViewManager();
        int position = placeAsFirstChild ? 0 : targetNode.getChildCount() - mapViewManager.getHiddenChildCount(targetNode);
        return position;
    }

    public boolean placesNewChildFirst(NodeModel targetNode) {
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)targetNode.getMap());
        MapViewLayout layoutType = mapStyleModel.getMapViewLayout();
        boolean placeAsFirstChild = layoutType == MapViewLayout.OUTLINE || ResourceController.getResourceController().getProperty("placenewbranches").equals("first");
        return placeAsFirstChild;
    }

    private void copyFormat(NodeModel source, NodeModel target) {
        this.getMModeController().copyExtensions(LogicalStyleKeys.NODE_STYLE, source, target);
        this.getMModeController().copyExtensions(LogicalStyleKeys.LOGICAL_STYLE, source, target);
        if (ResourceController.getResourceController().getBooleanProperty("copyFormatToNewNodeIncludesIcons")) {
            this.getMModeController().copyExtensions((Object)MIconController.Keys.ICONS, source, target);
        }
    }

    protected MapClipboardController createMapClipboardController() {
        MMapClipboardController mapClipboardController = new MMapClipboardController(this.getMModeController());
        MClipboardControllers extension = (MClipboardControllers)this.getModeController().getExtension(ClipboardControllers.class);
        extension.add(mapClipboardController);
        return mapClipboardController;
    }

    private void startEditing(NodeModel newNode, KeyEvent currentKeyEvent) {
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return;
        }
        TextController textController = TextController.getController();
        ((MTextController)textController).edit(newNode, newNode.getParentNode(), true, false, false, currentKeyEvent);
    }

    private KeyEvent getCurrentKeyEvent() {
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof KeyEvent) {
            return (KeyEvent)currentEvent;
        }
        return null;
    }

    private void stopInlineEditing() {
        NoteController noteController;
        TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopInlineEditing();
        }
        if ((noteController = NoteController.getController()) instanceof MNoteController) {
            ((MNoteController)noteController).stopEditing();
        }
    }

    public void addNewSummaryNodeStartEditing(NodeModel selectionRoot, NodeModel parentNode, int start, int end, boolean isTopOrLeft) {
        SummaryLevels summaryLevels = new SummaryLevels(selectionRoot, parentNode);
        if (!summaryLevels.canInsertSummaryNode(start, end, isTopOrLeft)) {
            return;
        }
        MModeController modeController = this.getMModeController();
        this.stopInlineEditing();
        NodeModel.Side side = parentNode.getChildAt(end).getSide();
        NodeModel newSummaryNode = this.addNewNode(parentNode, end + 1, side);
        SummaryNode summary = (SummaryNode)modeController.getExtension(SummaryNode.class);
        summary.undoableActivateHook(newSummaryNode, (IExtension)SummaryNodeFlag.SUMMARY);
        AlwaysUnfoldedNode unfolded = (AlwaysUnfoldedNode)modeController.getExtension(AlwaysUnfoldedNode.class);
        unfolded.undoableActivateHook(newSummaryNode, (IExtension)unfolded);
        FirstGroupNode firstGroupNodeHook = (FirstGroupNode)modeController.getExtension(FirstGroupNode.class);
        NodeModel startNode = parentNode.getChildAt(start);
        if (SummaryNode.isSummaryNode((NodeModel)startNode)) {
            firstGroupNodeHook.undoableActivateHook(startNode, (IExtension)FirstGroupNodeFlag.FIRST_GROUP);
        } else {
            this.addNewFirstGroupNode(parentNode, start, newSummaryNode.getSide());
        }
        NodeModel firstSummaryChildNode = this.addNewNode(newSummaryNode, 0, (NodeModel node) -> {
            node.setSide(NodeModel.Side.DEFAULT);
            NewNodeStyle.assignStyleToNewNode(node);
        });
        KeyEvent currentKeyEvent = this.getCurrentKeyEvent();
        this.select(firstSummaryChildNode);
        this.startEditing(firstSummaryChildNode, currentKeyEvent);
    }

    private void addNewFirstGroupNode(NodeModel parentNode, int start, NodeModel.Side side) {
        this.addNewNode(parentNode, start, (NodeModel n) -> {
            n.setSide(side);
            n.addExtension((IExtension)FirstGroupNodeFlag.FIRST_GROUP);
        });
    }

    public NodeModel addNewNode(NodeModel parent, int index, NodeModel.Side side) {
        return this.addNewNode(parent, index, (NodeModel node) -> node.setSide(side));
    }

    public NodeModel addNewNode(NodeModel parent, int index, Consumer<NodeModel> configurator) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return null;
        }
        NodeModel newNode = this.newNode("", parent.getMap());
        configurator.accept(newNode);
        if (this.addNewNode(newNode, parent, index)) {
            return newNode;
        }
        return null;
    }

    public boolean addNewNode(NodeModel newNode, NodeModel parent, int index) {
        if (!this.isWriteable(parent)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return false;
        }
        this.insertNewNode(newNode, parent, index);
        return true;
    }

    private void insertNewNode(NodeModel newNode, NodeModel parent, int index) {
        if (index < 0 || index > parent.getChildCount()) {
            this.insertNewNode(newNode, parent, parent.getChildCount());
            return;
        }
        if (newNode.subtreeContainsCloneOf(parent)) {
            UITools.errorMessage((Object)"not allowed");
            return;
        }
        this.stopInlineEditing();
        this.insertSingleNewNode(newNode, parent, index);
        for (NodeModel parentClone : parent.subtreeClones()) {
            if (parentClone == parent) continue;
            NodeModel childClone = newNode.cloneTree();
            this.insertSingleNewNode(childClone, parentClone, index);
        }
    }

    private void insertSingleNewNode(final NodeModel newNode, final NodeModel parent, final int index) {
        MapModel map = parent.getMap();
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.insertNodeIntoWithoutUndo(newNode, parent, index);
            }

            public String getDescription() {
                return "addNewNode";
            }

            public void undo() {
                MMapController.this.deleteWithoutUndo(parent, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, map);
    }

    public synchronized void closeWithoutSaving(MapModel map) {
        this.loadedMaps.remove(map);
        super.closeWithoutSaving(map);
    }

    private void createActions(ModeController modeController) {
        modeController.addAction((AFreeplaneAction)new NewMapViewAction());
        modeController.addAction((AFreeplaneAction)new NewSiblingAction());
        modeController.addAction((AFreeplaneAction)new NewPreviousSiblingAction());
        modeController.addAction((AFreeplaneAction)new NewChildAction());
        modeController.addAction((AFreeplaneAction)new NewSummaryAction());
        modeController.addAction((AFreeplaneAction)new NewFreeNodeAction());
        modeController.addAction((AFreeplaneAction)new DeleteAction());
        modeController.addAction((AFreeplaneAction)new NodeUpAction());
        modeController.addAction((AFreeplaneAction)new NodeDownAction());
        modeController.addAction((AFreeplaneAction)new ConvertCloneToIndependentNodeAction());
    }

    public void deleteNode(NodeModel node) {
        this.deleteNodes(Arrays.asList(node));
    }

    public void deleteNodes(List<NodeModel> nodes) {
        List<NodeModel> deletedNodesWithSummaryGroupIndicators = new SummaryGroupEdgeListAdder(nodes).addSummaryEdgeNodes();
        for (NodeModel node : deletedNodesWithSummaryGroupIndicators) {
            this.deleteSingleNodeWithClones(node);
        }
    }

    public void convertClonesToIndependentNodes(NodeModel node) {
        MLinkController linkController = (MLinkController)MLinkController.getController();
        if (node.isCloneTreeRootOrContentClone()) {
            linkController.deleteMapLinksForClone(node);
            this.convertCloneToNode(node);
            linkController.insertMapLinksForClone(node);
        }
    }

    private void convertCloneToNode(final NodeModel node) {
        final NodeModel duplicate = node.duplicate(false);
        IActor converter = new IActor(){

            public void act() {
                node.swapData(duplicate);
                MMapController.this.nodeChanged(node);
            }

            public void undo() {
                node.swapData(duplicate);
                MMapController.this.nodeChanged(node);
            }

            public String getDescription() {
                return "convertClonesToIndependentNodes";
            }
        };
        boolean shouldConvertChildNodes = node.subtreeClones().size() > 1;
        MModeController mModeController = this.getMModeController();
        mModeController.execute(converter, node.getMap());
        if (shouldConvertChildNodes) {
            for (NodeModel child : node.getChildren()) {
                this.convertCloneToNode(child);
            }
        }
    }

    private void deleteSingleNodeWithClones(NodeModel node) {
        NodeModel parentNode = node.getParentNode();
        int index = parentNode.getIndex(node);
        for (NodeModel parentClone : parentNode.subtreeClones()) {
            this.deleteSingleNode(parentClone, index);
        }
    }

    private void deleteSingleSummaryNode(NodeModel node) {
        boolean shouldDeleteSummaryNodeWithoutChildren;
        boolean bl = shouldDeleteSummaryNodeWithoutChildren = !node.getMap().isUndoActionRunning() && !node.isFolded() && !node.hasChildren() && SummaryNode.isSummaryNode((NodeModel)node) && node.getText().isEmpty();
        if (shouldDeleteSummaryNodeWithoutChildren) {
            NodeModel summaryParent = node.getParentNode();
            SummaryLevels summaryLevels = new SummaryLevels(summaryParent, summaryParent);
            int summaryNodeIndex = node.getIndex();
            int groupBeginNodeIndex = summaryLevels.findGroupBeginNodeIndex(summaryNodeIndex - 1);
            this.deleteSingleNode(summaryParent, summaryNodeIndex);
            NodeModel groupBeginNode = summaryParent.getChildAt(groupBeginNodeIndex);
            if (SummaryNode.isFirstGroupNode((NodeModel)groupBeginNode)) {
                if (SummaryNode.isSummaryNode((NodeModel)groupBeginNode)) {
                    FirstGroupNode firstGroupNodeHook = (FirstGroupNode)this.getModeController().getExtension(FirstGroupNode.class);
                    firstGroupNodeHook.undoableDeactivateHook(groupBeginNode);
                } else {
                    this.deleteSingleNode(summaryParent, groupBeginNodeIndex);
                }
            }
        }
    }

    private void deleteSingleNode(final NodeModel parentNode, final int index) {
        final NodeModel node = parentNode.getChildAt(index);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.deleteWithoutUndo(parentNode, index);
            }

            public String getDescription() {
                return "delete";
            }

            public void undo() {
                MMapController.this.insertNodeIntoWithoutUndo(node, parentNode, index);
            }
        };
        Controller.getCurrentModeController().execute(actor, parentNode.getMap());
    }

    private void deleteWithoutUndo(NodeModel parent, int index) {
        NodeModel child = parent.getChildAt(index);
        NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(parent, child, index);
        this.firePreNodeDelete(nodeDeletionEvent);
        MapModel map = parent.getMap();
        this.mapSaved(map, false);
        parent.remove(index);
        this.fireNodeDeleted(nodeDeletionEvent);
        this.deleteSingleSummaryNode(nodeDeletionEvent.parent);
    }

    public MModeController getMModeController() {
        return (MModeController)this.getModeController();
    }

    public void insertNode(NodeModel node, NodeModel parent) {
        this.insertNode(node, parent, this.findNewNodePosition(parent));
    }

    public void insertNode(NodeModel node, NodeModel target, boolean asSibling) {
        NodeModel parent = asSibling ? target.getParentNode() : target;
        if (asSibling) {
            this.insertNode(node, parent, parent.getIndex(target));
        } else {
            this.insertNode(node, parent, this.findNewNodePosition(target));
        }
    }

    public void insertNode(NodeModel node, NodeModel parentNode, int index) {
        this.insertNewNode(node, parentNode, index);
    }

    public void insertNodeIntoWithoutUndo(NodeModel newNode, NodeModel parent, int index) {
        this.mapSaved(parent.getMap(), false);
        super.insertNodeIntoWithoutUndo(newNode, parent, index);
    }

    public boolean isWriteable(NodeModel targetNode) {
        EncryptionModel encryptionModel = EncryptionModel.getModel((NodeModel)targetNode);
        if (encryptionModel != null) {
            return encryptionModel.isAccessible();
        }
        return true;
    }

    public void moveNode(NodeModel node, int newIndex) {
        this.moveNodes(Arrays.asList(node), node.getParentNode(), newIndex);
    }

    public void moveNodes(List<NodeModel> movedNodes, NodeModel newParent, int newIndex) {
        List<NodeModel> movedNodesWithSummaryGroupIndicators = new SummaryGroupEdgeListAdder(movedNodes).addSummaryEdgeNodes();
        int index = newIndex;
        for (NodeModel node : movedNodesWithSummaryGroupIndicators) {
            NodeModel childNode;
            int oldIndex;
            NodeModel oldParent = node.getParentNode();
            if (!newParent.subtreeClones().contains(oldParent) || (oldIndex = oldParent.getIndex(childNode = node)) < newIndex) {
                // empty if block
            }
            int n = --index;
            ++index;
            this.moveNodeAndItsClones(node, newParent, n);
        }
        this.balanceFirstGroupNodes(newParent);
    }

    public void setSide(List<NodeModel> nodes, final NodeModel.Side side) {
        List<NodeModel> movedNodesWithSummaryGroupIndicators = new SummaryGroupEdgeListAdder(nodes).addSummaryEdgeNodes();
        for (final NodeModel node : movedNodesWithSummaryGroupIndicators) {
            final NodeModel.Side oldSide = node.getSide();
            if (oldSide == side) continue;
            IActor sideChangeActor = new IActor(){

                public void act() {
                    node.setSide(side);
                    MMapController.this.delayedNodeRefresh(node, NodeModel.Side.class, oldSide, side);
                }

                public void undo() {
                    node.setSide(oldSide);
                    MMapController.this.delayedNodeRefresh(node, NodeModel.Side.class, side, oldSide);
                }

                public String getDescription() {
                    return "change side";
                }
            };
            this.getModeController().execute(sideChangeActor, node.getMap());
        }
        nodes.stream().map(NodeModel::getParentNode).distinct().forEach(this::balanceFirstGroupNodes);
    }

    public void moveNodeAndItsClones(NodeModel child, NodeModel newParent, int newIndex) {
        if (child.subtreeContainsCloneOf(newParent)) {
            UITools.errorMessage((Object)"not allowed");
            return;
        }
        NodeModel oldParent = child.getParentNode();
        if (oldParent == null) {
            UITools.errorMessage((Object)"not allowed");
            return;
        }
        if (newParent != oldParent && newParent.subtreeClones().contains(oldParent)) {
            this.moveNodeAndItsClones(child, oldParent, newIndex);
            return;
        }
        int oldIndex = oldParent.getIndex(child);
        int childCount = newParent.getChildCount();
        int n = newIndex >= childCount ? (oldParent == newParent ? childCount - 1 : childCount) : (newIndex = newIndex);
        if (oldParent != newParent) {
            NodeModel.Side newSide;
            if (oldParent.isHiddenSummary()) {
                newSide = oldParent.getSide();
            } else {
                NodeModel.Side oldSide = child.isTopOrLeft(newParent) ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT;
                newSide = MapController.suggestNewChildSide((NodeModel)newParent, (NodeModel.Side)oldSide);
            }
            this.setSide(Collections.singletonList(child), newSide);
        }
        if (oldParent != newParent || oldIndex != newIndex) {
            NodeRelativePath nodeRelativePath = this.getPathToNearestTargetClone(oldParent, newParent);
            HashSet oldParentClones = new HashSet(oldParent.subtreeClones().toCollection());
            HashSet newParentClones = new HashSet(newParent.subtreeClones().toCollection());
            NodeModel commonAncestor = nodeRelativePath.commonAncestor();
            for (NodeModel commonAncestorClone : commonAncestor.subtreeClones()) {
                NodeModel oldParentClone = nodeRelativePath.pathBegin(commonAncestorClone);
                NodeModel newParentClone = nodeRelativePath.pathEnd(commonAncestorClone);
                this.moveSingleNode(oldParentClone.getChildAt(oldIndex), newParentClone, newIndex);
                oldParentClones.remove(oldParentClone);
                newParentClones.remove(newParentClone);
            }
            for (NodeModel newParentClone : newParentClones) {
                this.insertSingleNewNode(child.cloneTree(), newParentClone, newIndex);
            }
            for (NodeModel oldParentClone : oldParentClones) {
                this.deleteSingleNode(oldParentClone, oldIndex);
            }
        }
    }

    private NodeRelativePath getPathToNearestTargetClone(NodeModel source, NodeModel target) {
        if (source == target) {
            return new NodeRelativePath(source, target);
        }
        Clones targetClones = target.subtreeClones();
        int pathNumber = targetClones.size();
        if (pathNumber == 1) {
            return new NodeRelativePath(source, target);
        }
        ArrayList<NodeRelativePath> paths = new ArrayList<NodeRelativePath>(pathNumber);
        for (NodeModel targetClone : targetClones) {
            paths.add(new NodeRelativePath(source, targetClone));
        }
        NodeRelativePath shortestPath = Collections.min(paths, new Comparator<NodeRelativePath>(){

            @Override
            public int compare(NodeRelativePath o1, NodeRelativePath o2) {
                return o1.getPathLength() - o2.getPathLength();
            }
        });
        return shortestPath;
    }

    private void moveSingleNode(final NodeModel child, final NodeModel newParent, final int newIndex) {
        final NodeModel oldParent = child.getParentNode();
        final int oldIndex = oldParent.getIndex(child);
        IActor actor = new IActor(){

            public void act() {
                MMapController.this.moveNodeToWithoutUndo(child, newParent, newIndex);
            }

            public String getDescription() {
                return "moveNode";
            }

            public void undo() {
                MMapController.this.moveNodeToWithoutUndo(child, oldParent, oldIndex);
            }
        };
        Controller.getCurrentModeController().execute(actor, newParent.getMap());
    }

    public void moveNodesAsChildren(List<NodeModel> children, NodeModel target) {
        FreeNode r = (FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class);
        for (NodeModel node : children) {
            IExtension extension = node.getExtension(FreeNode.class);
            if (extension == null) continue;
            r.undoableToggleHook(node, extension);
            if (!MapStyleModel.FLOATING_STYLE.equals((Object)LogicalStyleModel.getStyle((NodeModel)node))) continue;
            ((MLogicalStyleController)MLogicalStyleController.getController((ModeController)this.getMModeController())).setStyle(node, null);
        }
        int position = target.getChildCount();
        this.moveNodes(children, target, position);
    }

    public void moveNodesBefore(List<NodeModel> children, NodeModel target) {
        NodeModel newParent = target.getParentNode();
        int newIndex = newParent.getIndex(target);
        for (NodeModel node : children) {
            ((FreeNode)Controller.getCurrentModeController().getExtension(FreeNode.class)).undoableDeactivateHook(node);
        }
        this.moveNodes(children, newParent, newIndex);
    }

    public void moveNodesInGivenDirection(NodeModel selectionRoot, NodeModel selected, Collection<NodeModel> movedNodes, int direction) {
        Comparator<Object> comparator;
        List<NodeModel> movedNodesWithEdges = new SummaryGroupEdgeListAdder(movedNodes).addSummaryEdgeNodes();
        HashSet<NodeModel> movedNodeSet = new HashSet<NodeModel>(movedNodesWithEdges);
        Comparator<Object> comparator2 = comparator = direction == -1 ? null : new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int i1 = (Integer)o1;
                int i2 = (Integer)o2;
                return i2 - i1;
            }
        };
        if (movedNodeSet.size() == 0) {
            return;
        }
        NodeModel oneMovedNode = (NodeModel)movedNodeSet.iterator().next();
        NodeModel parent = oneMovedNode.getParentNode();
        if (parent != null) {
            List<NodeModel> sortedChildren = this.getSiblingsSortedOnSide(selectionRoot, parent);
            TreeSet<Object> range = new TreeSet<Object>(comparator);
            for (NodeModel nodeModel : movedNodeSet) {
                if (nodeModel.getParentNode() != parent) {
                    LogUtils.warn((String)"Not all selected nodes have the same parent.");
                    return;
                }
                range.add(new Integer(sortedChildren.indexOf(nodeModel)));
            }
            Integer last = (Integer)range.iterator().next();
            for (Integer n : range) {
                if (Math.abs(n - last) > 1) {
                    LogUtils.warn((String)"Not adjacent nodes. Skipped. ");
                    return;
                }
                last = n;
            }
            ArrayList arrayList = new ArrayList(this.getSelectedNodes());
            int n = parent.getChildCount();
            boolean movesGroupDown = direction == 1 && SummaryNode.isFirstGroupNode((NodeModel)movedNodesWithEdges.get(0));
            for (Integer n2 : range) {
                NodeModel node = sortedChildren.get(n2);
                List<NodeModel> sortedOnSideNodes = this.getSiblingsSortedOnSide(selectionRoot, parent);
                int newPositionInVector = sortedOnSideNodes.indexOf(node) + direction;
                if (newPositionInVector < 0) {
                    newPositionInVector = n - 1;
                }
                if (newPositionInVector >= n) {
                    newPositionInVector = 0;
                }
                NodeModel destinationNode = sortedOnSideNodes.get(newPositionInVector);
                int newIndex = parent.getIndex(destinationNode) + (movesGroupDown && SummaryNode.isFirstGroupNode((NodeModel)destinationNode) ? 1 : 0);
                this.moveNodeAndItsClones(node, parent, newIndex);
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            selection.selectAsTheOnlyOneSelected(selected);
            for (NodeModel selectedNode : arrayList) {
                selection.makeTheSelected(selectedNode);
            }
            this.balanceFirstGroupNodes(parent);
        }
    }

    private List<NodeModel> getSiblingsSortedOnSide(final NodeModel selectionRoot, NodeModel node) {
        ArrayList<NodeModel> nodes = new ArrayList<NodeModel>(node.getChildCount());
        for (NodeModel child : node.getChildren()) {
            nodes.add(child);
        }
        if (node != selectionRoot && !node.isRoot()) {
            return nodes;
        }
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)node.getMap());
        MapViewLayout layoutType = mapStyleModel.getMapViewLayout();
        if (layoutType.equals((Object)MapViewLayout.OUTLINE)) {
            return nodes;
        }
        Collections.sort(nodes, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof NodeModel) {
                    NodeModel n1 = (NodeModel)o1;
                    if (o2 instanceof NodeModel) {
                        NodeModel n2 = (NodeModel)o2;
                        int b1 = n1.isTopOrLeft(selectionRoot) ? 0 : 1;
                        int b2 = n2.isTopOrLeft(selectionRoot) ? 0 : 1;
                        return b1 - b2;
                    }
                }
                throw new IllegalArgumentException("Elements in LeftRightComparator are not comparable.");
            }
        });
        return nodes;
    }

    private int moveNodeToWithoutUndo(NodeModel child, NodeModel newParent, int newIndex) {
        NodeModel oldParent = child.getParentNode();
        int oldIndex = oldParent.getIndex(child);
        NodeMoveEvent nodeMoveEvent = new NodeMoveEvent(oldParent, oldIndex, newParent, child, newIndex);
        this.firePreNodeMoved(nodeMoveEvent);
        oldParent.remove(oldParent.getIndex(child));
        newParent.insert(child, newIndex);
        this.fireNodeMoved(nodeMoveEvent);
        if (!nodeMoveEvent.oldParent.equals(nodeMoveEvent.newParent)) {
            this.deleteSingleSummaryNode(nodeMoveEvent.oldParent);
        }
        this.mapSaved(newParent.getMap(), false);
        return newIndex;
    }

    public void balanceFirstGroupNodes(NodeModel parent) {
        this.removeSuperficiousFirstGroupNodes(parent);
        this.addMissingFirstGroupNodes(parent);
    }

    private void removeSuperficiousFirstGroupNodes(NodeModel parent) {
        NodeModel leftFirstGroupNode = null;
        NodeModel rightFirstGroupNode = null;
        IMapSelection selection = Controller.getCurrentController().getSelection();
        boolean shouldConsiderSeparateSides = selection != null && selection.getSelectionRoot() == parent || parent.isRoot();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            boolean isTopOrLeft;
            boolean isSummaryNode;
            NodeModel child = parent.getChildAt(i);
            boolean isFirstGroupNode = SummaryNode.isFirstGroupNode((NodeModel)child);
            if (isFirstGroupNode == (isSummaryNode = SummaryNode.isSummaryNode((NodeModel)child))) continue;
            boolean bl = isTopOrLeft = shouldConsiderSeparateSides && child.isTopOrLeft(parent);
            if (isTopOrLeft) {
                if (isFirstGroupNode) {
                    if (leftFirstGroupNode != null) {
                        this.deleteSingleNodeWithClones(child);
                    }
                    leftFirstGroupNode = child;
                    continue;
                }
                leftFirstGroupNode = null;
                continue;
            }
            if (isFirstGroupNode) {
                if (rightFirstGroupNode != null) {
                    this.deleteSingleNodeWithClones(child);
                }
                rightFirstGroupNode = child;
                continue;
            }
            rightFirstGroupNode = null;
        }
    }

    private void addMissingFirstGroupNodes(NodeModel parent) {
        boolean isLeftItemNodeFound = false;
        boolean isRightItemNodeFound = false;
        NodeModel leftSummaryNode = null;
        NodeModel rightSummaryNode = null;
        IMapSelection selection = Controller.getCurrentController().getSelection();
        boolean shouldConsiderSeparateSides = selection != null && selection.getSelectionRoot() == parent || parent.isRoot();
        for (int i = parent.getChildCount() - 1; i >= 0; --i) {
            boolean isTopOrLeft;
            NodeModel child = parent.getChildAt(i);
            boolean isFirstGroupNode = SummaryNode.isFirstGroupNode((NodeModel)child);
            boolean isSummaryNode = SummaryNode.isSummaryNode((NodeModel)child);
            boolean bl = isTopOrLeft = shouldConsiderSeparateSides && child.isTopOrLeft(parent);
            if (isFirstGroupNode != isSummaryNode) {
                if (isTopOrLeft) {
                    if (isSummaryNode) {
                        if (leftSummaryNode != null && isLeftItemNodeFound) {
                            this.addNewFirstGroupNode(parent, i + 1, leftSummaryNode.getSide());
                        }
                        leftSummaryNode = child;
                        isLeftItemNodeFound = false;
                    } else {
                        leftSummaryNode = null;
                    }
                } else if (isSummaryNode) {
                    if (rightSummaryNode != null && isRightItemNodeFound) {
                        this.addNewFirstGroupNode(parent, i + 1, rightSummaryNode.getSide());
                    }
                } else {
                    rightSummaryNode = null;
                }
            }
            if (isSummaryNode) {
                if (isTopOrLeft) {
                    leftSummaryNode = child;
                    isLeftItemNodeFound = false;
                } else {
                    rightSummaryNode = child;
                    isRightItemNodeFound = false;
                }
            }
            if (isFirstGroupNode || isSummaryNode) continue;
            if (isTopOrLeft) {
                isLeftItemNodeFound = true;
                continue;
            }
            isRightItemNodeFound = true;
        }
    }

    public MapModel createModel(NodeModel existingNode) {
        if (existingNode == null) {
            throw new NullPointerException("null node not allowed.");
        }
        MMapModel mindMapMapModel = new MMapModel(this.duplicator());
        mindMapMapModel.setRoot(existingNode);
        mindMapMapModel.registryNodeRecursive(existingNode);
        this.fireMapCreated(mindMapMapModel);
        return mindMapMapModel;
    }

    public MapModel newMap() {
        return MFileManager.getController(this.getModeController()).newMapFromDefaultTemplate();
    }

    public void mapSaved(MapModel mapModel, boolean saved) {
        boolean setTitle = saved != mapModel.isSaved() || mapModel.isReadOnly();
        mapModel.setSaved(saved);
        if (setTitle) {
            Controller controller = Controller.getCurrentController();
            controller.getMapViewManager().setMapTitles();
            AFreeplaneAction saveAction = controller.getModeController().getAction("SaveAction");
            if (saveAction != null) {
                saveAction.setEnabled(UserRole.EDITOR);
            }
        }
    }

    public NodeModel addFreeNode(final NodeModel target, Point pt, NodeModel.Side side) {
        boolean parentFolded;
        ModeController modeController = Controller.getCurrentModeController();
        final TextController textController = TextController.getController();
        if (textController instanceof MTextController) {
            ((MTextController)textController).stopInlineEditing();
            modeController.forceNewTransaction();
        }
        if (parentFolded = this.isFolded(target)) {
            this.unfold(target, modeController.getController().getSelection().getFilter());
        }
        if (!this.isWriteable(target)) {
            UITools.errorMessage((Object)TextUtils.getText((String)"node_is_write_protected"));
            return null;
        }
        final NodeModel newNode = this.newNode("", target.getMap());
        newNode.setSide(side);
        LogicalStyleModel.createExtension((NodeModel)newNode).setStyle(MapStyleModel.FLOATING_STYLE);
        newNode.addExtension(modeController.getExtension(FreeNode.class));
        if (!this.addNewNode(newNode, target, target.getChildCount())) {
            return null;
        }
        Quantity x = LengthUnit.pixelsInPt((double)pt.x);
        Quantity y = LengthUnit.pixelsInPt((double)pt.y);
        ((MLocationController)MLocationController.getController((ModeController)modeController)).moveNodePosition(newNode, (Quantity<LengthUnit>)x, (Quantity<LengthUnit>)y);
        Component component = Controller.getCurrentController().getMapViewManager().getComponent(newNode);
        if (component == null) {
            return newNode;
        }
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                e.getComponent().removeFocusListener(this);
                ((MTextController)textController).edit(newNode, target, true, false, false);
            }
        });
        this.select(newNode);
        return newNode;
    }

    @Deprecated
    public MapModel newMap(URL url, boolean follow) {
        return new MapLoader(this.getMModeController()).load(url).unsetMapLocation(follow).withView().getMap();
    }

    public synchronized MMapModel getMap(URL url) {
        for (MMapModel hiddenMap : this.loadedMaps.keySet()) {
            if (!url.equals(hiddenMap.getURL())) continue;
            return hiddenMap;
        }
        return null;
    }

    public synchronized void addLoadedMap(MMapModel map) {
        this.loadedMaps.put(map, null);
    }

    public MMapModel createUntitledMap(URL url, boolean follow) throws IOException, XMLException {
        return (MMapModel)new MapLoader(this.getMModeController()).load(url).unsetMapLocation(follow).withView().getMap();
    }

    public MapModel readMap(URL url) throws FileNotFoundException, XMLParseException, IOException, URISyntaxException {
        return new MapLoader(this.getMModeController()).load(url).getMap();
    }

    @Deprecated
    public void openMap(URL url) {
        if (AddOnsController.getController().installIfAppropriate(url)) {
            return;
        }
        new MapLoader(this.getMModeController()).load(url).withView().getMap();
    }

    public void newDocumentationMap(String file) {
        block7: {
            NodeAndMapReference nodeAndMapReference = new NodeAndMapReference(file);
            ResourceController resourceController = ResourceController.getResourceController();
            File userDir = new File(resourceController.getFreeplaneUserDirectory());
            File baseDir = new File(resourceController.getInstallationBaseDir());
            String languageCode = resourceController.getLanguageCode();
            File localFile = ConfigurationUtils.getLocalizedFile((File[])new File[]{userDir, baseDir}, (String)nodeAndMapReference.getMapReference(), (String)languageCode);
            if (localFile == null) {
                String errorMessage = TextUtils.format((String)"invalid_file_msg", (Object[])new Object[]{file});
                UITools.errorMessage((Object)errorMessage);
                return;
            }
            try {
                URL endUrl = localFile.toURL();
                try {
                    if (endUrl.getFile().endsWith(".mm")) {
                        Controller.getCurrentController().selectMode("MindMap");
                        this.openDocumentationMap(endUrl);
                        if (nodeAndMapReference.hasNodeReference()) {
                            this.select(nodeAndMapReference.getNodeReference());
                        }
                        break block7;
                    }
                    Controller.getCurrentController().getViewController().openDocument(endUrl);
                }
                catch (Exception e1) {
                    LogUtils.severe((Throwable)e1);
                }
            }
            catch (MalformedURLException e1) {
                LogUtils.warn((Throwable)e1);
            }
        }
    }

    @Deprecated
    public void openDocumentationMap(URL url) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        new MapLoader(this.getMModeController()).load(url).withView().asDocumentation().getMap();
    }

    public void restoreCurrentMap() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.restoreCurrentMap(true);
    }

    public void restoreCurrentMapIgnoreAlternatives() throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        this.restoreCurrentMap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCurrentMap(boolean checkAlternatives) throws FileNotFoundException, IOException, URISyntaxException, XMLException {
        URL alternativeURL;
        Controller controller = Controller.getCurrentController();
        MapModel map = controller.getMap();
        URL url = map.getURL();
        if (url == null) {
            UITools.errorMessage((Object)TextUtils.getText((String)"map_not_saved"));
            return;
        }
        if (map.containsExtension(DocuMapAttribute.class)) {
            this.closeWithoutSaving(map);
            this.openDocumentationMap(url);
            return;
        }
        URL uRL = alternativeURL = checkAlternatives ? MFileManager.getController(this.getMModeController()).getAlternativeURL(url, MFileManager.AlternativeFileMode.ALL) : url;
        if (alternativeURL == null) {
            return;
        }
        controller.getViewController().setWaitingCursor(true);
        try {
            map.releaseResources();
            MMapModel newModel = new MMapModel(this.duplicator());
            ((MFileManager)MFileManager.getController()).loadAndLock(alternativeURL, newModel);
            newModel.setURL(url);
            newModel.setSaved(alternativeURL.equals(url));
            this.fireMapCreated(newModel);
            this.addLoadedMap(newModel);
            this.closeWithoutSaving(map);
            newModel.enableAutosave();
            this.createMapView(newModel);
            return;
        }
        finally {
            controller.getViewController().setWaitingCursor(false);
        }
    }

    protected void setFoldingState(final NodeModel node, final boolean folded) {
        IMapViewManager mapViewManager = Controller.getCurrentController().getMapViewManager();
        final boolean wasFolded = mapViewManager.isFoldedOnCurrentView(node);
        if (wasFolded == folded && mapViewManager.getComponent(node) == null) {
            return;
        }
        if (this.isFoldingPersistent()) {
            IActor foldingActor = new IActor(){

                public boolean isReadonly() {
                    return true;
                }

                public void undo() {
                    MMapController.this.unfoldHiddenChildren(node);
                    MMapController.super.setFoldingState(node, wasFolded);
                }

                public String getDescription() {
                    return "setFoldingState";
                }

                public void act() {
                    MMapController.this.unfoldHiddenChildren(node);
                    MMapController.super.setFoldingState(node, folded);
                }
            };
            this.getMModeController().execute(foldingActor, node.getMap());
        } else {
            super.setFoldingState(node, folded);
        }
    }

    private boolean isFoldingPersistent() {
        ResourceController resourceController = ResourceController.getResourceController();
        return foldingSavedOptions.contains(resourceController.getProperty("save_folding"));
    }

    public <T extends IExtension> void setProperty(NodeModel node, T property) {
        Class propertyClass = property.getClass();
        this.setProperty(node, propertyClass, property);
    }

    public <T extends IExtension> void removeProperty(NodeModel node, Class<T> propertyClass) {
        this.setProperty(node, propertyClass, null);
    }

    public <T extends IExtension> void setProperty(final NodeModel node, final Class<? extends IExtension> propertyClass, final T property) {
        final IExtension oldProperty = node.getExtension(propertyClass);
        if (oldProperty != property) {
            IActor actor = new IActor(){

                public void undo() {
                    node.putExtension(propertyClass, oldProperty);
                    MMapController.this.nodeChanged(node, propertyClass, property, oldProperty);
                }

                public String getDescription() {
                    return "setProperty";
                }

                public void act() {
                    node.putExtension(propertyClass, property);
                    MMapController.this.nodeChanged(node, propertyClass, oldProperty, property);
                }
            };
            this.getModeController().execute(actor, node.getMap());
        }
    }

    public NodeModel newNode(Object userObject, MapModel map) {
        return new NodeModel(userObject, map);
    }

    private static /* synthetic */ void lambda$addNewNode$1(NodeModel.Side side, NodeModel node) {
        node.setSide(side);
        NewNodeStyle.assignStyleToNewNode(node);
    }
}

