/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.WindowConfigurationStorage;
import org.freeplane.core.resources.components.JColorButton;
import org.freeplane.core.resources.components.ResponsiveFlowLayout;
import org.freeplane.core.ui.ColorTracker;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.textchanger.TranslatedElementFactory;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.IconRegistry;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.TreeTagChangeListener;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.icon.mindmapmode.TagCategorySelection;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.mode.Controller;

class TagCategoryEditor
implements IExtension {
    static boolean FORCE_HEADLESS_GRAPHICS_FOR_TEST = false;
    private static final String WINDOW_CONFIG_PROPERTY = "tag_category_editor_window_configuration";
    private final JDialog dialog;
    private final JColorButton colorButton;
    private final Action modifyColorAction;
    private final JTree tree;
    private final TagCategories tagCategories;
    private boolean contentWasModified;
    private final MIconController iconController;
    private final MapModel map;
    private String lastTransferableId;
    private List<String> lastSelectionParentsNodes;
    private final TagRenamer tagRenamer;

    private static JDialog createDialog(RootPaneContainer frame) {
        return frame instanceof Frame ? new JDialog((Frame)((Object)frame), TextUtils.getText((String)"tag_category_manager"), false) : new JDialog((JDialog)frame, TextUtils.getText((String)"tag_category_manager"), false);
    }

    TagCategoryEditor(RootPaneContainer frame, MIconController iconController, MapModel map) {
        this(TagCategoryEditor.createDialog(frame), iconController, map);
    }

    TagCategoryEditor(final JDialog dialog, final MIconController iconController, final MapModel map) {
        this.dialog = dialog;
        this.iconController = iconController;
        this.map = map;
        this.lastSelectionParentsNodes = Collections.emptyList();
        this.contentWasModified = false;
        this.lastTransferableId = "";
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.modifyColorAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.modifyTagColor();
            }
        };
        this.colorButton = new JColorButton(this.modifyColorAction);
        this.colorButton.setColor(Tag.EMPTY_TAG.getColor());
        final JCheckBox enterConfirms = new JCheckBox("", ResourceController.getResourceController().getBooleanProperty("el__enter_confirms_by_default"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)okButton, (String)TextUtils.getRawText((String)"ok"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)cancelButton, (String)TextUtils.getRawText((String)"cancel"));
        LabelAndMnemonicSetter.setLabelAndMnemonic((AbstractButton)enterConfirms, (String)TextUtils.getRawText((String)"enter_confirms"));
        this.modifyColorAction.setEnabled(false);
        okButton.addActionListener(e -> {
            if (this.close()) {
                this.submit();
            }
        });
        cancelButton.addActionListener(e -> this.close());
        JPanel buttonPane = new JPanel((LayoutManager)new ResponsiveFlowLayout());
        buttonPane.add(enterConfirms);
        buttonPane.add(okButton);
        buttonPane.add(cancelButton);
        buttonPane.add((Component)this.colorButton);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.setDefaultCloseOperation(0);
        Container contentPane = dialog.getContentPane();
        IconRegistry iconRegistry = map.getIconRegistry();
        this.tagCategories = iconRegistry.getTagCategories().copy();
        this.tree = new JTree(this.tagCategories.getNodes()){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isPathEditable(TreePath path) {
                Object lastPathComponent = path.getLastPathComponent();
                if (!(lastPathComponent instanceof DefaultMutableTreeNode)) {
                    return false;
                }
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)lastPathComponent;
                return TagCategoryEditor.this.tagCategories.containsTag(node);
            }

            @Override
            public void setUI(TreeUI ui) {
                super.setUI(ui);
                Font tagFont = iconController.getTagFont(map.getRootNode());
                Font font = tagFont.deriveFont(this.getFont().getSize2D());
                this.setFont(font);
                Rectangle2D rect = font.getStringBounds("*", 0, 1, new FontRenderContext(new AffineTransform(), true, true));
                double textHeight = rect.getHeight();
                this.setRowHeight((int)Math.ceil(textHeight * 1.4));
            }

            @Override
            public void cancelEditing() {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getEditingPath().getLastPathComponent();
                Tag tag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(node);
                super.cancelEditing();
                if (tag.isEmpty() && node.isLeaf()) {
                    TagCategoryEditor.this.tagCategories.removeNodeFromParent((MutableTreeNode)node);
                }
            }
        };
        this.tree.setTransferHandler(new TreeTransferHandler());
        if (!GraphicsEnvironment.isHeadless()) {
            this.tree.setEditable(true);
            this.tree.getSelectionModel().setSelectionMode(4);
            this.tree.setInvokesStopCellEditing(true);
            this.tree.setDragEnabled(true);
            this.tree.setDropMode(DropMode.ON_OR_INSERT);
            this.tree.setCellRenderer(new TagCellRenderer());
            this.tree.setCellEditor(new TagCellEditor());
            this.tree.setToggleClickCount(0);
            this.configureKeyBindings();
        }
        JRestrictedSizeScrollPane editorScrollPane = this.createScrollPane();
        editorScrollPane.setViewportView((Component)this.tree);
        editorScrollPane.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TagCategoryEditor.this.tree.revalidate();
                TagCategoryEditor.this.tree.repaint();
            }
        });
        enterConfirms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.tree.requestFocus();
                ResourceController.getResourceController().setProperty("el__enter_confirms_by_default", Boolean.toString(enterConfirms.isSelected()));
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        e.consume();
                        TagCategoryEditor.this.close();
                        break;
                    }
                    case 10: {
                        if ((e.getModifiersEx() & 0x40) != 0) break;
                        e.consume();
                        if (enterConfirms.isSelected() == ((e.getModifiersEx() & 0x200) != 0)) {
                            TagCategoryEditor.this.addNode((e.getModifiersEx() & 0x180) != 0);
                            break;
                        }
                        if (!TagCategoryEditor.this.close()) break;
                        TagCategoryEditor.this.submit();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.tree.getSelectionModel().addTreeSelectionListener(this::updateColorButton);
        this.tagCategories.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                TagCategoryEditor.this.contentWasModified = true;
                TagCategoryEditor.this.updateColorButton();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TagCategoryEditor.this.contentWasModified = true;
                TagCategoryEditor.this.updateColorButton();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TagCategoryEditor.this.contentWasModified = true;
                Invoker.invokeLater(() -> TagCategoryEditor.this.tree.expandPath(e.getTreePath()));
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TagCategoryEditor.this.contentWasModified = true;
                TagCategoryEditor.this.updateColorButton();
            }
        });
        this.tagRenamer = new TagRenamer();
        this.tagCategories.addTreeModelListener((TreeModelListener)this.tagRenamer);
        contentPane.add((Component)editorScrollPane, "Center");
        boolean areButtonsAtTheTop = ResourceController.getResourceController().getBooleanProperty("el__buttons_above");
        contentPane.add((Component)buttonPane, areButtonsAtTheTop ? "North" : "South");
        WindowConfigurationStorage windowConfigurationStorage = new WindowConfigurationStorage(WINDOW_CONFIG_PROPERTY);
        windowConfigurationStorage.setBounds(dialog);
        dialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                dialog.dispose();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (dialog.isVisible()) {
                    TagCategoryEditor.this.confirmedSubmit();
                }
            }
        });
    }

    private boolean close() {
        if (this.tree.isEditing()) {
            return false;
        }
        this.dialog.setVisible(false);
        this.map.removeExtension((IExtension)this);
        return true;
    }

    private void configureKeyBindings() {
        InputMap im = this.tree.getInputMap(0);
        ActionMap am = this.tree.getActionMap();
        im.put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        Action editNodeAction = am.get("startEditing");
        im.put(KeyStroke.getKeyStroke(8, 0), "removeNode");
        im.put(KeyStroke.getKeyStroke(127, 0), "removeNode");
        AbstractAction addChildNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.addNode(true);
            }
        };
        AbstractAction addSiblingNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.addNode(false);
            }
        };
        AbstractAction removeNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.removeNodes();
                TagCategoryEditor.this.lastSelectionParentsNodes = Collections.emptyList();
                TagCategoryEditor.this.lastTransferableId = "";
            }
        };
        am.put("removeNode", removeNodeAction);
        AbstractAction copyNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TagCategoryEditor.this.copyNodes()) {
                    TagCategoryEditor.this.lastSelectionParentsNodes = Collections.emptyList();
                    TagCategoryEditor.this.lastTransferableId = "";
                }
            }
        };
        am.put(TransferHandler.getCopyAction().getValue("Name"), copyNodeAction);
        AbstractAction cutNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.cutNodes();
            }
        };
        am.put(TransferHandler.getCutAction().getValue("Name"), cutNodeAction);
        AbstractAction pasteNodeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TagCategoryEditor.this.pasteNodes();
            }
        };
        am.put(TransferHandler.getPasteAction().getValue("Name"), pasteNodeAction);
        JMenuBar menubar = new JMenuBar();
        JMenu editMenu = TranslatedElementFactory.createMenu((String)"edit");
        JMenuItem addChildMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_addChild");
        addChildMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 9));
        addChildMenuItem.addActionListener(addChildNodeAction);
        editMenu.add(addChildMenuItem);
        JMenuItem addSiblingMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_addSibling");
        addSiblingMenuItem.setAccelerator(KeyStroke.getKeyStroke(10, 1));
        addSiblingMenuItem.addActionListener(addSiblingNodeAction);
        editMenu.add(addSiblingMenuItem);
        JMenuItem removeMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_remove");
        removeMenuItem.setAccelerator(KeyStroke.getKeyStroke(8, 0));
        removeMenuItem.addActionListener(removeNodeAction);
        editMenu.add(removeMenuItem);
        JMenuItem editMenuItem = TranslatedElementFactory.createMenuItem((String)"edit");
        editMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        editMenuItem.addActionListener(e -> editNodeAction.actionPerformed(new ActionEvent(this.tree, e.getID(), e.getActionCommand())));
        editMenu.add(editMenuItem);
        JMenuItem copyMenuItem = TranslatedElementFactory.createMenuItem((String)"menu_copy");
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        copyMenuItem.addActionListener(copyNodeAction);
        editMenu.add(copyMenuItem);
        JMenuItem cutMenuItem = TranslatedElementFactory.createMenuItem((String)"CutAction.text");
        cutMenuItem.addActionListener(cutNodeAction);
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        editMenu.add(cutMenuItem);
        JMenuItem pasteMenuItem = TranslatedElementFactory.createMenuItem((String)"PasteAction.text");
        pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        pasteMenuItem.addActionListener(pasteNodeAction);
        editMenu.add(pasteMenuItem);
        JMenuItem colorMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_color");
        colorMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        colorMenuItem.addActionListener(this.modifyColorAction);
        editMenu.add(colorMenuItem);
        editMenu.addSeparator();
        JMenuItem insertIntoNodesMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_insert");
        insertIntoNodesMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        insertIntoNodesMenuItem.addActionListener(e -> this.insertSelectedTagsIntoSelectedNodes());
        editMenu.add(insertIntoNodesMenuItem);
        JMenuItem removeFromNodesMenuItem = TranslatedElementFactory.createMenuItem((String)"choose_tag_remove");
        removeFromNodesMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        removeFromNodesMenuItem.addActionListener(e -> this.removeSelectedTagsFromSelectedNodes());
        editMenu.add(removeFromNodesMenuItem);
        menubar.add(editMenu);
        this.dialog.setJMenuBar(menubar);
    }

    private void removeSelectedTagsFromSelectedNodes() {
        Set<Tag> selectedTags = this.collectSelectedTags().collect(Collectors.toSet());
        ((MIconController)IconController.getController()).removeSelectedTagsFromSelectedNodes(selectedTags);
    }

    private void insertSelectedTagsIntoSelectedNodes() {
        List<Tag> selectedTags = this.collectSelectedTags().collect(Collectors.toList());
        ((MIconController)IconController.getController()).insertTagsIntoSelectedNodes(selectedTags);
    }

    private Stream<Tag> collectSelectedTags() {
        TreePath[] selectionPaths = this.getSelectedTagPaths();
        if (selectionPaths == null) {
            return Stream.empty();
        }
        MapModel selectedMap = Controller.getCurrentController().getMap();
        if (selectedMap == null) {
            return Stream.empty();
        }
        Stream<Tag> selectedTags = Stream.of(selectionPaths).map(TreePath::getLastPathComponent).map(DefaultMutableTreeNode.class::cast).map(node -> this.tagCategories.categorizedTag(node));
        return selectedTags;
    }

    void addNode(boolean asChild) {
        Object[] nodes;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        DefaultMutableTreeNode uncategorizedTagsNode = this.tagCategories.getUncategorizedTagsNode();
        if (selectedNode == null || selectedNode == uncategorizedTagsNode || selectedNode.getParent() == uncategorizedTagsNode) {
            selectedNode = this.tagCategories.getRootNode();
        }
        Object[] objectArray = nodes = asChild || selectedNode.isRoot() || selectedNode == uncategorizedTagsNode ? this.tagCategories.addChildNode((MutableTreeNode)selectedNode) : this.tagCategories.addSiblingNode((MutableTreeNode)selectedNode);
        if (nodes.length == 0) {
            return;
        }
        TreePath path = new TreePath(nodes);
        this.tree.scrollPathToVisible(path);
        this.tree.setSelectionPath(path);
        this.tree.startEditingAtPath(path);
    }

    private void saveLastSelectionParentsNodes() {
        TreePath[] selectionPaths = this.removeDescendantPaths(this.tree.getSelectionPaths());
        if (selectionPaths == null || selectionPaths.length == 0 || !this.canSelectionBeRemoved()) {
            this.lastSelectionParentsNodes = Collections.emptyList();
        } else {
            List x = Stream.of(selectionPaths).map(TreePath::getLastPathComponent).map(DefaultMutableTreeNode.class::cast).map(DefaultMutableTreeNode::getParent).map(DefaultMutableTreeNode.class::cast).map(arg_0 -> ((TagCategories)this.tagCategories).categorizedContent(arg_0)).collect(Collectors.toList());
            this.lastSelectionParentsNodes = x;
        }
    }

    private boolean canSelectionBeRemoved() {
        TreePath[] selectionPaths = this.tree.getSelectionPaths();
        return selectionPaths != null && Stream.of(selectionPaths).map(TreePath::getLastPathComponent).allMatch(o -> this.tagCategories.containsTag((DefaultMutableTreeNode)o));
    }

    private TreePath[] removeDescendantPaths(TreePath[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<TreePath> filteredPaths = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            filteredPaths.add(path);
        }
        block1: for (int i = 0; i < filteredPaths.size(); ++i) {
            TreePath path = (TreePath)filteredPaths.get(i);
            for (int j = 0; j < filteredPaths.size(); ++j) {
                TreePath otherPath;
                if (i == j || !(otherPath = (TreePath)filteredPaths.get(j)).isDescendant(path)) continue;
                filteredPaths.remove(i);
                --i;
                continue block1;
            }
        }
        return filteredPaths.toArray(new TreePath[0]);
    }

    private void removeNodes() {
        TreePath[] selectionPaths = this.getSelectedTagPaths();
        if (selectionPaths == null) {
            return;
        }
        Stream.of(selectionPaths).map(TreePath::getLastPathComponent).map(DefaultMutableTreeNode.class::cast).forEach(arg_0 -> ((TagCategories)this.tagCategories).removeNodeFromParent(arg_0));
    }

    void cutNodes() {
        if (this.canSelectionBeRemoved() && this.copyNodes()) {
            this.saveLastSelectionParentsNodes();
            this.removeNodes();
        }
    }

    boolean copyNodes() {
        TagCategorySelection t = ((TreeTransferHandler)this.tree.getTransferHandler()).createTransferable();
        if (t != null) {
            Clipboard clipboard = Invoker.getSystemClipboard();
            clipboard.setContents(t, null);
            return true;
        }
        return false;
    }

    void pasteNodes() {
        Clipboard clipboard = Invoker.getSystemClipboard();
        try {
            Transferable t = clipboard.getContents(null);
            if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                DefaultMutableTreeNode uncategorizedTagsNode;
                DefaultMutableTreeNode selectedNode = this.getSelectedNode();
                if (selectedNode != (uncategorizedTagsNode = this.tagCategories.getUncategorizedTagsNode()) && selectedNode.isNodeAncestor(uncategorizedTagsNode)) {
                    selectedNode = uncategorizedTagsNode;
                }
                this.insertTransferable(selectedNode, selectedNode.isRoot() ? selectedNode.getChildCount() - 1 : selectedNode.getChildCount(), t, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private DataFlavor flavor(Transferable t) {
        if (t.isDataFlavorSupported(TagCategorySelection.tagCategoryFlavor)) {
            return TagCategorySelection.tagCategoryFlavor;
        }
        if (t.isDataFlavorSupported(TagCategorySelection.stringFlavor)) {
            return TagCategorySelection.stringFlavor;
        }
        throw new IllegalArgumentException("No supported flavor found");
    }

    private void modifyTagColor() {
        Tag tag = this.tagCategories.tagWithoutCategories(this.getSelectedNode());
        if (!tag.isEmpty()) {
            Tag categorizedTag = this.tagCategories.categorizedTag(this.getSelectedNode());
            Color defaultColor = new Color(categorizedTag.getDefaultColor().getRGB(), true);
            Color initialColor = categorizedTag.getColor();
            Color result = ColorTracker.showCommonJColorChooserDialog((Component)this.tree, (String)categorizedTag.getContent(), (Color)initialColor, (Color)defaultColor);
            if (result != null && !initialColor.equals(result) || result == defaultColor) {
                this.setTagColor(result);
                this.updateColorButton();
            }
        }
    }

    void setTagColor(Color result) {
        this.tagCategories.setTagColor(this.tagCategories.categorizedContent(this.getSelectedNode()), result);
        this.tagCategories.fireNodeChanged(this.getSelectedNode());
    }

    private DefaultMutableTreeNode getSelectedNode() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }

    void show() {
        if (!this.dialog.isVisible()) {
            this.dialog.setVisible(true);
        } else {
            this.dialog.toFront();
        }
    }

    protected void submit() {
        String oldSeparator = this.tagCategories.getTagCategorySeparator();
        TagCategories lastStateCategories = this.map.getIconRegistry().getTagCategories();
        String newSeparator = lastStateCategories.getTagCategorySeparator();
        this.tagCategories.updateTagCategorySeparator(newSeparator);
        lastStateCategories.getTagsAsListModel().forEach(tag -> this.tagCategories.registerTagReferenceIfUnknown(tag));
        this.tagRenamer.apply(oldSeparator, newSeparator);
        this.iconController.setTagCategories(this.map, this.tagCategories);
    }

    private JRestrictedSizeScrollPane createScrollPane() {
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(new Dimension(0, 60));
        return scrollPane;
    }

    private void confirmedSubmit() {
        if (this.dialog.isVisible() && !this.tree.isEditing()) {
            if (this.contentWasModified) {
                int action = JOptionPane.showConfirmDialog(this.dialog, TextUtils.getText((String)"long_node_changed_submit"), "", 1);
                if (action == 0) {
                    this.submit();
                } else if (action == 2 || action == -1) {
                    return;
                }
            }
            this.close();
        }
    }

    private void updateColorButton(TreeSelectionEvent e) {
        this.updateColorButton();
    }

    private void updateColorButton() {
        Tag tag = this.tagCategories.tagWithoutCategories(this.getSelectedNode());
        this.modifyColorAction.setEnabled(!tag.isEmpty());
        this.colorButton.setColor(tag.getColor());
    }

    private TreePath[] getSelectedTagPaths() {
        return this.getSelectedPaths(false);
    }

    private TreePath[] getSelectedNodePaths() {
        return this.getSelectedPaths(true);
    }

    private TreePath[] getSelectedPaths(boolean includeNonTags) {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        ArrayList<TreePath> filteredPaths = new ArrayList<TreePath>();
        for (TreePath path : paths) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (!includeNonTags && !this.tagCategories.containsTag(node)) {
                return null;
            }
            filteredPaths.add(path);
        }
        this.removeDescendants(filteredPaths);
        if (filteredPaths.isEmpty()) {
            return null;
        }
        return filteredPaths.toArray(new TreePath[0]);
    }

    private void removeDescendants(List<TreePath> filteredPaths) {
        block0: for (int i = 0; i < filteredPaths.size(); ++i) {
            TreePath path = filteredPaths.get(i);
            for (int j = 0; j < filteredPaths.size(); ++j) {
                TreePath otherPath;
                if (i == j || !(otherPath = filteredPaths.get(j)).isDescendant(path)) continue;
                filteredPaths.remove(i);
                --i;
                continue block0;
            }
        }
    }

    private void insertTransferable(DefaultMutableTreeNode parent, int childIndex, Transferable t, boolean isDropped) throws UnsupportedFlavorException, IOException {
        DataFlavor flavor = this.flavor(t);
        String data = (String)t.getTransferData(flavor);
        if (flavor.equals(TagCategorySelection.tagCategoryFlavor)) {
            boolean isMoveInternal;
            boolean bl = isMoveInternal = !this.lastTransferableId.isEmpty() && t.isDataFlavorSupported(TagSelection.uuidFlavor) && this.lastTransferableId.equals(t.getTransferData(TagSelection.uuidFlavor));
            if (isDropped && isMoveInternal) {
                childIndex -= this.countSelectedChildrenAbove(parent, childIndex);
                this.removeNodes();
            }
            if (!isMoveInternal) {
                this.lastSelectionParentsNodes = Collections.emptyList();
            }
            this.tagCategories.insert(parent, childIndex, data);
        } else {
            this.lastSelectionParentsNodes = Collections.emptyList();
            this.tagCategories.insert(parent, childIndex, data);
        }
    }

    private int countSelectedChildrenAbove(DefaultMutableTreeNode parent, int childIndex) {
        TreePath[] selectionPaths = this.getSelectedTagPaths();
        if (selectionPaths != null) {
            int childIndexCopy = childIndex;
            long removedUpperSiblings = Stream.of(selectionPaths).map(TreePath::getLastPathComponent).map(DefaultMutableTreeNode.class::cast).mapToInt(node -> parent.getIndex((TreeNode)node)).filter(index -> index >= 0 && index < childIndexCopy).count();
            return (int)removedUpperSiblings;
        }
        return 0;
    }

    private String getTagCategorySeparator() {
        return this.tagCategories.getTagCategorySeparator();
    }

    TagCategories getTagCategories() {
        return this.tagCategories;
    }

    JTree getTree() {
        return this.tree;
    }

    class TreeTransferHandler
    extends TransferHandler {
        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c != TagCategoryEditor.this.tree) {
                throw new IllegalArgumentException("Unexpected argument " + c);
            }
            TagCategoryEditor.this.saveLastSelectionParentsNodes();
            return this.createTransferable();
        }

        TagCategorySelection createTransferable() {
            try {
                TreePath[] selectionPaths = TagCategoryEditor.this.getSelectedNodePaths();
                if (selectionPaths == null) {
                    return null;
                }
                TagCategoryEditor.this.lastTransferableId = UUID.randomUUID().toString();
                StringWriter tagCategoryWriter = new StringWriter();
                StringWriter tagWriter = new StringWriter();
                for (TreePath treePath : selectionPaths) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    TagCategoryEditor.this.tagCategories.writeTagCategories(node, "", (Writer)tagCategoryWriter);
                    TagCategoryEditor.this.tagCategories.writeCategorizedTag(node, tagWriter);
                }
                TagCategorySelection stringSelection = new TagCategorySelection(TagCategoryEditor.this.lastTransferableId, tagCategoryWriter.toString(), tagWriter.toString());
                return stringSelection;
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDrop()) {
                return false;
            }
            if (!support.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JTree.DropLocation dropLocation = (JTree.DropLocation)support.getDropLocation();
            JTree tree = (JTree)support.getComponent();
            TreePath target = dropLocation.getPath();
            if (target != null) {
                DefaultMutableTreeNode rootNode;
                DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)target.getLastPathComponent();
                if (targetNode == (rootNode = TagCategoryEditor.this.tagCategories.getRootNode()) && dropLocation.getChildIndex() == rootNode.getChildCount()) {
                    return false;
                }
                DefaultMutableTreeNode uncategorizedTagsNode = TagCategoryEditor.this.tagCategories.getUncategorizedTagsNode();
                if (targetNode != uncategorizedTagsNode && targetNode.isNodeAncestor(uncategorizedTagsNode)) {
                    return false;
                }
                DefaultMutableTreeNode sourceNode = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (sourceNode == targetNode || targetNode.isNodeAncestor(sourceNode)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            support.setShowDropLocation(true);
            JTree.DropLocation dl = (JTree.DropLocation)support.getDropLocation();
            int childIndex = dl.getChildIndex();
            TreePath dest = dl.getPath();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dest.getLastPathComponent();
            try {
                if (childIndex == -1) {
                    childIndex = parent.getChildCount();
                }
                if (parent.isRoot() && childIndex == parent.getChildCount()) {
                    --childIndex;
                }
                if (support.getDropAction() != 2) {
                    TagCategoryEditor.this.lastTransferableId = "";
                }
                TagCategoryEditor.this.insertTransferable(parent, childIndex, support.getTransferable(), true);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    class TagCellRenderer
    extends DefaultTreeCellRenderer {
        public TagCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, null, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
                Tag tag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(node);
                if (!tag.isEmpty()) {
                    this.setText(null);
                    this.setIcon((Icon)new TagIcon(tag, this.getFont()));
                } else if (node.getUserObject() != null) {
                    this.setText(node.getUserObject().toString());
                }
            }
            return this;
        }
    }

    class TagCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private static final long serialVersionUID = 1L;
        private JTextField textField = new JTextField();
        private DefaultMutableTreeNode currentNode;

        public TagCellEditor() {
            this.textField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TagCellEditor.this.stopCellEditing();
                }
            });
            this.textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TagCellEditor.this.stopCellEditing();
                }
            });
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.currentNode = (DefaultMutableTreeNode)value;
            Tag tag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(this.currentNode);
            String content = tag.getContent();
            this.textField.setText(content);
            this.textField.setColumns(Math.max(30, content.length()));
            JComponent treeCellRendererComponent = (JComponent)tree.getCellRenderer().getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
            this.textField.setBorder(treeCellRendererComponent.getBorder());
            return this.textField;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                return ((MouseEvent)event).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public Object getCellEditorValue() {
            Tag tag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(this.currentNode);
            String text = this.textField.getText();
            if (text.isEmpty()) {
                return tag;
            }
            if (tag.isEmpty()) {
                return new Tag(text);
            }
            return new Tag(text, tag.getColor());
        }

        @Override
        public boolean stopCellEditing() {
            String text = this.textField.getText();
            if (text.isEmpty()) {
                return false;
            }
            TreePath editingPath = TagCategoryEditor.this.tree.getEditingPath();
            if (editingPath == null) {
                return false;
            }
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)editingPath.getParentPath().getLastPathComponent();
            List previousLastSelectionParentsNodes = TagCategoryEditor.this.lastSelectionParentsNodes;
            if (parent == TagCategoryEditor.this.tagCategories.getUncategorizedTagsNode()) {
                TagCategoryEditor.this.lastSelectionParentsNodes = Collections.singletonList(" uncategorized node ");
            }
            boolean pathSelected = TagCategoryEditor.this.tree.isPathSelected(editingPath);
            this.fireEditingStopped();
            if (pathSelected && !TagCategoryEditor.this.tree.isPathSelected(editingPath)) {
                TagCategoryEditor.this.tree.addSelectionPath(editingPath);
            }
            TagCategoryEditor.this.lastSelectionParentsNodes = previousLastSelectionParentsNodes;
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }
    }

    class TagRenamer
    implements TreeModelListener,
    TreeTagChangeListener<Tag> {
        private final List<String> replacements = new ArrayList<String>();

        TagRenamer() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            if (TagCategoryEditor.this.tagCategories.isMergeRunning()) {
                return;
            }
            Invoker.invokeLater(() -> this.merge(e));
        }

        private void merge(TreeModelEvent e) {
            for (Object node : e.getChildren()) {
                this.merge((DefaultMutableTreeNode)node);
            }
        }

        public void valueForPathChanged(TreePath path, Tag newTag) {
            String newContent;
            if (TagCategoryEditor.this.tagCategories.isMergeRunning()) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Tag oldTag = TagCategoryEditor.this.tagCategories.categorizedTag(node);
            String oldContent = oldTag.getContent();
            if (oldContent.isEmpty()) {
                return;
            }
            String tagCategorySeparator = TagCategoryEditor.this.getTagCategorySeparator();
            int lastIndexOfSeparator = oldContent.lastIndexOf(tagCategorySeparator);
            String string = newContent = lastIndexOfSeparator >= 0 ? oldContent.substring(0, lastIndexOfSeparator + tagCategorySeparator.length()) + newTag.getContent() : newTag.getContent();
            if (!newContent.equals(oldContent)) {
                this.addReplacement(oldContent, newContent);
            }
        }

        private void addReplacement(String oldContent, String newContent) {
            this.replacements.add(oldContent);
            this.replacements.add(newContent);
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            if (TagCategoryEditor.this.tagCategories.isMergeRunning()) {
                return;
            }
            Object[] insertedNodes = e.getChildren();
            if (e.getTreePath().getLastPathComponent() == TagCategoryEditor.this.tagCategories.getUncategorizedTagsNode() && (TagCategoryEditor.this.lastSelectionParentsNodes.size() != 1 || TagCategoryEditor.this.lastSelectionParentsNodes.get(0) != " uncategorized node ")) {
                this.uncategorizedNodesMoved();
            } else if (TagCategoryEditor.this.lastSelectionParentsNodes.size() == insertedNodes.length) {
                int replacementIndex;
                int replacementStartIndex = this.replacements.size() - TagCategoryEditor.this.lastSelectionParentsNodes.size() * 2;
                for (int i = 0; i < TagCategoryEditor.this.lastSelectionParentsNodes.size() && (replacementIndex = replacementStartIndex + i * 2) >= 0; ++i) {
                    String replacedContent;
                    String oldParent = (String)TagCategoryEditor.this.lastSelectionParentsNodes.get(i);
                    DefaultMutableTreeNode insertedNode = (DefaultMutableTreeNode)insertedNodes[i];
                    String newContent = TagCategoryEditor.this.tagCategories.categorizedContent(insertedNode);
                    if (oldParent == " uncategorized node ") {
                        this.replacements.set(replacementIndex + 1, newContent);
                        continue;
                    }
                    Tag newTag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(insertedNode);
                    String string = replacedContent = oldParent.isEmpty() ? newTag.getContent() : oldParent + TagCategoryEditor.this.getTagCategorySeparator() + newTag.getContent();
                    if (!this.replacements.get(replacementIndex).equals(replacedContent)) break;
                    this.replacements.set(replacementIndex + 1, newContent);
                }
            }
            Invoker.invokeLater(() -> this.merge(e));
        }

        private void uncategorizedNodesMoved() {
            int indexBefore = this.replacements.size() - TagCategoryEditor.this.lastSelectionParentsNodes.size() * 2;
            for (int i = 0; i < TagCategoryEditor.this.lastSelectionParentsNodes.size(); ++i) {
                this.replacements.set(indexBefore + i * 2 + 1, " uncategorized node ");
            }
            TagCategoryEditor.this.lastSelectionParentsNodes = Collections.emptyList();
        }

        public void apply(String oldSeparator, String newSeparator) {
            if (!oldSeparator.equals(newSeparator)) {
                for (int i = 0; i < this.replacements.size(); ++i) {
                    this.replacements.set(i, this.replacements.get(i).replace(oldSeparator, newSeparator));
                }
            }
            TagCategoryEditor.this.tagCategories.replaceReferencedTags(this.replacements);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (TagCategoryEditor.this.tagCategories.isMergeRunning()) {
                return;
            }
            Object[] removedNodes = e.getChildren();
            for (int i = 0; i < removedNodes.length; ++i) {
                DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)removedNodes[i];
                Tag removedTag = TagCategoryEditor.this.tagCategories.tagWithoutCategories(removedNode);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)e.getTreePath().getLastPathComponent();
                String categorizedParentContent = TagCategoryEditor.this.tagCategories.categorizedContent(parent);
                String removedQuallifiedTag = categorizedParentContent.isEmpty() ? removedTag.getContent() : categorizedParentContent + TagCategoryEditor.this.getTagCategorySeparator() + removedTag.getContent();
                int indexBefore = this.replacements.size() - TagCategoryEditor.this.lastSelectionParentsNodes.size() * 2;
                if (indexBefore < 0 || TagCategoryEditor.this.lastSelectionParentsNodes.isEmpty() || !this.replacements.get(indexBefore).equals(removedQuallifiedTag)) {
                    this.replacements.add(removedQuallifiedTag);
                } else {
                    this.replacements.add("");
                }
                this.replacements.add("");
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.replacements.clear();
        }

        private void merge(DefaultMutableTreeNode node) {
            boolean nodeWasSelected = TagCategoryEditor.this.tree.getLastSelectedPathComponent() == node;
            DefaultMutableTreeNode target = TagCategoryEditor.this.tagCategories.merge(node);
            if (nodeWasSelected && node.getParent() == null) {
                TagCategoryEditor.this.tree.setSelectionPath(new TreePath(target));
            }
        }
    }

    private static class Invoker {
        private static final Clipboard CLIPBOARD = GraphicsEnvironment.isHeadless() ? new Clipboard("") : null;

        private Invoker() {
        }

        public static void invokeLater(Runnable runnable) {
            if (FORCE_HEADLESS_GRAPHICS_FOR_TEST || GraphicsEnvironment.isHeadless()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public static Clipboard getSystemClipboard() {
            if (GraphicsEnvironment.isHeadless()) {
                return CLIPBOARD;
            }
            return Toolkit.getDefaultToolkit().getSystemClipboard();
        }
    }
}

