/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.textchanger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.ui.components.JAutoToggleButton;
import org.freeplane.core.ui.textchanger.TranslatedElement;
import org.freeplane.core.util.TextUtils;

public class TranslatedElementFactory {
    public static JButton createButton(Action action, String labelKey) {
        JButton component = action != null ? new JButton(action) : new JButton();
        String text = TextUtils.getRawText(labelKey);
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static JButton createButton(String labelKey) {
        return TranslatedElementFactory.createButton(null, labelKey);
    }

    public static JToggleButton createToggleButton(String labelKey) {
        JAutoToggleButton component = new JAutoToggleButton();
        String text = TextUtils.getRawText(labelKey);
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static JCheckBox createCheckBox(String labelKey) {
        String text = TextUtils.getRawText(labelKey);
        JCheckBox component = new JCheckBox();
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static JMenu createMenu(String labelKey) {
        String text = TextUtils.getRawText(labelKey);
        JMenu component = new JMenu();
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static JMenuItem createMenuItem(String labelKey) {
        String text = TextUtils.getRawText(labelKey);
        JMenuItem component = new JMenuItem();
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static JCheckBox createPropertyCheckbox(final String propertyName, String labelKey) {
        final JCheckBox component = TranslatedElementFactory.createCheckBox(labelKey);
        component.setSelected(ResourceController.getResourceController().getBooleanProperty(propertyName));
        component.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ResourceController.getResourceController().setProperty(propertyName, component.isSelected());
            }
        });
        return component;
    }

    public static void createTitledBorder(JComponent component, String labelKey) {
        String text = TextUtils.getText(labelKey);
        component.setBorder(BorderFactory.createTitledBorder(text));
        TranslatedElement.BORDER.setKey(component, labelKey);
    }

    public static JLabel createLabel(String labelKey) {
        String text = TextUtils.getText(labelKey);
        JLabel component = new JLabel(text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }

    public static void createTooltip(JComponent component, String labelKey) {
        String text = TextUtils.getOptionalText(labelKey, null);
        if (text != null) {
            component.setToolTipText(text);
        }
        TranslatedElement.TOOLTIP.setKey(component, labelKey);
    }

    public static JButton createButtonWithIcon(AFreeplaneAction action) {
        return TranslatedElementFactory.createButtonWithIcon(action, action.getIconKey(), action.getTextKey());
    }

    public static JButton createButtonWithIcon(Action action, String iconKey, String tooltipKey) {
        JButton button;
        Icon icon = ResourceController.getResourceController().getImageIcon(iconKey);
        if (action == null) {
            button = new JButton(icon);
        } else {
            button = new JButton(action);
            button.setText(null);
            button.setIcon(icon);
        }
        TranslatedElementFactory.createTooltip(button, tooltipKey);
        return button;
    }

    public static JButton createButtonWithIcon(String iconKey, String tooltipKey) {
        return TranslatedElementFactory.createButtonWithIcon(null, iconKey, tooltipKey);
    }

    public static JToggleButton createToggleButtonWithIconAndLabel(String iconKey, String labelKey) {
        JToggleButton button = TranslatedElementFactory.createToggleButton(labelKey);
        return TranslatedElementFactory.addIcon(button, iconKey);
    }

    public static JToggleButton createToggleButtonWithIcon(String iconKey, String tooltipKey) {
        JAutoToggleButton button = new JAutoToggleButton();
        TranslatedElementFactory.createTooltip(button, tooltipKey);
        return TranslatedElementFactory.addIcon(button, iconKey);
    }

    public static <T extends AbstractButton> T addIcon(T button, String iconKey) {
        Icon icon = ResourceController.getResourceController().getIcon(iconKey);
        button.setIcon(icon);
        return button;
    }

    public static JRadioButton createRadioButton(String labelKey) {
        JRadioButton component = new JRadioButton();
        String text = TextUtils.getRawText(labelKey);
        LabelAndMnemonicSetter.setLabelAndMnemonic(component, text);
        TranslatedElement.TEXT.setKey(component, labelKey);
        TranslatedElementFactory.createTooltip(component, labelKey + ".tooltip");
        return component;
    }
}

