/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.fop.util.ConversionUtils;
import org.apache.fop.util.XMLConstants;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class XMLUtil
implements XMLConstants {
    private XMLUtil() {
    }

    public static boolean getAttributeAsBoolean(Attributes attributes, String name, boolean defaultValue) {
        String s = attributes.getValue(name);
        if (s == null) {
            return defaultValue;
        }
        return Boolean.valueOf(s);
    }

    public static int getAttributeAsInt(Attributes attributes, String name, int defaultValue) {
        String s = attributes.getValue(name);
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static int getAttributeAsInt(Attributes attributes, String name) throws SAXException {
        String s = attributes.getValue(name);
        if (s == null) {
            throw new SAXException("Attribute '" + name + "' is missing");
        }
        return Integer.parseInt(s);
    }

    public static Integer getAttributeAsInteger(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public static Rectangle2D getAttributeAsRectangle2D(Attributes attributes, String name) {
        String s = attributes.getValue(name).trim();
        double[] values = ConversionUtils.toDoubleArray(s, "\\s");
        if (values.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 double values!");
        }
        return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
    }

    public static Rectangle getAttributeAsRectangle(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        int[] values = ConversionUtils.toIntArray(s.trim(), "\\s");
        if (values.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 int values!");
        }
        return new Rectangle(values[0], values[1], values[2], values[3]);
    }

    public static int[] getAttributeAsIntArray(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        return ConversionUtils.toIntArray(s.trim(), "\\s");
    }

    public static void addAttribute(AttributesImpl atts, QName attribute, String value) {
        atts.addAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getQName(), "CDATA", value);
    }

    public static void addAttribute(AttributesImpl atts, String localName, String value) {
        atts.addAttribute("", localName, localName, "CDATA", value);
    }

    public static String encodePositionAdjustments(int[][] dp, int paCount) {
        assert (dp != null);
        StringBuffer sb = new StringBuffer();
        int na = paCount;
        int nz = 0;
        sb.append(na);
        for (int i = 0; i < na; ++i) {
            int[] pa = dp[i];
            if (pa != null) {
                for (int k = 0; k < 4; ++k) {
                    int a = pa[k];
                    if (a != 0) {
                        XMLUtil.encodeNextAdjustment(sb, nz, a);
                        nz = 0;
                        continue;
                    }
                    ++nz;
                }
                continue;
            }
            nz += 4;
        }
        XMLUtil.encodeNextAdjustment(sb, nz, 0);
        return sb.toString();
    }

    public static String encodePositionAdjustments(int[][] dp) {
        assert (dp != null);
        return XMLUtil.encodePositionAdjustments(dp, dp.length);
    }

    private static void encodeNextAdjustment(StringBuffer sb, int nz, int a) {
        XMLUtil.encodeZeroes(sb, nz);
        XMLUtil.encodeAdjustment(sb, a);
    }

    private static void encodeZeroes(StringBuffer sb, int nz) {
        if (nz > 0) {
            sb.append(' ');
            if (nz == 1) {
                sb.append('0');
            } else {
                sb.append('Z');
                sb.append(nz);
            }
        }
    }

    private static void encodeAdjustment(StringBuffer sb, int a) {
        if (a != 0) {
            sb.append(' ');
            sb.append(a);
        }
    }

    public static int[][] decodePositionAdjustments(String value) {
        String[] sa;
        int[][] dp = null;
        if (value != null && (sa = value.split("\\s")) != null && sa.length > 0) {
            int na = Integer.parseInt(sa[0]);
            dp = new int[na][4];
            int n = sa.length;
            int k = 0;
            for (int i = 1; i < n; ++i) {
                String s = sa[i];
                if (s.charAt(0) == 'Z') {
                    int nz = Integer.parseInt(s.substring(1));
                    k += nz;
                    continue;
                }
                dp[k / 4][k % 4] = Integer.parseInt(s);
                ++k;
            }
        }
        return dp;
    }

    public static int[][] getAttributeAsPositionAdjustments(Attributes attributes, String name) {
        String s = attributes.getValue(name);
        if (s == null) {
            return null;
        }
        return XMLUtil.decodePositionAdjustments(s.trim());
    }

    public static String escape(String unescaped) {
        int needsEscape = 0;
        int n = unescaped.length();
        for (int i = 0; i < n; ++i) {
            char c = unescaped.charAt(i);
            if (c != '<' && c != '>' && c != '&') continue;
            ++needsEscape;
        }
        if (needsEscape > 0) {
            StringBuffer sb = new StringBuffer(unescaped.length() + 6 * needsEscape);
            int n2 = unescaped.length();
            for (int i = 0; i < n2; ++i) {
                char c = unescaped.charAt(i);
                if (c == '<' || c == '>' || c == '&') {
                    sb.append("&#x");
                    sb.append(Integer.toString(c, 16));
                    sb.append(';');
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return unescaped;
    }
}

