/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.markdown.markedj;

import io.github.gitbucket.markedj.Lexer;
import io.github.gitbucket.markedj.Parser;
import io.github.gitbucket.markedj.extension.Extension;
import io.github.gitbucket.markedj.extension.TokenConsumer;
import io.github.gitbucket.markedj.rule.FindFirstRule;
import io.github.gitbucket.markedj.rule.Rule;
import io.github.gitbucket.markedj.token.Token;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.freeplane.plugin.markdown.markedj.PlantUMLToken;

public class PlantUMLExtension
implements Extension {
    public static String[] EXPRESSIONS = new String[]{"(?s)(?m)\\A@startuml\\n.+?@enduml$", "(?s)(?m)\\A@startgantt\\n.+?@endgantt$", "(?s)(?m)\\A@startchronology\\n.+?@endchronology$", "(?s)(?m)\\A@startsalt\\n.+?@endsalt$", "(?s)(?m)\\A@startjson\\n.+?@endjson$", "(?s)(?m)\\A@startyaml\\n.+?@endyaml$", "(?s)(?m)\\A@startebnf\\n.+?@endebnf$", "(?s)(?m)\\A@startregex\\n.+?@endregex$", "(?s)(?m)\\A@startwbs\\n.+?@endwbs$", "(?s)(?m)\\A@startmindmap\\n.+?@endmindmap$"};
    private static final List<Rule> RULES = new LinkedList<Rule>();
    private static final String PRAGMA_LAYOUT_SMETANA = "!pragma layout smetana";
    private static final FileFormatOption FILE_FORMAT_OPTION_PNG;

    public Extension.LexResult lex(String src, Lexer.LexerContext context, TokenConsumer consumer) {
        boolean resultMatches = false;
        for (Rule rule : RULES) {
            List cap = rule.exec(src);
            if (cap.isEmpty()) continue;
            String plantUmlCode = (String)cap.get(0);
            context.pushToken((Token)new PlantUMLToken(plantUmlCode));
            src = src.substring(plantUmlCode.length());
            resultMatches = true;
            break;
        }
        return new Extension.LexResult(src, resultMatches);
    }

    public boolean handlesToken(String tokenType) {
        return PlantUMLToken.TYPE.equals(tokenType);
    }

    public String parse(Parser.ParserContext context, Function<Parser.ParserContext, String> tok) {
        DiagramDescription diagramDescription;
        PlantUMLToken plantUmlToken = (PlantUMLToken)context.currentToken();
        String plantUmlCode = plantUmlToken.getText();
        List<String> plantumlList = Arrays.asList(plantUmlCode.split("\n"));
        boolean smetanaFound = plantumlList.stream().map(String::trim).anyMatch(PRAGMA_LAYOUT_SMETANA::equals);
        if (!smetanaFound) {
            LinkedList<String> list = new LinkedList<String>(plantumlList);
            list.add(1, PRAGMA_LAYOUT_SMETANA);
            plantUmlCode = String.join((CharSequence)"\n", list);
        }
        SourceStringReader reader = new SourceStringReader(plantUmlCode);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean useCache = ImageIO.getUseCache();
        try {
            ImageIO.setUseCache(false);
            diagramDescription = reader.outputImage((OutputStream)outputStream, FILE_FORMAT_OPTION_PNG);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ImageIO.setUseCache(useCache);
        }
        if (diagramDescription != null) {
            String base64String = Base64.getEncoder().encodeToString(outputStream.toByteArray());
            return String.format("<div class=\"plantuml\"><img src=\"data:image/png;base64,%s\"></div>%n", base64String);
        }
        return String.format("<pre><code>/!\\ Diagram creation failed /!\\%n%n%s</code></pre>", plantUmlCode);
    }

    static {
        for (String expr : EXPRESSIONS) {
            RULES.add((Rule)new FindFirstRule(expr));
        }
        FILE_FORMAT_OPTION_PNG = new FileFormatOption(FileFormat.PNG);
    }
}

