/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.markdown;

import io.github.gitbucket.markedj.Marked;
import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.extension.Extension;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.function.Supplier;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.JTextComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JRestrictedSizeScrollPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.note.NoteController;
import org.freeplane.features.note.NoteModel;
import org.freeplane.features.text.AbstractContentTransformer;
import org.freeplane.features.text.DetailModel;
import org.freeplane.features.text.IContentTransformer;
import org.freeplane.features.text.TextController;
import org.freeplane.features.text.TransformationException;
import org.freeplane.features.text.mindmapmode.EditNodeBase;
import org.freeplane.features.text.mindmapmode.EditNodeDialog;
import org.freeplane.features.text.mindmapmode.IEditBaseCreator;
import org.freeplane.features.text.mindmapmode.MTextController;
import org.freeplane.features.text.mindmapmode.SourceTextEditorUIConfigurator;

public class MarkdownRenderer
extends AbstractContentTransformer
implements IEditBaseCreator {
    private static final String MARKDOWN_EDITOR_FONT_SIZE = "markdown_editor_font_size";
    private static final String MARKDOWN_EDITOR_FONT = "markdown_editor_font";
    private static final String MARKDOWN_EDITOR_DISABLE_INLINE = "markdown_disable_editor";
    static final String MARKDOWN_CONTENT_TYPE = "markdown";
    static final String MARKDOWN_FORMAT = "markdownPatternFormat";
    private final Options options = this.createMarkdownOptions();

    private Options createMarkdownOptions() {
        Options options = new Options();
        options.setSafelist(null);
        return options;
    }

    public MarkdownRenderer() {
        super(30);
    }

    public void addExtension(Extension extension) {
        this.options.addExtension(extension);
    }

    public Object transformContent(NodeModel node, Object nodeProperty, Object content, TextController textController, IContentTransformer.Mode mode) throws TransformationException {
        if (mode == IContentTransformer.Mode.TEXT) {
            return content;
        }
        String text = this.getText(node, nodeProperty, content, textController);
        if (text == null) {
            return content;
        }
        String markdown = text;
        String html = "<html><body>" + Marked.marked((String)markdown, (Options)this.options) + "</body></html>";
        return html;
    }

    public EditNodeBase createEditor(NodeModel node, Object nodeProperty, Object content, EditNodeBase.IEditControl editControl, boolean editLong) {
        JEditorPane textEditor = this.createTextEditorPane(this::createScrollPane, node, nodeProperty, content, !editLong);
        return textEditor == null ? null : this.createEditor(node, editControl, textEditor);
    }

    private JRestrictedSizeScrollPane createScrollPane() {
        JRestrictedSizeScrollPane scrollPane = new JRestrictedSizeScrollPane();
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        scrollPane.setMinimumSize(new Dimension(0, 60));
        return scrollPane;
    }

    public JEditorPane createTextEditorPane(Supplier<JScrollPane> scrollPaneSupplier, NodeModel node, Object nodeProperty, Object content, boolean editInline) {
        String text = this.getText(node, nodeProperty, content, (TextController)MTextController.getController());
        if (text == null) {
            return null;
        }
        if (editInline && ResourceController.getResourceController().getBooleanProperty(MARKDOWN_EDITOR_DISABLE_INLINE)) {
            return null;
        }
        JEditorPane textEditor = new JEditorPane();
        scrollPaneSupplier.get().setViewportView(textEditor);
        textEditor.setContentType("text/markdown");
        textEditor.setText(text);
        SourceTextEditorUIConfigurator.configureColors((JTextComponent)textEditor);
        String fontName = ResourceController.getResourceController().getProperty(MARKDOWN_EDITOR_FONT);
        int fontSize = ResourceController.getResourceController().getIntProperty(MARKDOWN_EDITOR_FONT_SIZE);
        Font font = UITools.scaleUI((Font)new Font(fontName, 0, fontSize));
        textEditor.setFont(font);
        return textEditor;
    }

    private EditNodeBase createEditor(NodeModel node, EditNodeBase.IEditControl editControl, JEditorPane textEditor) {
        KeyEvent firstKeyEvent = MTextController.getController().getEventQueue().getFirstEvent();
        EditNodeDialog editNodeDialog = new EditNodeDialog(node, firstKeyEvent, false, editControl, false, textEditor);
        editNodeDialog.setTitle(TextUtils.getText((String)"markdown_editor"));
        return editNodeDialog;
    }

    private String getText(NodeModel node, Object nodeProperty, Object content, TextController textController) {
        if (!(content instanceof String)) {
            return null;
        }
        NoteController noteController = NoteController.getController();
        if (!(nodeProperty instanceof NodeModel && MARKDOWN_FORMAT.equals(textController.getNodeFormat(node)) || nodeProperty instanceof DetailModel && MARKDOWN_CONTENT_TYPE.equals(textController.getDetailsContentType(node)) || nodeProperty instanceof NoteModel && MARKDOWN_CONTENT_TYPE.equals(noteController.getNoteContentType(node)))) {
            return null;
        }
        String plainOrHtmlText = (String)content;
        String text = HtmlUtils.htmlToPlain((String)plainOrHtmlText);
        return text;
    }
}

