/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.action.ActionManager;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.io.FreeColDirectories;

public final class MainPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(MainPanel.class.getName());

    public MainPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout("wrap 1, insets 32px 32px 32px 32px, gap 0", "[center]"));
        boolean canContinue = FreeColDirectories.getLastSaveGameFile() != null;
        ActionManager am = this.getFreeColClient().getActionManager();
        JButton newButton = this.createImportantButton(am.getFreeColAction("newAction"));
        JButton openButton = this.createImportantButton(am.getFreeColAction("openAction"));
        JButton mapEditorButton = this.createImportantButton(am.getFreeColAction("mapEditorAction"));
        JButton optionsButton = this.createImportantButton(am.getFreeColAction("preferencesAction"));
        JButton aboutButton = this.createImportantButton(am.getFreeColAction("aboutAction"));
        JButton quitButton = this.createImportantButton(am.getFreeColAction("quitAction"));
        this.okButton.setAction(am.getFreeColAction(canContinue ? "continueAction" : "newAction"));
        JLabel logoLabel = new JLabel(new ImageIcon(ImageLibrary.getUnscaledImage("image.flavor.Title")));
        this.add(logoLabel);
        JLabel versionLabel = new JLabel(FreeCol.getVersion());
        versionLabel.setForeground(new Color(180, 162, 66));
        this.add(versionLabel);
        MigPanel buttons = new MigPanel(new MigLayout("wrap 2"));
        buttons.setOpaque(false);
        buttons.add((Component)this.okButton, "grow");
        if (canContinue) {
            buttons.add((Component)newButton, "grow");
        }
        buttons.add((Component)openButton, "grow");
        buttons.add((Component)mapEditorButton, "grow");
        buttons.add((Component)optionsButton, "grow");
        buttons.add((Component)aboutButton, "grow");
        buttons.add((Component)quitButton, "grow, span");
        this.add((Component)buttons, "gapy 16px");
        this.setSize(this.getPreferredSize());
    }

    private JButton createImportantButton(Action action) {
        FreeColButton button = new FreeColButton(FreeColButton.ButtonStyle.IMPORTANT, action);
        return button;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.getGUI().removeComponent(this);
    }
}

