# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "monitor diagnostic-settings subscription update",
)
class Update(AAZCommand):
    """Update subscription diagnostic settings for the specified resource.
    """

    _aaz_info = {
        "version": "2017-05-01-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.insights/diagnosticsettings/{}", "2017-05-01-preview"],
        ]
    }

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the diagnostic setting.",
            required=True,
            id_part="name",
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location of the resource",
            nullable=True,
        )
        _args_schema.event_hub_auth_rule = AAZStrArg(
            options=["--event-hub-auth-rule"],
            help="The resource Id for the event hub authorization rule.",
            nullable=True,
        )
        _args_schema.event_hub_name = AAZStrArg(
            options=["--event-hub-name"],
            help="The name of the event hub. If none is specified, the default event hub will be selected.",
            nullable=True,
        )
        _args_schema.logs = AAZListArg(
            options=["--logs"],
            help="JSON encoded list of logs settings. Use '@{file}' to load from a file.",
            nullable=True,
        )
        _args_schema.service_bus_rule = AAZStrArg(
            options=["--service-bus-rule"],
            help="The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format '{service bus resourceID}/authorizationrules/{key name}'.",
            nullable=True,
        )
        _args_schema.storage_account = AAZStrArg(
            options=["--storage-account"],
            help="The resource id of the storage account to which you would like to send the Activity Log.",
            nullable=True,
        )
        _args_schema.workspace = AAZStrArg(
            options=["--workspace"],
            help="The resource id of the log analytics workspace.",
            nullable=True,
        )

        logs = cls._args_schema.logs
        logs.Element = AAZObjectArg(
            nullable=True,
        )

        _element = cls._args_schema.logs.Element
        _element.category = AAZStrArg(
            options=["category"],
            help="Name of a Subscription Diagnostic Log category for a resource type this setting is applied to.",
            nullable=True,
        )
        _element.enabled = AAZBoolArg(
            options=["enabled"],
            help="a value indicating whether this log is enabled.",
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.SubscriptionDiagnosticSettingsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        self.SubscriptionDiagnosticSettingsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class SubscriptionDiagnosticSettingsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/microsoft.insights/diagnosticSettings/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-05-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _build_schema_subscription_diagnostic_settings_resource_read(cls._schema_on_200)

            return cls._schema_on_200

    class SubscriptionDiagnosticSettingsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/microsoft.insights/diagnosticSettings/{name}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "name", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2017-05-01-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _build_schema_subscription_diagnostic_settings_resource_read(cls._schema_on_200)

            return cls._schema_on_200

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("eventHubAuthorizationRuleId", AAZStrType, ".event_hub_auth_rule")
                properties.set_prop("eventHubName", AAZStrType, ".event_hub_name")
                properties.set_prop("logs", AAZListType, ".logs")
                properties.set_prop("serviceBusRuleId", AAZStrType, ".service_bus_rule")
                properties.set_prop("storageAccountId", AAZStrType, ".storage_account")
                properties.set_prop("workspaceId", AAZStrType, ".workspace")

            logs = _builder.get(".properties.logs")
            if logs is not None:
                logs.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.logs[]")
            if _elements is not None:
                _elements.set_prop("category", AAZStrType, ".category")
                _elements.set_prop("enabled", AAZBoolType, ".enabled", typ_kwargs={"flags": {"required": True}})

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


_schema_subscription_diagnostic_settings_resource_read = None


def _build_schema_subscription_diagnostic_settings_resource_read(_schema):
    global _schema_subscription_diagnostic_settings_resource_read
    if _schema_subscription_diagnostic_settings_resource_read is not None:
        _schema.id = _schema_subscription_diagnostic_settings_resource_read.id
        _schema.location = _schema_subscription_diagnostic_settings_resource_read.location
        _schema.name = _schema_subscription_diagnostic_settings_resource_read.name
        _schema.properties = _schema_subscription_diagnostic_settings_resource_read.properties
        _schema.type = _schema_subscription_diagnostic_settings_resource_read.type
        return

    _schema_subscription_diagnostic_settings_resource_read = AAZObjectType()

    subscription_diagnostic_settings_resource_read = _schema_subscription_diagnostic_settings_resource_read
    subscription_diagnostic_settings_resource_read.id = AAZStrType(
        flags={"read_only": True},
    )
    subscription_diagnostic_settings_resource_read.location = AAZStrType()
    subscription_diagnostic_settings_resource_read.name = AAZStrType(
        flags={"read_only": True},
    )
    subscription_diagnostic_settings_resource_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    subscription_diagnostic_settings_resource_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subscription_diagnostic_settings_resource_read.properties
    properties.event_hub_authorization_rule_id = AAZStrType(
        serialized_name="eventHubAuthorizationRuleId",
    )
    properties.event_hub_name = AAZStrType(
        serialized_name="eventHubName",
    )
    properties.logs = AAZListType()
    properties.service_bus_rule_id = AAZStrType(
        serialized_name="serviceBusRuleId",
    )
    properties.storage_account_id = AAZStrType(
        serialized_name="storageAccountId",
    )
    properties.workspace_id = AAZStrType(
        serialized_name="workspaceId",
    )

    logs = _schema_subscription_diagnostic_settings_resource_read.properties.logs
    logs.Element = AAZObjectType()

    _element = _schema_subscription_diagnostic_settings_resource_read.properties.logs.Element
    _element.category = AAZStrType()
    _element.enabled = AAZBoolType(
        flags={"required": True},
    )

    _schema.id = _schema_subscription_diagnostic_settings_resource_read.id
    _schema.location = _schema_subscription_diagnostic_settings_resource_read.location
    _schema.name = _schema_subscription_diagnostic_settings_resource_read.name
    _schema.properties = _schema_subscription_diagnostic_settings_resource_read.properties
    _schema.type = _schema_subscription_diagnostic_settings_resource_read.type


__all__ = ["Update"]
