# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CloudName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud resource's cloud name."""

    AZURE = "Azure"
    AWS = "AWS"
    GCP = "GCP"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class OfferingType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the security offering."""

    CSPM_MONITOR_AWS = "CspmMonitorAws"
    DEFENDER_FOR_CONTAINERS_AWS = "DefenderForContainersAws"
    DEFENDER_FOR_SERVERS_AWS = "DefenderForServersAws"
    INFORMATION_PROTECTION_AWS = "InformationProtectionAws"


class OrganizationMembershipType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The multi cloud account's membership type in the organization."""

    MEMBER = "Member"
    ORGANIZATION = "Organization"


class SeverityEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The severity to relate to the assessments generated by this assessment automation."""

    HIGH = "High"
    MEDIUM = "Medium"
    LOW = "Low"


class SupportedCloudEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Relevant cloud for the custom assessment automation."""

    AWS = "AWS"
    GCP = "GCP"
