/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.EncapsulationException;
import com.zeroc.Ice.EncodingVersion;
import com.zeroc.Ice.FormatType;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.MarshalException;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.SliceInfo;
import com.zeroc.Ice.SlicedData;
import com.zeroc.Ice.UserException;
import com.zeroc.Ice.Value;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.Ex;
import com.zeroc.IceInternal.Instance;
import com.zeroc.IceInternal.OutputStreamWrapper;
import com.zeroc.IceInternal.Protocol;
import com.zeroc.IceInternal.Util;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;

public class OutputStream {
    static final Charset _utf8 = Charset.forName("UTF8");
    private CharsetEncoder _charEncoder = null;
    private Instance _instance;
    private Buffer _buf;
    private Object _closure;
    private FormatType _format;
    private byte[] _stringBytes;
    private char[] _stringChars;
    private EncodingVersion _encoding;
    private Encaps _encapsStack;
    private Encaps _encapsCache;

    public OutputStream() {
        this(false);
    }

    public OutputStream(boolean direct) {
        this._buf = new Buffer(direct);
        this._instance = null;
        this._closure = null;
        this._encoding = Protocol.currentEncoding;
        this._format = FormatType.CompactFormat;
    }

    public OutputStream(Communicator communicator) {
        assert (communicator != null);
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, instance.defaultsAndOverrides().defaultEncoding, instance.cacheMessageBuffers() > 1);
    }

    public OutputStream(Communicator communicator, boolean direct) {
        assert (communicator != null);
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, instance.defaultsAndOverrides().defaultEncoding, direct);
    }

    public OutputStream(Communicator communicator, EncodingVersion encoding) {
        Instance instance;
        assert (communicator != null);
        this.initialize(instance, encoding, (instance = Util.getInstance(communicator)).cacheMessageBuffers() > 1);
    }

    public OutputStream(Communicator communicator, EncodingVersion encoding, boolean direct) {
        assert (communicator != null);
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, encoding, direct);
    }

    public OutputStream(Instance instance, EncodingVersion encoding) {
        this.initialize(instance, encoding, instance.cacheMessageBuffers() > 1);
    }

    public OutputStream(Instance instance, EncodingVersion encoding, boolean direct) {
        this.initialize(instance, encoding, direct);
    }

    public OutputStream(Instance instance, EncodingVersion encoding, Buffer buf, boolean adopt) {
        this.initialize(instance, encoding, new Buffer(buf, adopt));
    }

    public void initialize(Communicator communicator) {
        assert (communicator != null);
        Instance instance = Util.getInstance(communicator);
        this.initialize(instance, instance.defaultsAndOverrides().defaultEncoding, instance.cacheMessageBuffers() > 1);
    }

    public void initialize(Communicator communicator, EncodingVersion encoding) {
        Instance instance;
        assert (communicator != null);
        this.initialize(instance, encoding, (instance = Util.getInstance(communicator)).cacheMessageBuffers() > 1);
    }

    private void initialize(Instance instance, EncodingVersion encoding, boolean direct) {
        this.initialize(instance, encoding, new Buffer(direct));
    }

    private void initialize(Instance instance, EncodingVersion encoding, Buffer buf) {
        assert (instance != null);
        this._instance = instance;
        this._buf = buf;
        this._closure = null;
        this._encoding = encoding;
        this._format = this._instance.defaultsAndOverrides().defaultFormat;
        this._encapsStack = null;
        this._encapsCache = null;
    }

    public void reset() {
        this._buf.reset();
        this.clear();
    }

    public void clear() {
        if (this._encapsStack != null) {
            assert (this._encapsStack.next == null);
            this._encapsStack.next = this._encapsCache;
            this._encapsCache = this._encapsStack;
            this._encapsCache.reset();
            this._encapsStack = null;
        }
    }

    public Instance instance() {
        return this._instance;
    }

    public void setFormat(FormatType fmt) {
        this._format = fmt;
    }

    public Object getClosure() {
        return this._closure;
    }

    public Object setClosure(Object p) {
        Object prev = this._closure;
        this._closure = p;
        return prev;
    }

    public byte[] finished() {
        Buffer buf = this.prepareWrite();
        byte[] result = new byte[buf.b.limit()];
        buf.b.get(result);
        return result;
    }

    public void swap(OutputStream other) {
        assert (this._instance == other._instance);
        Buffer tmpBuf = other._buf;
        other._buf = this._buf;
        this._buf = tmpBuf;
        EncodingVersion tmpEncoding = other._encoding;
        other._encoding = this._encoding;
        this._encoding = tmpEncoding;
        Object tmpClosure = other._closure;
        other._closure = this._closure;
        this._closure = tmpClosure;
        this.resetEncapsulation();
        other.resetEncapsulation();
    }

    private void resetEncapsulation() {
        this._encapsStack = null;
    }

    public void resize(int sz) {
        this._buf.resize(sz, false);
        this._buf.position(sz);
    }

    public Buffer prepareWrite() {
        this._buf.limit(this._buf.size());
        this._buf.position(0);
        return this._buf;
    }

    public Buffer getBuffer() {
        return this._buf;
    }

    public void startValue(SlicedData data) {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.startInstance(SliceType.ValueSlice, data);
    }

    public void endValue() {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.endInstance();
    }

    public void startException(SlicedData data) {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.startInstance(SliceType.ExceptionSlice, data);
    }

    public void endException() {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.endInstance();
    }

    public void startEncapsulation() {
        if (this._encapsStack != null) {
            this.startEncapsulation(this._encapsStack.encoding, this._encapsStack.format);
        } else {
            this.startEncapsulation(this._encoding, FormatType.DefaultFormat);
        }
    }

    public void startEncapsulation(EncodingVersion encoding, FormatType format) {
        Protocol.checkSupportedEncoding(encoding);
        Encaps curr = this._encapsCache;
        if (curr != null) {
            curr.reset();
            this._encapsCache = this._encapsCache.next;
        } else {
            curr = new Encaps();
        }
        curr.next = this._encapsStack;
        this._encapsStack = curr;
        this._encapsStack.format = format;
        this._encapsStack.setEncoding(encoding);
        this._encapsStack.start = this._buf.size();
        this.writeInt(0);
        this._encapsStack.encoding.ice_writeMembers(this);
    }

    public void endEncapsulation() {
        assert (this._encapsStack != null);
        int start = this._encapsStack.start;
        int sz = this._buf.size() - start;
        this._buf.b.putInt(start, sz);
        Encaps curr = this._encapsStack;
        this._encapsStack = curr.next;
        curr.next = this._encapsCache;
        this._encapsCache = curr;
        this._encapsCache.reset();
    }

    public void writeEmptyEncapsulation(EncodingVersion encoding) {
        Protocol.checkSupportedEncoding(encoding);
        this.writeInt(6);
        encoding.ice_writeMembers(this);
    }

    public void writeEncapsulation(byte[] v) {
        if (v.length < 6) {
            throw new EncapsulationException();
        }
        this.expand(v.length);
        this._buf.b.put(v);
    }

    public EncodingVersion getEncoding() {
        return this._encapsStack != null ? this._encapsStack.encoding : this._encoding;
    }

    public void startSlice(String typeId, int compactId, boolean last) {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.startSlice(typeId, compactId, last);
    }

    public void endSlice() {
        assert (this._encapsStack != null && this._encapsStack.encoder != null);
        this._encapsStack.encoder.endSlice();
    }

    public void writePendingValues() {
        if (this._encapsStack != null && this._encapsStack.encoder != null) {
            this._encapsStack.encoder.writePendingValues();
        } else if (this._encapsStack != null ? this._encapsStack.encoding_1_0 : this._encoding.equals(com.zeroc.Ice.Util.Encoding_1_0)) {
            this.writeSize(0);
        }
    }

    public void writeSize(int v) {
        if (v > 254) {
            this.expand(5);
            this._buf.b.put((byte)-1);
            this._buf.b.putInt(v);
        } else {
            this.expand(1);
            this._buf.b.put((byte)v);
        }
    }

    public int startSize() {
        int pos = this._buf.b.position();
        this.writeInt(0);
        return pos;
    }

    public void endSize(int pos) {
        assert (pos >= 0);
        this.rewriteInt(this._buf.b.position() - pos - 4, pos);
    }

    public void writeBlob(byte[] v) {
        if (v == null) {
            return;
        }
        this.expand(v.length);
        this._buf.b.put(v);
    }

    public void writeBlob(byte[] v, int off, int len) {
        if (v == null) {
            return;
        }
        this.expand(len);
        this._buf.b.put(v, off, len);
    }

    public boolean writeOptional(int tag, OptionalFormat format) {
        assert (this._encapsStack != null);
        if (this._encapsStack.encoder != null) {
            return this._encapsStack.encoder.writeOptional(tag, format);
        }
        return this.writeOptionalImpl(tag, format);
    }

    public void writeByte(byte v) {
        this.expand(1);
        this._buf.b.put(v);
    }

    public void writeByte(int tag, Optional<Byte> v) {
        if (v != null && v.isPresent()) {
            this.writeByte(tag, v.get());
        }
    }

    public void writeByte(int tag, byte v) {
        if (this.writeOptional(tag, OptionalFormat.F1)) {
            this.writeByte(v);
        }
    }

    public void rewriteByte(byte v, int dest) {
        this._buf.b.put(dest, v);
    }

    public void writeByteSeq(byte[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            this._buf.b.put(v);
        }
    }

    public void writeByteSeq(int tag, Optional<byte[]> v) {
        if (v != null && v.isPresent()) {
            this.writeByteSeq(tag, v.get());
        }
    }

    public void writeByteSeq(int tag, byte[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeByteSeq(v);
        }
    }

    public void writeByteBuffer(ByteBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            this.writeSize(v.remaining());
            this.expand(v.remaining());
            this._buf.b.put(v);
        }
    }

    public void writeSerializable(Serializable o) {
        if (o == null) {
            this.writeSize(0);
            return;
        }
        try {
            OutputStreamWrapper w = new OutputStreamWrapper(this);
            ObjectOutputStream out = new ObjectOutputStream(w);
            out.writeObject(o);
            out.close();
            w.close();
        }
        catch (Exception ex) {
            throw new MarshalException("cannot serialize object: " + ex);
        }
    }

    public <T extends Serializable> void writeSerializable(int tag, Optional<T> v) {
        if (v != null && v.isPresent()) {
            this.writeSerializable(tag, (Serializable)v.get());
        }
    }

    public void writeSerializable(int tag, Serializable v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSerializable(v);
        }
    }

    public void writeBool(boolean v) {
        this.expand(1);
        this._buf.b.put(v ? (byte)1 : 0);
    }

    public void writeBool(int tag, Optional<Boolean> v) {
        if (v != null && v.isPresent()) {
            this.writeBool(tag, v.get());
        }
    }

    public void writeBool(int tag, boolean v) {
        if (this.writeOptional(tag, OptionalFormat.F1)) {
            this.writeBool(v);
        }
    }

    public void rewriteBool(boolean v, int dest) {
        this._buf.b.put(dest, v ? (byte)1 : 0);
    }

    public void writeBoolSeq(boolean[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length);
            for (boolean b : v) {
                this._buf.b.put(b ? (byte)1 : 0);
            }
        }
    }

    public void writeBoolSeq(int tag, Optional<boolean[]> v) {
        if (v != null && v.isPresent()) {
            this.writeBoolSeq(tag, v.get());
        }
    }

    public void writeBoolSeq(int tag, boolean[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeBoolSeq(v);
        }
    }

    public void writeShort(short v) {
        this.expand(2);
        this._buf.b.putShort(v);
    }

    public void writeShort(int tag, Optional<Short> v) {
        if (v != null && v.isPresent()) {
            this.writeShort(tag, v.get());
        }
    }

    public void writeShort(int tag, short v) {
        if (this.writeOptional(tag, OptionalFormat.F2)) {
            this.writeShort(v);
        }
    }

    public void writeShortSeq(short[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.put(v);
            this._buf.position(this._buf.b.position() + v.length * 2);
        }
    }

    public void writeShortSeq(int tag, Optional<short[]> v) {
        if (v != null && v.isPresent()) {
            this.writeShortSeq(tag, v.get());
        }
    }

    public void writeShortSeq(int tag, short[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 2 + (v.length > 254 ? 5 : 1));
            this.writeShortSeq(v);
        }
    }

    public void writeShortBuffer(ShortBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 2);
            ShortBuffer shortBuf = this._buf.b.asShortBuffer();
            shortBuf.put(v);
            this._buf.position(this._buf.b.position() + sz * 2);
        }
    }

    public void writeInt(int v) {
        this.expand(4);
        this._buf.b.putInt(v);
    }

    public void writeInt(int tag, OptionalInt v) {
        if (v != null && v.isPresent()) {
            this.writeInt(tag, v.getAsInt());
        }
    }

    public void writeInt(int tag, int v) {
        if (this.writeOptional(tag, OptionalFormat.F4)) {
            this.writeInt(v);
        }
    }

    public void rewriteInt(int v, int dest) {
        this._buf.b.putInt(dest, v);
    }

    public void writeIntSeq(int[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.put(v);
            this._buf.position(this._buf.b.position() + v.length * 4);
        }
    }

    public void writeIntSeq(int tag, Optional<int[]> v) {
        if (v != null && v.isPresent()) {
            this.writeIntSeq(tag, v.get());
        }
    }

    public void writeIntSeq(int tag, int[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 4 + (v.length > 254 ? 5 : 1));
            this.writeIntSeq(v);
        }
    }

    public void writeIntBuffer(IntBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 4);
            IntBuffer intBuf = this._buf.b.asIntBuffer();
            intBuf.put(v);
            this._buf.position(this._buf.b.position() + sz * 4);
        }
    }

    public void writeLong(long v) {
        this.expand(8);
        this._buf.b.putLong(v);
    }

    public void writeLong(int tag, OptionalLong v) {
        if (v != null && v.isPresent()) {
            this.writeLong(tag, v.getAsLong());
        }
    }

    public void writeLong(int tag, long v) {
        if (this.writeOptional(tag, OptionalFormat.F8)) {
            this.writeLong(v);
        }
    }

    public void writeLongSeq(long[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.put(v);
            this._buf.position(this._buf.b.position() + v.length * 8);
        }
    }

    public void writeLongSeq(int tag, Optional<long[]> v) {
        if (v != null && v.isPresent()) {
            this.writeLongSeq(tag, v.get());
        }
    }

    public void writeLongSeq(int tag, long[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 8 + (v.length > 254 ? 5 : 1));
            this.writeLongSeq(v);
        }
    }

    public void writeLongBuffer(LongBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 8);
            LongBuffer longBuf = this._buf.b.asLongBuffer();
            longBuf.put(v);
            this._buf.position(this._buf.b.position() + sz * 8);
        }
    }

    public void writeFloat(float v) {
        this.expand(4);
        this._buf.b.putFloat(v);
    }

    public void writeFloat(int tag, Optional<Float> v) {
        if (v != null && v.isPresent()) {
            this.writeFloat(tag, v.get().floatValue());
        }
    }

    public void writeFloat(int tag, float v) {
        if (this.writeOptional(tag, OptionalFormat.F4)) {
            this.writeFloat(v);
        }
    }

    public void writeFloatSeq(float[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.put(v);
            this._buf.position(this._buf.b.position() + v.length * 4);
        }
    }

    public void writeFloatSeq(int tag, Optional<float[]> v) {
        if (v != null && v.isPresent()) {
            this.writeFloatSeq(tag, v.get());
        }
    }

    public void writeFloatSeq(int tag, float[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 4 + (v.length > 254 ? 5 : 1));
            this.writeFloatSeq(v);
        }
    }

    public void writeFloatBuffer(FloatBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 4);
            FloatBuffer floatBuf = this._buf.b.asFloatBuffer();
            floatBuf.put(v);
            this._buf.position(this._buf.b.position() + sz * 4);
        }
    }

    public void writeDouble(double v) {
        this.expand(8);
        this._buf.b.putDouble(v);
    }

    public void writeDouble(int tag, OptionalDouble v) {
        if (v != null && v.isPresent()) {
            this.writeDouble(tag, v.getAsDouble());
        }
    }

    public void writeDouble(int tag, double v) {
        if (this.writeOptional(tag, OptionalFormat.F8)) {
            this.writeDouble(v);
        }
    }

    public void writeDoubleSeq(double[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            this.expand(v.length * 8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.put(v);
            this._buf.position(this._buf.b.position() + v.length * 8);
        }
    }

    public void writeDoubleSeq(int tag, Optional<double[]> v) {
        if (v != null && v.isPresent()) {
            this.writeDoubleSeq(tag, v.get());
        }
    }

    public void writeDoubleSeq(int tag, double[] v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeSize(v == null || v.length == 0 ? 1 : v.length * 8 + (v.length > 254 ? 5 : 1));
            this.writeDoubleSeq(v);
        }
    }

    public void writeDoubleBuffer(DoubleBuffer v) {
        if (v == null || v.remaining() == 0) {
            this.writeSize(0);
        } else {
            int sz = v.remaining();
            this.writeSize(sz);
            this.expand(sz * 8);
            DoubleBuffer doubleBuf = this._buf.b.asDoubleBuffer();
            doubleBuf.put(v);
            this._buf.position(this._buf.b.position() + sz * 8);
        }
    }

    public void writeString(String v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            int len = v.length();
            if (len > 0) {
                if (this._stringBytes == null || len > this._stringBytes.length) {
                    this._stringBytes = new byte[len];
                }
                if (this._stringChars == null || len > this._stringChars.length) {
                    this._stringChars = new char[len];
                }
                v.getChars(0, len, this._stringChars, 0);
                for (int i = 0; i < len; ++i) {
                    if (this._stringChars[i] > '\u007f') {
                        if (this._charEncoder == null) {
                            this._charEncoder = _utf8.newEncoder();
                        }
                        ByteBuffer b = null;
                        try {
                            b = this._charEncoder.encode(CharBuffer.wrap(this._stringChars, 0, len));
                        }
                        catch (CharacterCodingException ex) {
                            throw new MarshalException(ex);
                        }
                        this.writeSize(b.limit());
                        this.expand(b.limit());
                        this._buf.b.put(b);
                        return;
                    }
                    this._stringBytes[i] = (byte)this._stringChars[i];
                }
                this.writeSize(len);
                this.expand(len);
                this._buf.b.put(this._stringBytes, 0, len);
            } else {
                this.writeSize(0);
            }
        }
    }

    public void writeString(int tag, Optional<String> v) {
        if (v != null && v.isPresent()) {
            this.writeString(tag, v.get());
        }
    }

    public void writeString(int tag, String v) {
        if (this.writeOptional(tag, OptionalFormat.VSize)) {
            this.writeString(v);
        }
    }

    public void writeStringSeq(String[] v) {
        if (v == null) {
            this.writeSize(0);
        } else {
            this.writeSize(v.length);
            for (String e : v) {
                this.writeString(e);
            }
        }
    }

    public void writeStringSeq(int tag, Optional<String[]> v) {
        if (v != null && v.isPresent()) {
            this.writeStringSeq(tag, v.get());
        }
    }

    public void writeStringSeq(int tag, String[] v) {
        if (this.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = this.startSize();
            this.writeStringSeq(v);
            this.endSize(pos);
        }
    }

    public void writeProxy(ObjectPrx v) {
        if (v != null) {
            v._write(this);
        } else {
            Identity ident = new Identity();
            ident.ice_writeMembers(this);
        }
    }

    public void writeProxy(int tag, Optional<ObjectPrx> v) {
        if (v != null && v.isPresent()) {
            this.writeProxy(tag, v.get());
        }
    }

    public void writeProxy(int tag, ObjectPrx v) {
        if (this.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = this.startSize();
            this.writeProxy(v);
            this.endSize(pos);
        }
    }

    public void writeEnum(int v, int maxValue) {
        if (this.isEncoding_1_0()) {
            if (maxValue < 127) {
                this.writeByte((byte)v);
            } else if (maxValue < Short.MAX_VALUE) {
                this.writeShort((short)v);
            } else {
                this.writeInt(v);
            }
        } else {
            this.writeSize(v);
        }
    }

    public void writeValue(Value v) {
        this.initEncaps();
        this._encapsStack.encoder.writeValue(v);
    }

    public <T extends Value> void writeValue(int tag, Optional<T> v) {
        if (v != null && v.isPresent()) {
            this.writeValue(tag, (Value)v.get());
        }
    }

    public void writeValue(int tag, Value v) {
        if (this.writeOptional(tag, OptionalFormat.Class)) {
            this.writeValue(v);
        }
    }

    public void writeException(UserException v) {
        this.initEncaps();
        this._encapsStack.encoder.writeException(v);
    }

    private boolean writeOptionalImpl(int tag, OptionalFormat format) {
        if (this.isEncoding_1_0()) {
            return false;
        }
        int v = format.value();
        if (tag < 30) {
            this.writeByte((byte)(v |= tag << 3));
        } else {
            this.writeByte((byte)(v |= 0xF0));
            this.writeSize(tag);
        }
        return true;
    }

    public int pos() {
        return this._buf.b.position();
    }

    public void pos(int n) {
        this._buf.position(n);
    }

    public int size() {
        return this._buf.size();
    }

    public boolean isEmpty() {
        return this._buf.empty();
    }

    public void expand(int n) {
        this._buf.expand(n);
    }

    private boolean isEncoding_1_0() {
        return this._encapsStack != null ? this._encapsStack.encoding_1_0 : this._encoding.equals(com.zeroc.Ice.Util.Encoding_1_0);
    }

    private void initEncaps() {
        if (this._encapsStack == null) {
            this._encapsStack = this._encapsCache;
            if (this._encapsStack != null) {
                this._encapsCache = this._encapsCache.next;
            } else {
                this._encapsStack = new Encaps();
            }
            this._encapsStack.setEncoding(this._encoding);
        }
        if (this._encapsStack.format == FormatType.DefaultFormat) {
            this._encapsStack.format = this._format;
        }
        if (this._encapsStack.encoder == null) {
            this._encapsStack.encoder = this._encapsStack.encoding_1_0 ? new EncapsEncoder10(this, this._encapsStack) : new EncapsEncoder11(this, this._encapsStack);
        }
    }

    @FunctionalInterface
    public static interface Marshaler {
        public void marshal(OutputStream var1);
    }

    private static final class Encaps {
        int start;
        FormatType format = FormatType.DefaultFormat;
        EncodingVersion encoding;
        boolean encoding_1_0;
        EncapsEncoder encoder;
        Encaps next;

        private Encaps() {
        }

        void reset() {
            this.encoder = null;
        }

        void setEncoding(EncodingVersion encoding) {
            this.encoding = encoding;
            this.encoding_1_0 = encoding.equals(com.zeroc.Ice.Util.Encoding_1_0);
        }
    }

    private static final class EncapsEncoder11
    extends EncapsEncoder {
        private InstanceData _current = null;
        private int _valueIdIndex = 1;

        EncapsEncoder11(OutputStream stream, Encaps encaps) {
            super(stream, encaps);
        }

        @Override
        void writeValue(Value v) {
            if (v == null) {
                this._stream.writeSize(0);
            } else if (this._current != null && this._encaps.format == FormatType.SlicedFormat) {
                Integer index;
                if (this._current.indirectionTable == null) {
                    this._current.indirectionTable = new ArrayList<Value>();
                    this._current.indirectionMap = new IdentityHashMap();
                }
                if ((index = this._current.indirectionMap.get(v)) == null) {
                    this._current.indirectionTable.add(v);
                    int idx = this._current.indirectionTable.size();
                    this._current.indirectionMap.put(v, idx);
                    this._stream.writeSize(idx);
                } else {
                    this._stream.writeSize(index);
                }
            } else {
                this.writeInstance(v);
            }
        }

        @Override
        void writeException(UserException v) {
            v._write(this._stream);
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData data) {
            this._current = this._current == null ? new InstanceData(null) : (this._current.next == null ? new InstanceData(this._current) : this._current.next);
            this._current.sliceType = sliceType;
            this._current.firstSlice = true;
            if (data != null) {
                this.writeSlicedData(data);
            }
        }

        @Override
        void endInstance() {
            this._current = this._current.previous;
        }

        @Override
        void startSlice(String typeId, int compactId, boolean last) {
            assert ((this._current.indirectionTable == null || this._current.indirectionTable.isEmpty()) && (this._current.indirectionMap == null || this._current.indirectionMap.isEmpty()));
            this._current.sliceFlagsPos = this._stream.pos();
            this._current.sliceFlags = 0;
            if (this._encaps.format == FormatType.SlicedFormat) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x10);
            }
            if (last) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 0x20);
            }
            this._stream.writeByte((byte)0);
            if (this._current.sliceType == SliceType.ValueSlice) {
                if (this._encaps.format == FormatType.SlicedFormat || this._current.firstSlice) {
                    if (compactId >= 0) {
                        this._current.sliceFlags = (byte)(this._current.sliceFlags | 3);
                        this._stream.writeSize(compactId);
                    } else {
                        int index = this.registerTypeId(typeId);
                        if (index < 0) {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 1);
                            this._stream.writeString(typeId);
                        } else {
                            this._current.sliceFlags = (byte)(this._current.sliceFlags | 2);
                            this._stream.writeSize(index);
                        }
                    }
                }
            } else {
                this._stream.writeString(typeId);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                this._stream.writeInt(0);
            }
            this._current.writeSlice = this._stream.pos();
            this._current.firstSlice = false;
        }

        @Override
        void endSlice() {
            if ((this._current.sliceFlags & 4) != 0) {
                this._stream.writeByte((byte)-1);
            }
            if ((this._current.sliceFlags & 0x10) != 0) {
                int sz = this._stream.pos() - this._current.writeSlice + 4;
                this._stream.rewriteInt(sz, this._current.writeSlice - 4);
            }
            if (this._current.indirectionTable != null && !this._current.indirectionTable.isEmpty()) {
                assert (this._encaps.format == FormatType.SlicedFormat);
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 8);
                this._stream.writeSize(this._current.indirectionTable.size());
                for (Value v : this._current.indirectionTable) {
                    this.writeInstance(v);
                }
                this._current.indirectionTable.clear();
                this._current.indirectionMap.clear();
            }
            this._stream.rewriteByte(this._current.sliceFlags, this._current.sliceFlagsPos);
        }

        @Override
        boolean writeOptional(int tag, OptionalFormat format) {
            if (this._current == null) {
                return this._stream.writeOptionalImpl(tag, format);
            }
            if (this._stream.writeOptionalImpl(tag, format)) {
                this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                return true;
            }
            return false;
        }

        private void writeSlicedData(SlicedData slicedData) {
            assert (slicedData != null);
            if (this._encaps.format != FormatType.SlicedFormat) {
                return;
            }
            for (SliceInfo info : slicedData.slices) {
                this.startSlice(info.typeId, info.compactId, info.isLastSlice);
                this._stream.writeBlob(info.bytes);
                if (info.hasOptionalMembers) {
                    this._current.sliceFlags = (byte)(this._current.sliceFlags | 4);
                }
                if (info.instances != null && info.instances.length > 0) {
                    if (this._current.indirectionTable == null) {
                        this._current.indirectionTable = new ArrayList<Value>();
                        this._current.indirectionMap = new IdentityHashMap();
                    }
                    for (Value o : info.instances) {
                        this._current.indirectionTable.add(o);
                    }
                }
                this.endSlice();
            }
        }

        private void writeInstance(Value v) {
            assert (v != null);
            Integer p = (Integer)this._marshaledMap.get(v);
            if (p != null) {
                this._stream.writeSize(p);
                return;
            }
            this._marshaledMap.put(v, ++this._valueIdIndex);
            try {
                v.ice_preMarshal();
            }
            catch (Exception ex) {
                String s = "exception raised by ice_preMarshal:\n" + Ex.toString(ex);
                this._stream.instance().initializationData().logger.warning(s);
            }
            this._stream.writeSize(1);
            v._iceWrite(this._stream);
        }

        private static final class InstanceData {
            SliceType sliceType;
            boolean firstSlice;
            byte sliceFlags;
            int writeSlice;
            int sliceFlagsPos;
            List<Value> indirectionTable;
            IdentityHashMap<Value, Integer> indirectionMap;
            final InstanceData previous;
            InstanceData next;

            InstanceData(InstanceData previous) {
                if (previous != null) {
                    previous.next = this;
                }
                this.previous = previous;
                this.next = null;
            }
        }
    }

    private static final class EncapsEncoder10
    extends EncapsEncoder {
        private SliceType _sliceType = SliceType.NoSlice;
        private int _writeSlice;
        private int _valueIdIndex = 0;
        private IdentityHashMap<Value, Integer> _toBeMarshaledMap = new IdentityHashMap();

        EncapsEncoder10(OutputStream stream, Encaps encaps) {
            super(stream, encaps);
        }

        @Override
        void writeValue(Value v) {
            if (v != null) {
                this._stream.writeInt(-this.registerValue(v));
            } else {
                this._stream.writeInt(0);
            }
        }

        @Override
        void writeException(UserException v) {
            boolean usesClasses = v._usesClasses();
            this._stream.writeBool(usesClasses);
            v._write(this._stream);
            if (usesClasses) {
                this.writePendingValues();
            }
        }

        @Override
        void startInstance(SliceType sliceType, SlicedData sliceData) {
            this._sliceType = sliceType;
        }

        @Override
        void endInstance() {
            if (this._sliceType == SliceType.ValueSlice) {
                this.startSlice(Value.ice_staticId(), -1, true);
                this._stream.writeSize(0);
                this.endSlice();
            }
            this._sliceType = SliceType.NoSlice;
        }

        @Override
        void startSlice(String typeId, int compactId, boolean last) {
            if (this._sliceType == SliceType.ValueSlice) {
                int index = this.registerTypeId(typeId);
                if (index < 0) {
                    this._stream.writeBool(false);
                    this._stream.writeString(typeId);
                } else {
                    this._stream.writeBool(true);
                    this._stream.writeSize(index);
                }
            } else {
                this._stream.writeString(typeId);
            }
            this._stream.writeInt(0);
            this._writeSlice = this._stream.pos();
        }

        @Override
        void endSlice() {
            int sz = this._stream.pos() - this._writeSlice + 4;
            this._stream.rewriteInt(sz, this._writeSlice - 4);
        }

        @Override
        void writePendingValues() {
            while (this._toBeMarshaledMap.size() > 0) {
                this._marshaledMap.putAll(this._toBeMarshaledMap);
                IdentityHashMap<Value, Integer> savedMap = this._toBeMarshaledMap;
                this._toBeMarshaledMap = new IdentityHashMap();
                this._stream.writeSize(savedMap.size());
                for (Map.Entry<Value, Integer> p : savedMap.entrySet()) {
                    this._stream.writeInt(p.getValue());
                    try {
                        p.getKey().ice_preMarshal();
                    }
                    catch (Exception ex) {
                        String s = "exception raised by ice_preMarshal:\n" + Ex.toString(ex);
                        this._stream.instance().initializationData().logger.warning(s);
                    }
                    p.getKey()._iceWrite(this._stream);
                }
            }
            this._stream.writeSize(0);
        }

        private int registerValue(Value v) {
            assert (v != null);
            Integer p = this._toBeMarshaledMap.get(v);
            if (p != null) {
                return p;
            }
            p = (Integer)this._marshaledMap.get(v);
            if (p != null) {
                return p;
            }
            this._toBeMarshaledMap.put(v, ++this._valueIdIndex);
            return this._valueIdIndex;
        }
    }

    private static abstract class EncapsEncoder {
        protected final OutputStream _stream;
        protected final Encaps _encaps;
        protected final IdentityHashMap<Value, Integer> _marshaledMap;
        private TreeMap<String, Integer> _typeIdMap;
        private int _typeIdIndex;

        protected EncapsEncoder(OutputStream stream, Encaps encaps) {
            this._stream = stream;
            this._encaps = encaps;
            this._typeIdIndex = 0;
            this._marshaledMap = new IdentityHashMap();
        }

        abstract void writeValue(Value var1);

        abstract void writeException(UserException var1);

        abstract void startInstance(SliceType var1, SlicedData var2);

        abstract void endInstance();

        abstract void startSlice(String var1, int var2, boolean var3);

        abstract void endSlice();

        boolean writeOptional(int tag, OptionalFormat format) {
            return false;
        }

        void writePendingValues() {
        }

        protected int registerTypeId(String typeId) {
            Integer p;
            if (this._typeIdMap == null) {
                this._typeIdMap = new TreeMap();
            }
            if ((p = this._typeIdMap.get(typeId)) != null) {
                return p;
            }
            this._typeIdMap.put(typeId, ++this._typeIdIndex);
            return -1;
        }
    }

    private static final class SliceType
    extends Enum<SliceType> {
        public static final /* enum */ SliceType NoSlice = new SliceType();
        public static final /* enum */ SliceType ValueSlice = new SliceType();
        public static final /* enum */ SliceType ExceptionSlice = new SliceType();
        private static final /* synthetic */ SliceType[] $VALUES;

        public static SliceType[] values() {
            return (SliceType[])$VALUES.clone();
        }

        static {
            $VALUES = new SliceType[]{NoSlice, ValueSlice, ExceptionSlice};
        }
    }
}

