/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.Relation;
import edu.stanford.nlp.trees.tregex.TokenMgrError;
import edu.stanford.nlp.trees.tregex.TregexParser;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TregexPatternCompiler {
    private Function<String, String> basicCatFunction = new PennTreebankLanguagePack().getBasicCategoryFunction();
    private HeadFinder headFinder = new CollinsHeadFinder();
    public static TregexPatternCompiler defaultCompiler = new TregexPatternCompiler();

    public TregexPatternCompiler() {
    }

    public TregexPatternCompiler(Function<String, String> basicCatFunction) {
        this.basicCatFunction = basicCatFunction;
    }

    public TregexPatternCompiler(HeadFinder headFinder) {
        this.headFinder = headFinder;
    }

    public TregexPatternCompiler(HeadFinder headFinder, Function<String, String> basicCatFunction) {
        this.headFinder = headFinder;
        this.basicCatFunction = basicCatFunction;
    }

    public TregexPattern compile(String tregex) throws ParseException {
        TregexPattern pattern;
        TregexPattern.setBasicCatFunction(this.basicCatFunction);
        Relation.setHeadFinder(this.headFinder);
        try {
            pattern = TregexParser.parse(tregex);
        }
        catch (TokenMgrError tme) {
            throw new ParseException(tme.toString());
        }
        pattern.setPatternString(tregex);
        return pattern;
    }
}

