﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/GuardDutyRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/guardduty/model/CreateProtectedResource.h>
#include <aws/guardduty/model/MalwareProtectionPlanActions.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <utility>
#include <aws/core/utils/UUID.h>

namespace Aws
{
namespace GuardDuty
{
namespace Model
{

  /**
   */
  class CreateMalwareProtectionPlanRequest : public GuardDutyRequest
  {
  public:
    AWS_GUARDDUTY_API CreateMalwareProtectionPlanRequest() = default;

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "CreateMalwareProtectionPlan"; }

    AWS_GUARDDUTY_API Aws::String SerializePayload() const override;


    ///@{
    /**
     * <p>The idempotency token for the create request.</p>
     */
    inline const Aws::String& GetClientToken() const { return m_clientToken; }
    inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
    template<typename ClientTokenT = Aws::String>
    void SetClientToken(ClientTokenT&& value) { m_clientTokenHasBeenSet = true; m_clientToken = std::forward<ClientTokenT>(value); }
    template<typename ClientTokenT = Aws::String>
    CreateMalwareProtectionPlanRequest& WithClientToken(ClientTokenT&& value) { SetClientToken(std::forward<ClientTokenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Amazon Resource Name (ARN) of the IAM role that has the permissions to scan
     * and add tags to the associated protected resource.</p>
     */
    inline const Aws::String& GetRole() const { return m_role; }
    inline bool RoleHasBeenSet() const { return m_roleHasBeenSet; }
    template<typename RoleT = Aws::String>
    void SetRole(RoleT&& value) { m_roleHasBeenSet = true; m_role = std::forward<RoleT>(value); }
    template<typename RoleT = Aws::String>
    CreateMalwareProtectionPlanRequest& WithRole(RoleT&& value) { SetRole(std::forward<RoleT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about the protected resource that is associated with the created
     * Malware Protection plan. Presently, <code>S3Bucket</code> is the only supported
     * protected resource.</p>
     */
    inline const CreateProtectedResource& GetProtectedResource() const { return m_protectedResource; }
    inline bool ProtectedResourceHasBeenSet() const { return m_protectedResourceHasBeenSet; }
    template<typename ProtectedResourceT = CreateProtectedResource>
    void SetProtectedResource(ProtectedResourceT&& value) { m_protectedResourceHasBeenSet = true; m_protectedResource = std::forward<ProtectedResourceT>(value); }
    template<typename ProtectedResourceT = CreateProtectedResource>
    CreateMalwareProtectionPlanRequest& WithProtectedResource(ProtectedResourceT&& value) { SetProtectedResource(std::forward<ProtectedResourceT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Information about whether the tags will be added to the S3 object after
     * scanning.</p>
     */
    inline const MalwareProtectionPlanActions& GetActions() const { return m_actions; }
    inline bool ActionsHasBeenSet() const { return m_actionsHasBeenSet; }
    template<typename ActionsT = MalwareProtectionPlanActions>
    void SetActions(ActionsT&& value) { m_actionsHasBeenSet = true; m_actions = std::forward<ActionsT>(value); }
    template<typename ActionsT = MalwareProtectionPlanActions>
    CreateMalwareProtectionPlanRequest& WithActions(ActionsT&& value) { SetActions(std::forward<ActionsT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Tags added to the Malware Protection plan resource. </p>
     */
    inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
    inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
    template<typename TagsT = Aws::Map<Aws::String, Aws::String>>
    void SetTags(TagsT&& value) { m_tagsHasBeenSet = true; m_tags = std::forward<TagsT>(value); }
    template<typename TagsT = Aws::Map<Aws::String, Aws::String>>
    CreateMalwareProtectionPlanRequest& WithTags(TagsT&& value) { SetTags(std::forward<TagsT>(value)); return *this;}
    template<typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
    CreateMalwareProtectionPlanRequest& AddTags(TagsKeyT&& key, TagsValueT&& value) {
      m_tagsHasBeenSet = true; m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value)); return *this;
    }
    ///@}
  private:

    Aws::String m_clientToken;
    bool m_clientTokenHasBeenSet = false;

    Aws::String m_role;
    bool m_roleHasBeenSet = false;

    CreateProtectedResource m_protectedResource;
    bool m_protectedResourceHasBeenSet = false;

    MalwareProtectionPlanActions m_actions;
    bool m_actionsHasBeenSet = false;

    Aws::Map<Aws::String, Aws::String> m_tags;
    bool m_tagsHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
