/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.session;

import java.net.HttpCookie;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httpsessions.HttpSession;
import org.zaproxy.zap.extension.httpsessions.HttpSessionTokensSet;

public class CookieBasedSessionManagementHelper {
    private static final Logger LOGGER = LogManager.getLogger(CookieBasedSessionManagementHelper.class);

    public static void processMessageToMatchSession(HttpMessage message, HttpSession session) {
        CookieBasedSessionManagementHelper.processMessageToMatchSession(message, message.getRequestHeader().getHttpCookies(), session);
    }

    public static void processMessageToMatchSession(HttpMessage message, List<HttpCookie> requestCookies, HttpSession session) {
        String tokenValue;
        HttpSessionTokensSet tokensSet = session.getTokensNames();
        if (tokensSet == null) {
            tokensSet = new HttpSessionTokensSet();
        }
        LinkedHashSet<String> unsetSiteTokens = new LinkedHashSet<String>(tokensSet.getTokensSet());
        Iterator<HttpCookie> it = requestCookies.iterator();
        while (it.hasNext()) {
            HttpCookie cookie = it.next();
            String cookieName = cookie.getName();
            if (!tokensSet.isSessionToken(cookieName)) continue;
            tokenValue = session.getTokenValue(cookieName);
            LOGGER.debug("Changing value of token '{}' to: {}", (Object)cookieName, (Object)tokenValue);
            if (tokenValue != null) {
                cookie.setValue(tokenValue);
            } else {
                it.remove();
            }
            unsetSiteTokens.remove(cookieName);
        }
        for (String token : unsetSiteTokens) {
            tokenValue = session.getTokenValue(token);
            if (tokenValue == null) continue;
            LOGGER.debug("Adding token '{}' with value: {}", (Object)token, (Object)tokenValue);
            HttpCookie cookie = new HttpCookie(token, tokenValue);
            requestCookies.add(cookie);
        }
        message.setHttpSession(session);
        message.getRequestHeader().setCookies(requestCookies);
    }

    public static HttpSession getMatchingHttpSession(Collection<HttpSession> sessions, List<HttpCookie> cookies, HttpSessionTokensSet siteTokens) {
        if (sessions.isEmpty()) {
            return null;
        }
        LinkedList<HttpSession> matchingSessions = new LinkedList<HttpSession>(sessions);
        for (String token : siteTokens.getTokensSet()) {
            HttpCookie matchingCookie = null;
            for (HttpCookie cookie : cookies) {
                if (!cookie.getName().equals(token)) continue;
                matchingCookie = cookie;
                break;
            }
            Iterator it = matchingSessions.iterator();
            while (it.hasNext()) {
                if (((HttpSession)it.next()).matchesToken(token, matchingCookie)) continue;
                it.remove();
            }
        }
        if (matchingSessions.size() >= 1) {
            if (matchingSessions.size() > 1) {
                LOGGER.warn("Multiple sessions matching the cookies from response. Using first one.");
            }
            return (HttpSession)matchingSessions.get(0);
        }
        return null;
    }
}

