import * as _ from '@volar/language-server/node';
import * as cp from 'child_process';
import { TextDocument } from 'vscode-languageserver-textdocument';
import { URI } from 'vscode-uri';
export type LanguageServerHandle = ReturnType<typeof startLanguageServer>;
export declare function startLanguageServer(serverModule: string, cwd?: string | URL): {
    process: cp.ChildProcess;
    connection: _.ProtocolConnection;
    initialize(rootUri: string | _.WorkspaceFolder[], initializationOptions: _._InitializeParams["initializationOptions"], capabilities?: _.ClientCapabilities, locale?: string): Promise<_.InitializeResult<any>>;
    shutdown(): Promise<void>;
    openTextDocument(fileName: string, languageId: string): Promise<TextDocument>;
    openUntitledDocument(languageId: string, content: string): Promise<TextDocument>;
    openInMemoryDocument(uri: string, languageId: string, content: string): Promise<TextDocument>;
    closeTextDocument(uri: string): Promise<void>;
    updateTextDocument(uri: string, edits: _.TextEdit[]): Promise<TextDocument>;
    updateConfiguration(newSettings: any): Promise<void>;
    didChangeWatchedFiles(changes: _.FileEvent[]): Promise<void>;
    sendCompletionRequest(uri: string, position: _.Position): Promise<_.CompletionList | null>;
    sendCompletionResolveRequest(item: _.CompletionItem): Promise<_.CompletionItem>;
    sendDocumentDiagnosticRequest(uri: string): Promise<_.DocumentDiagnosticReport>;
    sendHoverRequest(uri: string, position: _.Position): Promise<_.Hover | null>;
    sendDocumentFormattingRequest(uri: string, options: _.FormattingOptions): Promise<_.TextEdit[] | null>;
    sendDocumentRangeFormattingRequestRequest(uri: string, range: _.Range, options: _.FormattingOptions): Promise<_.TextEdit[] | null>;
    sendRenameRequest(uri: string, position: _.Position, newName: string): Promise<_.WorkspaceEdit | null>;
    sendPrepareRenameRequest(uri: string, position: _.Position): Promise<_.PrepareRenameResult | null>;
    sendFoldingRangesRequest(uri: string): Promise<_.FoldingRange[] | null>;
    sendDocumentSymbolRequest(uri: string): Promise<_.DocumentSymbol[] | _.SymbolInformation[] | null>;
    sendDocumentColorRequest(uri: string): Promise<_.ColorInformation[]>;
    sendDefinitionRequest(uri: string, position: _.Position): Promise<_.Definition | _.LocationLink[] | null>;
    sendTypeDefinitionRequest(uri: string, position: _.Position): Promise<_.Definition | _.LocationLink[] | null>;
    sendReferencesRequest(uri: string, position: _.Position, context: _.ReferenceContext): Promise<_.Location[] | null>;
    sendSignatureHelpRequest(uri: string, position: _.Position): Promise<_.SignatureHelp | null>;
    sendSelectionRangesRequest(uri: string, positions: _.Position[]): Promise<_.SelectionRange[] | null>;
    sendCodeActionsRequest(uri: string, range: _.Range, context: _.CodeActionContext): Promise<(_.CodeAction | _.Command)[] | null>;
    sendCodeActionResolveRequest(codeAction: _.CodeAction): Promise<_.CodeAction>;
    sendExecuteCommandRequest(command: string, args?: any[]): Promise<any>;
    sendSemanticTokensRequest(uri: string): Promise<_.SemanticTokens | null>;
    sendSemanticTokensRangeRequest(uri: string, range: _.Range): Promise<_.SemanticTokens | null>;
    sendColorPresentationRequest(uri: string, color: _.Color, range: _.Range): Promise<_.ColorPresentation[]>;
    sendDocumentLinkRequest(uri: string): Promise<_.DocumentLink[] | null>;
    sendDocumentLinkResolveRequest(link: _.DocumentLink): Promise<_.DocumentLink>;
    sendInlayHintRequest(uri: string, range: _.Range): Promise<_.InlayHint[] | null>;
    sendInlayHintResolveRequest(hint: _.InlayHint): Promise<_.InlayHint>;
};
export declare function printSnapshots(sourceScript: _.SourceScript<URI>): Generator<string, void, unknown>;
export declare function printSnapshot(sourceScript: {
    snapshot: _.SourceScript<URI>['snapshot'];
}, file: _.VirtualCode): Generator<string, void, unknown>;
