/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.apache.coyote.ActionCode;
import org.apache.coyote.BadRequestException;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.http11.InputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.parser.HttpHeaderParser;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.res.StringManager;

public class ChunkedInputFilter
implements InputFilter,
ApplicationBufferHandler,
HttpHeaderParser.HeaderDataSource {
    private static final StringManager sm = StringManager.getManager(ChunkedInputFilter.class);
    protected static final String ENCODING_NAME = "chunked";
    protected static final ByteChunk ENCODING = new ByteChunk();
    protected InputBuffer buffer;
    protected int remaining = 0;
    protected ByteBuffer readChunk;
    protected final ByteBuffer trailingHeaders;
    private final Request request;
    private final long maxExtensionSize;
    private final int maxSwallowSize;
    private final Set<String> allowedTrailerHeaders;
    private volatile ParseState parseState = ParseState.CHUNK_HEADER;
    private volatile boolean crFound = false;
    private volatile int chunkSizeDigitsRead = 0;
    private volatile boolean parsingExtension = false;
    private volatile long extensionSize;
    private final HttpHeaderParser httpHeaderParser;

    public ChunkedInputFilter(Request request, int n, Set<String> set, int n2, int n3) {
        this.request = request;
        this.trailingHeaders = ByteBuffer.allocate(n);
        this.trailingHeaders.limit(0);
        this.allowedTrailerHeaders = set;
        this.maxExtensionSize = n2;
        this.maxSwallowSize = n3;
        this.httpHeaderParser = new HttpHeaderParser(this, request.getMimeTrailerFields(), false);
    }

    @Override
    public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        block7: while (true) {
            switch (this.parseState) {
                case CHUNK_HEADER: {
                    if (this.parseChunkHeader()) continue block7;
                    return 0;
                }
                case CHUNK_BODY: {
                    return this.parseChunkBody(applicationBufferHandler);
                }
                case CHUNK_BODY_CRLF: {
                    if (!this.parseCRLF()) {
                        return 0;
                    }
                    this.parseState = ParseState.CHUNK_HEADER;
                    continue block7;
                }
                case TRAILER_FIELDS: {
                    if (!this.parseTrailerFields()) {
                        return 0;
                    }
                    return -1;
                }
                case FINISHED: {
                    return -1;
                }
            }
            break;
        }
        throw new IOException(sm.getString("chunkedInputFilter.error"));
    }

    @Override
    public void setRequest(Request request) {
    }

    @Override
    public long end() throws IOException {
        long l = 0L;
        int n = 0;
        while ((n = this.doRead(this)) >= 0) {
            if (this.maxSwallowSize <= -1 || (l += (long)n) <= (long)this.maxSwallowSize) continue;
            this.throwBadRequestException(sm.getString("inputFilter.maxSwallow"));
        }
        if (this.trailingHeaders.remaining() > 0) {
            this.readChunk.position(this.readChunk.position() - this.trailingHeaders.remaining());
        }
        return this.readChunk.remaining();
    }

    @Override
    public int available() {
        int n = 0;
        if (this.readChunk != null) {
            n = this.readChunk.remaining();
        }
        if (n > 2 && (this.parseState == ParseState.CHUNK_BODY_CRLF || this.parseState == ParseState.CHUNK_HEADER)) {
            if (this.parseState == ParseState.CHUNK_BODY_CRLF && this.skipCRLF()) {
                this.parseState = ParseState.CHUNK_HEADER;
            }
            if (this.parseState == ParseState.CHUNK_HEADER) {
                this.skipChunkHeader();
            }
            n = this.readChunk.remaining();
        }
        if (n == 1 && this.parseState == ParseState.CHUNK_BODY_CRLF) {
            this.skipCRLF();
            n = this.readChunk.remaining();
        } else if (n == 2 && !this.crFound && this.parseState == ParseState.CHUNK_BODY_CRLF) {
            if (this.skipCRLF()) {
                this.parseState = ParseState.CHUNK_HEADER;
            }
            n = this.readChunk.remaining();
        }
        if (n == 0) {
            return this.buffer.available();
        }
        return n;
    }

    @Override
    public void setBuffer(InputBuffer inputBuffer) {
        this.buffer = inputBuffer;
    }

    @Override
    public void recycle() {
        this.remaining = 0;
        if (this.readChunk != null) {
            this.readChunk.position(0).limit(0);
        }
        this.trailingHeaders.clear();
        this.trailingHeaders.limit(0);
        this.parseState = ParseState.CHUNK_HEADER;
        this.crFound = false;
        this.chunkSizeDigitsRead = 0;
        this.parsingExtension = false;
        this.extensionSize = 0L;
        this.httpHeaderParser.recycle();
    }

    @Override
    public ByteChunk getEncodingName() {
        return ENCODING;
    }

    @Override
    public boolean isFinished() {
        return this.parseState == ParseState.FINISHED;
    }

    protected int readBytes() throws IOException {
        return this.buffer.doRead(this);
    }

    @Override
    public boolean fillHeaderBuffer() throws IOException {
        if (this.fill()) {
            if (this.trailingHeaders.position() == this.trailingHeaders.capacity()) {
                throw new BadRequestException(sm.getString("chunkedInputFilter.maxTrailer"));
            }
            int n = this.trailingHeaders.position();
            this.trailingHeaders.position(this.trailingHeaders.limit());
            this.trailingHeaders.limit(this.trailingHeaders.capacity());
            if (this.readChunk.remaining() > this.trailingHeaders.remaining()) {
                int n2 = this.readChunk.limit();
                this.readChunk.limit(this.readChunk.position() + this.trailingHeaders.remaining());
                this.trailingHeaders.put(this.readChunk);
                this.readChunk.limit(n2);
            } else {
                this.trailingHeaders.put(this.readChunk);
            }
            this.trailingHeaders.limit(this.trailingHeaders.position());
            this.trailingHeaders.position(n);
            return true;
        }
        return false;
    }

    private boolean fill() throws IOException {
        if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
            int n = this.readBytes();
            if (n < 0) {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
            } else if (n == 0) {
                return false;
            }
        }
        return true;
    }

    private boolean parseChunkHeader() throws IOException {
        boolean bl = false;
        while (!bl) {
            if (!this.fill()) {
                return false;
            }
            byte by = this.readChunk.get(this.readChunk.position());
            if (by == 13 || by == 10) {
                this.parsingExtension = false;
                if (!this.parseCRLF()) {
                    return false;
                }
                bl = true;
            } else if (by == 59 && !this.parsingExtension) {
                this.parsingExtension = true;
                ++this.extensionSize;
            } else if (!this.parsingExtension) {
                int n = HexUtils.getDec((int)by);
                if (n != -1 && this.chunkSizeDigitsRead < 8) {
                    ++this.chunkSizeDigitsRead;
                    this.remaining = this.remaining << 4 | n;
                } else {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
                }
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.maxExtension"));
                }
            }
            if (bl) continue;
            this.readChunk.position(this.readChunk.position() + 1);
        }
        if (this.chunkSizeDigitsRead == 0 || this.remaining < 0) {
            this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidHeader"));
        } else {
            this.chunkSizeDigitsRead = 0;
        }
        this.parseState = this.remaining == 0 ? ParseState.TRAILER_FIELDS : ParseState.CHUNK_BODY;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean skipChunkHeader() {
        boolean bl = false;
        while (!bl) {
            if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
                return false;
            }
            byte by = this.readChunk.get(this.readChunk.position());
            if (by == 13 || by == 10) {
                this.parsingExtension = false;
                if (!this.skipCRLF()) {
                    return false;
                }
                bl = true;
            } else if (by == 59 && !this.parsingExtension) {
                this.parsingExtension = true;
                ++this.extensionSize;
            } else if (!this.parsingExtension) {
                int n = HexUtils.getDec((int)by);
                if (n == -1 || this.chunkSizeDigitsRead >= 8) return false;
                ++this.chunkSizeDigitsRead;
                this.remaining = this.remaining << 4 | n;
            } else {
                ++this.extensionSize;
                if (this.maxExtensionSize > -1L && this.extensionSize > this.maxExtensionSize) {
                    return false;
                }
            }
            if (bl) continue;
            this.readChunk.position(this.readChunk.position() + 1);
        }
        if (this.chunkSizeDigitsRead == 0 || this.remaining < 0) {
            return false;
        }
        this.chunkSizeDigitsRead = 0;
        this.parseState = this.remaining == 0 ? ParseState.TRAILER_FIELDS : ParseState.CHUNK_BODY;
        return true;
    }

    private int parseChunkBody(ApplicationBufferHandler applicationBufferHandler) throws IOException {
        int n = 0;
        if (!this.fill()) {
            return 0;
        }
        if (this.remaining > this.readChunk.remaining()) {
            n = this.readChunk.remaining();
            this.remaining -= n;
            if (this.readChunk != applicationBufferHandler.getByteBuffer()) {
                applicationBufferHandler.setByteBuffer(this.readChunk.duplicate());
            }
            this.readChunk.position(this.readChunk.limit());
        } else {
            n = this.remaining;
            if (this.readChunk != applicationBufferHandler.getByteBuffer()) {
                applicationBufferHandler.setByteBuffer(this.readChunk.duplicate());
                applicationBufferHandler.getByteBuffer().limit(this.readChunk.position() + this.remaining);
            }
            this.readChunk.position(this.readChunk.position() + this.remaining);
            this.remaining = 0;
            this.parseState = ParseState.CHUNK_BODY_CRLF;
        }
        return n;
    }

    private boolean parseCRLF() throws IOException {
        boolean bl = false;
        while (!bl) {
            if (!this.fill()) {
                return false;
            }
            byte by = this.readChunk.get(this.readChunk.position());
            if (by == 13) {
                if (this.crFound) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfCRCR"));
                }
                this.crFound = true;
            } else if (by == 10) {
                if (!this.crFound) {
                    this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlfNoCR"));
                }
                bl = true;
            } else {
                this.throwBadRequestException(sm.getString("chunkedInputFilter.invalidCrlf"));
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
        this.crFound = false;
        return true;
    }

    private boolean skipCRLF() {
        boolean bl = false;
        while (!bl) {
            if (this.readChunk == null || this.readChunk.position() >= this.readChunk.limit()) {
                return false;
            }
            byte by = this.readChunk.get(this.readChunk.position());
            if (by == 13) {
                if (this.crFound) {
                    return false;
                }
                this.crFound = true;
            } else if (by == 10) {
                if (!this.crFound) {
                    return false;
                }
                bl = true;
            } else {
                return false;
            }
            this.readChunk.position(this.readChunk.position() + 1);
        }
        this.crFound = false;
        return true;
    }

    private boolean parseTrailerFields() throws IOException {
        HttpHeaderParser.HeaderParseStatus headerParseStatus = HttpHeaderParser.HeaderParseStatus.HAVE_MORE_HEADERS;
        do {
            try {
                headerParseStatus = this.httpHeaderParser.parseHeader();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.parseState = ParseState.ERROR;
                throw new BadRequestException(illegalArgumentException);
            }
        } while (headerParseStatus == HttpHeaderParser.HeaderParseStatus.HAVE_MORE_HEADERS);
        if (headerParseStatus == HttpHeaderParser.HeaderParseStatus.DONE) {
            this.parseState = ParseState.FINISHED;
            this.request.getMimeTrailerFields().filter(this.allowedTrailerHeaders);
            if (this.request.getReadListener() != null) {
                this.request.action(ActionCode.DISPATCH_READ, null);
                this.request.action(ActionCode.DISPATCH_EXECUTE, null);
            }
            return true;
        }
        return false;
    }

    private void throwBadRequestException(String string) throws IOException {
        this.parseState = ParseState.ERROR;
        throw new BadRequestException(string);
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.readChunk = byteBuffer;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        return this.readChunk;
    }

    @Override
    public ByteBuffer getHeaderByteBuffer() {
        return this.trailingHeaders;
    }

    @Override
    public void expand(int n) {
    }

    static {
        ENCODING.setBytes(ENCODING_NAME.getBytes(StandardCharsets.ISO_8859_1), 0, ENCODING_NAME.length());
    }

    private static enum ParseState {
        CHUNK_HEADER,
        CHUNK_BODY,
        CHUNK_BODY_CRLF,
        TRAILER_FIELDS,
        FINISHED,
        ERROR;

    }
}

