/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.util;

public class FastRemovalDequeue<T> {
    private final int maxSize;
    protected Entry first;
    protected Entry last;
    private int size;

    public FastRemovalDequeue(int n) {
        if (n <= 1) {
            n = 2;
        }
        this.maxSize = n;
        this.first = null;
        this.last = null;
        this.size = 0;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized Entry push(T t) {
        Entry entry = new Entry(t);
        if (this.size >= this.maxSize) {
            entry.setReplaced(this.pop());
        }
        if (this.first == null) {
            this.first = this.last = entry;
        } else {
            this.first.setPrevious(entry);
            entry.setNext(this.first);
            this.first = entry;
        }
        ++this.size;
        return entry;
    }

    public synchronized Entry unpop(T t) {
        Entry entry = new Entry(t);
        if (this.size >= this.maxSize) {
            entry.setReplaced(this.unpush());
        }
        if (this.first == null) {
            this.first = this.last = entry;
        } else {
            this.last.setNext(entry);
            entry.setPrevious(this.last);
            this.last = entry;
        }
        ++this.size;
        return entry;
    }

    public synchronized T unpush() {
        T t = null;
        if (this.first != null) {
            Entry entry = this.first;
            this.first = this.first.getNext();
            t = entry.getContent();
            if (this.first == null) {
                this.last = null;
            } else {
                this.first.setPrevious(null);
            }
            --this.size;
            entry.invalidate();
        }
        return t;
    }

    public synchronized T pop() {
        T t = null;
        if (this.last != null) {
            Entry entry = this.last;
            this.last = this.last.getPrevious();
            t = entry.getContent();
            if (this.last == null) {
                this.first = null;
            } else {
                this.last.setNext(null);
            }
            --this.size;
            entry.invalidate();
        }
        return t;
    }

    public synchronized void remove(Entry entry) {
        if (entry == null || !entry.getValid()) {
            return;
        }
        Entry entry2 = entry.getNext();
        Entry entry3 = entry.getPrevious();
        if (entry2 != null) {
            entry2.setPrevious(entry3);
        } else {
            this.last = entry3;
        }
        if (entry3 != null) {
            entry3.setNext(entry2);
        } else {
            this.first = entry2;
        }
        --this.size;
        entry.invalidate();
    }

    public synchronized void moveFirst(Entry entry) {
        if (entry.getValid() && entry.getPrevious() != null) {
            Entry entry2 = entry.getPrevious();
            Entry entry3 = entry.getNext();
            entry2.setNext(entry3);
            if (entry3 != null) {
                entry3.setPrevious(entry2);
            } else {
                this.last = entry2;
            }
            this.first.setPrevious(entry);
            entry.setNext(this.first);
            entry.setPrevious(null);
            this.first = entry;
        }
    }

    public synchronized void moveLast(Entry entry) {
        if (entry.getValid() && entry.getNext() != null) {
            Entry entry2 = entry.getNext();
            Entry entry3 = entry.getPrevious();
            entry2.setPrevious(entry3);
            if (entry3 != null) {
                entry3.setNext(entry2);
            } else {
                this.first = entry2;
            }
            this.last.setNext(entry);
            entry.setPrevious(this.last);
            entry.setNext(null);
            this.last = entry;
        }
    }

    public class Entry {
        private boolean valid = true;
        private final T content;
        private T replaced = null;
        private Entry next = null;
        private Entry previous = null;

        private Entry(T t) {
            this.content = t;
        }

        private boolean getValid() {
            return this.valid;
        }

        private void invalidate() {
            this.valid = false;
            this.previous = null;
            this.next = null;
        }

        public final T getContent() {
            return this.content;
        }

        public final T getReplaced() {
            return this.replaced;
        }

        private void setReplaced(T t) {
            this.replaced = t;
        }

        public final void clearReplaced() {
            this.replaced = null;
        }

        private Entry getNext() {
            return this.next;
        }

        private void setNext(Entry entry) {
            this.next = entry;
        }

        private Entry getPrevious() {
            return this.previous;
        }

        private void setPrevious(Entry entry) {
            this.previous = entry;
        }

        public String toString() {
            return "Entry-" + this.content.toString();
        }
    }
}

