/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.tomcat.jni.LibraryNotFoundError;

public final class Library {
    private static final String[] NAMES = new String[]{"tcnative-1", "libtcnative-1", "tcnative-2", "libtcnative-2"};
    private static Library _instance = null;
    private static final AtomicLong generation = new AtomicLong(0L);
    private static final ReadWriteLock cleanUpLock = new ReentrantReadWriteLock();
    public static int TCN_MAJOR_VERSION = 0;
    public static int TCN_MINOR_VERSION = 0;
    public static int TCN_PATCH_VERSION = 0;
    public static int TCN_IS_DEV_VERSION = 0;
    public static int APR_MAJOR_VERSION = 0;
    public static int APR_MINOR_VERSION = 0;
    public static int APR_PATCH_VERSION = 0;
    public static int APR_IS_DEV_VERSION = 0;
    @Deprecated
    public static boolean APR_HAVE_IPV6 = false;
    @Deprecated
    public static boolean APR_HAS_SHARED_MEMORY = false;
    @Deprecated
    public static boolean APR_HAS_THREADS = false;
    @Deprecated
    public static boolean APR_HAS_SENDFILE = false;
    @Deprecated
    public static boolean APR_HAS_MMAP = false;
    @Deprecated
    public static boolean APR_HAS_FORK = false;
    @Deprecated
    public static boolean APR_HAS_RANDOM = false;
    @Deprecated
    public static boolean APR_HAS_OTHER_CHILD = false;
    @Deprecated
    public static boolean APR_HAS_DSO = false;
    @Deprecated
    public static boolean APR_HAS_SO_ACCEPTFILTER = false;
    @Deprecated
    public static boolean APR_HAS_UNICODE_FS = false;
    @Deprecated
    public static boolean APR_HAS_PROC_INVOKED = false;
    @Deprecated
    public static boolean APR_HAS_USER = false;
    @Deprecated
    public static boolean APR_HAS_LARGE_FILES = false;
    @Deprecated
    public static boolean APR_HAS_XTHREAD_FILES = false;
    @Deprecated
    public static boolean APR_HAS_OS_UUID = false;
    @Deprecated
    public static boolean APR_IS_BIGENDIAN = false;
    @Deprecated
    public static boolean APR_FILES_AS_SOCKETS = false;
    @Deprecated
    public static boolean APR_CHARSET_EBCDIC = false;
    @Deprecated
    public static boolean APR_TCP_NODELAY_INHERITED = false;
    @Deprecated
    public static boolean APR_O_NONBLOCK_INHERITED = false;
    @Deprecated
    public static int APR_SIZEOF_VOIDP;
    @Deprecated
    public static int APR_PATH_MAX;
    @Deprecated
    public static int APRMAXHOSTLEN;
    @Deprecated
    public static int APR_MAX_IOVEC_SIZE;
    @Deprecated
    public static int APR_MAX_SECS_TO_LINGER;
    @Deprecated
    public static int APR_MMAP_THRESHOLD;
    @Deprecated
    public static int APR_MMAP_LIMIT;

    private Library() throws Exception {
        boolean bl = false;
        String string = System.getProperty("java.library.path");
        String[] stringArray = string.split(File.pathSeparator);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < NAMES.length; ++i) {
            try {
                System.loadLibrary(NAMES[i]);
                bl = true;
            }
            catch (ThreadDeath | VirtualMachineError error) {
                throw error;
            }
            catch (Throwable throwable) {
                String string2 = System.mapLibraryName(NAMES[i]);
                for (int j = 0; j < stringArray.length; ++j) {
                    File object = new File(stringArray[j], string2);
                    if (!object.exists()) continue;
                    throw throwable;
                }
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(throwable.getMessage());
            }
            if (bl) break;
        }
        if (!bl) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (String string2 : NAMES) {
                stringBuilder2.append(string2);
                stringBuilder2.append(", ");
            }
            throw new LibraryNotFoundError(stringBuilder2.substring(0, stringBuilder2.length() - 2), stringBuilder.toString());
        }
    }

    private Library(String string) {
        System.loadLibrary(string);
    }

    private static native boolean initialize();

    public static void threadSafeTerminate() {
        cleanUpLock.writeLock().lock();
        try {
            Library.terminate();
        }
        finally {
            generation.incrementAndGet();
            cleanUpLock.writeLock().unlock();
        }
    }

    public static native void terminate();

    private static native boolean has(int var0);

    private static native int version(int var0);

    private static native int size(int var0);

    public static native String versionString();

    public static native String aprVersionString();

    @Deprecated
    public static native long globalPool();

    public static synchronized boolean initialize(String string) throws Exception {
        if (_instance == null) {
            _instance = string == null ? new Library() : new Library(string);
            TCN_MAJOR_VERSION = Library.version(1);
            TCN_MINOR_VERSION = Library.version(2);
            TCN_PATCH_VERSION = Library.version(3);
            TCN_IS_DEV_VERSION = Library.version(4);
            APR_MAJOR_VERSION = Library.version(17);
            APR_MINOR_VERSION = Library.version(18);
            APR_PATCH_VERSION = Library.version(19);
            APR_IS_DEV_VERSION = Library.version(20);
            APR_SIZEOF_VOIDP = Library.size(1);
            APR_PATH_MAX = Library.size(2);
            APRMAXHOSTLEN = Library.size(3);
            APR_MAX_IOVEC_SIZE = Library.size(4);
            APR_MAX_SECS_TO_LINGER = Library.size(5);
            APR_MMAP_THRESHOLD = Library.size(6);
            APR_MMAP_LIMIT = Library.size(7);
            APR_HAVE_IPV6 = Library.has(0);
            APR_HAS_SHARED_MEMORY = Library.has(1);
            APR_HAS_THREADS = Library.has(2);
            APR_HAS_SENDFILE = Library.has(3);
            APR_HAS_MMAP = Library.has(4);
            APR_HAS_FORK = Library.has(5);
            APR_HAS_RANDOM = Library.has(6);
            APR_HAS_OTHER_CHILD = Library.has(7);
            APR_HAS_DSO = Library.has(8);
            APR_HAS_SO_ACCEPTFILTER = Library.has(9);
            APR_HAS_UNICODE_FS = Library.has(10);
            APR_HAS_PROC_INVOKED = Library.has(11);
            APR_HAS_USER = Library.has(12);
            APR_HAS_LARGE_FILES = Library.has(13);
            APR_HAS_XTHREAD_FILES = Library.has(14);
            APR_HAS_OS_UUID = Library.has(15);
            APR_IS_BIGENDIAN = Library.has(16);
            APR_FILES_AS_SOCKETS = Library.has(17);
            APR_CHARSET_EBCDIC = Library.has(18);
            APR_TCP_NODELAY_INHERITED = Library.has(19);
            APR_O_NONBLOCK_INHERITED = Library.has(20);
            if (APR_MAJOR_VERSION < 1) {
                throw new UnsatisfiedLinkError("Unsupported APR Version (" + Library.aprVersionString() + ")");
            }
            if (!APR_HAS_THREADS) {
                throw new UnsatisfiedLinkError("Missing threading support from APR");
            }
        }
        return Library.initialize();
    }

    public static boolean tryCleanUpLock(long l) {
        try {
            boolean bl = cleanUpLock.readLock().tryLock(0L, TimeUnit.SECONDS);
            if (bl && generation.get() == l) {
                return true;
            }
            cleanUpLock.readLock().unlock();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public static long getGeneration() {
        return generation.get();
    }

    public static void returnCleanUpLock() {
        cleanUpLock.readLock().unlock();
    }

    @Deprecated
    public static void load(String string) {
        System.load(string);
    }

    @Deprecated
    public static void loadLibrary(String string) {
        System.loadLibrary(string);
    }
}

