/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.catalina.realm.JAASRealm;
import org.apache.tomcat.util.res.StringManager;

public class JAASCallbackHandler
implements CallbackHandler {
    protected static final StringManager sm = StringManager.getManager(JAASCallbackHandler.class);
    protected final String password;
    protected final JAASRealm realm;
    protected final String username;
    protected final String nonce;
    protected final String nc;
    protected final String cnonce;
    protected final String qop;
    protected final String realmName;
    protected final String digestA2;
    protected final String authMethod;

    public JAASCallbackHandler(JAASRealm jAASRealm, String string, String string2) {
        this(jAASRealm, string, string2, null, null, null, null, null, null, null, null);
    }

    public JAASCallbackHandler(JAASRealm jAASRealm, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        this.realm = jAASRealm;
        this.username = string;
        this.password = string2 != null && jAASRealm.hasMessageDigest(string9) ? jAASRealm.getCredentialHandler().mutate(string2) : string2;
        this.nonce = string3;
        this.nc = string4;
        this.cnonce = string5;
        this.qop = string6;
        this.realmName = string7;
        this.digestA2 = string8;
        this.authMethod = string10;
    }

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbackArray) {
            Object object;
            if (callback instanceof NameCallback) {
                if (this.realm.getContainer().getLogger().isTraceEnabled()) {
                    this.realm.getContainer().getLogger().trace((Object)sm.getString("jaasCallback.username", new Object[]{this.username}));
                }
                ((NameCallback)callback).setName(this.username);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                object = this.password != null ? this.password.toCharArray() : (Object)new char[]{};
                ((PasswordCallback)callback).setPassword((char[])object);
                continue;
            }
            if (callback instanceof TextInputCallback) {
                object = (TextInputCallback)callback;
                if (object.getPrompt().equals("nonce")) {
                    object.setText(this.nonce);
                    continue;
                }
                if (object.getPrompt().equals("nc")) {
                    object.setText(this.nc);
                    continue;
                }
                if (object.getPrompt().equals("cnonce")) {
                    object.setText(this.cnonce);
                    continue;
                }
                if (object.getPrompt().equals("qop")) {
                    object.setText(this.qop);
                    continue;
                }
                if (object.getPrompt().equals("realmName")) {
                    object.setText(this.realmName);
                    continue;
                }
                if (object.getPrompt().equals("digestA2")) {
                    object.setText(this.digestA2);
                    continue;
                }
                if (object.getPrompt().equals("authMethod")) {
                    object.setText(this.authMethod);
                    continue;
                }
                if (object.getPrompt().equals("catalinaBase")) {
                    object.setText(this.realm.getContainer().getCatalinaBase().getAbsolutePath());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            throw new UnsupportedCallbackException(callback);
        }
    }
}

