/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.HexUtils;

public class ChunkedOutputFilter
implements OutputFilter {
    private static final byte[] END_CHUNK_BYTES = new byte[]{48, 13, 10, 13, 10};
    protected HttpOutputBuffer buffer;
    protected final ByteBuffer chunkHeader = ByteBuffer.allocate(10);
    protected final ByteBuffer endChunk = ByteBuffer.wrap(END_CHUNK_BYTES);

    public ChunkedOutputFilter() {
        this.chunkHeader.put(8, (byte)13);
        this.chunkHeader.put(9, (byte)10);
    }

    @Override
    @Deprecated
    public int doWrite(ByteChunk byteChunk) throws IOException {
        int n = byteChunk.getLength();
        if (n <= 0) {
            return 0;
        }
        int n2 = this.calculateChunkHeader(n);
        this.chunkHeader.position(n2).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(byteChunk);
        this.chunkHeader.position(8).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        return n;
    }

    @Override
    public int doWrite(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return 0;
        }
        int n2 = this.calculateChunkHeader(n);
        this.chunkHeader.position(n2).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        this.buffer.doWrite(byteBuffer);
        this.chunkHeader.position(8).limit(10);
        this.buffer.doWrite(this.chunkHeader);
        return n;
    }

    private int calculateChunkHeader(int n) {
        int n2 = 8;
        for (int i = n; i > 0; i /= 16) {
            int n3 = i % 16;
            this.chunkHeader.put(--n2, HexUtils.getHex((int)n3));
        }
        return n2;
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(HttpOutputBuffer httpOutputBuffer) {
        this.buffer = httpOutputBuffer;
    }

    @Override
    public void flush() throws IOException {
        this.buffer.flush();
    }

    @Override
    public void end() throws IOException {
        this.buffer.doWrite(this.endChunk);
        this.endChunk.position(0).limit(this.endChunk.capacity());
        this.buffer.end();
    }

    @Override
    public void recycle() {
    }
}

