// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const eachNodeUpToRoot = require('./eachNodeUpToRoot.cjs');

/** @import { Node } from 'postcss' */

/**
 * Finds the node satisfying the specified predicate up to the root node.
 *
 * @param {Node} node
 * @param {(node: Node) => boolean} predicate
 * @returns {Node | undefined}
 */
function findNodeUpToRoot(node, predicate) {
	/** @type {Node | undefined} */
	let found;

	eachNodeUpToRoot.default(node, (current) => {
		if (predicate(current)) {
			found = current;

			return eachNodeUpToRoot.STOP;
		}
	});

	return found;
}

module.exports = findNodeUpToRoot;
