/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.formatter;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import org.jf.dexlib2.MethodHandleType;
import org.jf.dexlib2.iface.AnnotationElement;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodHandleReference;
import org.jf.dexlib2.iface.reference.MethodProtoReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.BooleanEncodedValue;
import org.jf.dexlib2.iface.value.ByteEncodedValue;
import org.jf.dexlib2.iface.value.CharEncodedValue;
import org.jf.dexlib2.iface.value.DoubleEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.iface.value.EnumEncodedValue;
import org.jf.dexlib2.iface.value.FieldEncodedValue;
import org.jf.dexlib2.iface.value.FloatEncodedValue;
import org.jf.dexlib2.iface.value.IntEncodedValue;
import org.jf.dexlib2.iface.value.LongEncodedValue;
import org.jf.dexlib2.iface.value.MethodEncodedValue;
import org.jf.dexlib2.iface.value.MethodHandleEncodedValue;
import org.jf.dexlib2.iface.value.MethodTypeEncodedValue;
import org.jf.dexlib2.iface.value.ShortEncodedValue;
import org.jf.dexlib2.iface.value.StringEncodedValue;
import org.jf.dexlib2.iface.value.TypeEncodedValue;

public class DexFormattedWriter
extends Writer {
    protected final Writer writer;

    public DexFormattedWriter(Writer writer) {
        this.writer = writer;
    }

    public void writeMethodDescriptor(MethodReference methodReference) throws IOException {
        this.writeType(methodReference.getDefiningClass());
        this.writer.write("->");
        this.writeSimpleName(methodReference.getName());
        this.writer.write(40);
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            this.writeType(charSequence);
        }
        this.writer.write(41);
        this.writeType(methodReference.getReturnType());
    }

    public void writeShortMethodDescriptor(MethodReference methodReference) throws IOException {
        this.writeSimpleName(methodReference.getName());
        this.writer.write(40);
        for (CharSequence charSequence : methodReference.getParameterTypes()) {
            this.writeType(charSequence);
        }
        this.writer.write(41);
        this.writeType(methodReference.getReturnType());
    }

    public void writeMethodProtoDescriptor(MethodProtoReference protoReference) throws IOException {
        this.writer.write(40);
        for (CharSequence charSequence : protoReference.getParameterTypes()) {
            this.writeType(charSequence);
        }
        this.writer.write(41);
        this.writeType(protoReference.getReturnType());
    }

    public void writeFieldDescriptor(FieldReference fieldReference) throws IOException {
        this.writeType(fieldReference.getDefiningClass());
        this.writer.write("->");
        this.writeSimpleName(fieldReference.getName());
        this.writer.write(58);
        this.writeType(fieldReference.getType());
    }

    public void writeShortFieldDescriptor(FieldReference fieldReference) throws IOException {
        this.writeSimpleName(fieldReference.getName());
        this.writer.write(58);
        this.writeType(fieldReference.getType());
    }

    public void writeMethodHandle(MethodHandleReference methodHandleReference) throws IOException {
        this.writer.write(MethodHandleType.toString(methodHandleReference.getMethodHandleType()));
        this.writer.write(64);
        Reference memberReference = methodHandleReference.getMemberReference();
        if (memberReference instanceof MethodReference) {
            this.writeMethodDescriptor((MethodReference)memberReference);
        } else {
            this.writeFieldDescriptor((FieldReference)memberReference);
        }
    }

    public void writeCallSite(CallSiteReference callSiteReference) throws IOException {
        this.writeSimpleName(callSiteReference.getName());
        this.writer.write(40);
        this.writeQuotedString(callSiteReference.getMethodName());
        this.writer.write(", ");
        this.writeMethodProtoDescriptor(callSiteReference.getMethodProto());
        for (EncodedValue encodedValue : callSiteReference.getExtraArguments()) {
            this.writer.write(", ");
            this.writeEncodedValue(encodedValue);
        }
        this.writer.write(")@");
        MethodHandleReference methodHandle = callSiteReference.getMethodHandle();
        if (methodHandle.getMethodHandleType() != 4) {
            throw new IllegalArgumentException("The linker method handle for a call site must be of type invoke-static");
        }
        this.writeMethodDescriptor((MethodReference)callSiteReference.getMethodHandle().getMemberReference());
    }

    public void writeType(CharSequence type) throws IOException {
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == 'L') {
                this.writeClass(type.subSequence(i, type.length()));
                return;
            }
            if (c != '[') {
                if (c == 'Z' || c == 'B' || c == 'S' || c == 'C' || c == 'I' || c == 'J' || c == 'F' || c == 'D' || c == 'V') {
                    this.writer.write(c);
                    if (i != type.length() - 1) {
                        throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
                    }
                    return;
                }
                throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
            }
            this.writer.write(c);
        }
        throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
    }

    protected void writeClass(CharSequence type) throws IOException {
        int startIndex;
        int i;
        assert (type.charAt(0) == 'L');
        this.writer.write(type.charAt(0));
        for (i = startIndex = 1; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '/') {
                if (i == startIndex) {
                    throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
                }
                this.writeSimpleName(type.subSequence(startIndex, i));
                this.writer.write(type.charAt(i));
                startIndex = i + 1;
                continue;
            }
            if (c != ';') continue;
            if (i == startIndex) {
                throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
            }
            this.writeSimpleName(type.subSequence(startIndex, i));
            this.writer.write(type.charAt(i));
            break;
        }
        if (i != type.length() - 1 || type.charAt(i) != ';') {
            throw new IllegalArgumentException(String.format("Invalid type string: %s", type));
        }
    }

    protected void writeSimpleName(CharSequence simpleName) throws IOException {
        this.writer.append(simpleName);
    }

    /*
     * Unable to fully structure code
     */
    public void writeQuotedString(CharSequence charSequence) throws IOException {
        this.writer.write(34);
        string = charSequence.toString();
        block5: for (i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') {
                if (c == '\'' || c == '\"' || c == '\\') {
                    this.writer.write(92);
                }
                this.writer.write(c);
                continue;
            }
            if (c > '\u007f') ** GOTO lbl-1000
            switch (c) {
                case '\n': {
                    this.writer.write("\\n");
                    continue block5;
                }
                case '\r': {
                    this.writer.write("\\r");
                    continue block5;
                }
                case '\t': {
                    this.writer.write("\\t");
                    continue block5;
                }
                default: lbl-1000:
                // 2 sources

                {
                    this.writer.write("\\u");
                    this.writer.write(Character.forDigit(c >> 12, 16));
                    this.writer.write(Character.forDigit(c >> 8 & 15, 16));
                    this.writer.write(Character.forDigit(c >> 4 & 15, 16));
                    this.writer.write(Character.forDigit(c & 15, 16));
                }
            }
        }
        this.writer.write(34);
    }

    public void writeEncodedValue(EncodedValue encodedValue) throws IOException {
        switch (encodedValue.getValueType()) {
            case 31: {
                this.writer.write(Boolean.toString(((BooleanEncodedValue)encodedValue).getValue()));
                break;
            }
            case 0: {
                this.writer.write(String.format("0x%x", ((ByteEncodedValue)encodedValue).getValue()));
                break;
            }
            case 3: {
                this.writer.write(String.format("0x%x", ((CharEncodedValue)encodedValue).getValue()));
                break;
            }
            case 2: {
                this.writer.write(String.format("0x%x", ((ShortEncodedValue)encodedValue).getValue()));
                break;
            }
            case 4: {
                this.writer.write(String.format("0x%x", ((IntEncodedValue)encodedValue).getValue()));
                break;
            }
            case 6: {
                this.writer.write(String.format("0x%x", ((LongEncodedValue)encodedValue).getValue()));
                break;
            }
            case 16: {
                this.writer.write(Float.toString(((FloatEncodedValue)encodedValue).getValue()));
                break;
            }
            case 17: {
                this.writer.write(Double.toString(((DoubleEncodedValue)encodedValue).getValue()));
                break;
            }
            case 29: {
                this.writeAnnotation((AnnotationEncodedValue)encodedValue);
                break;
            }
            case 28: {
                this.writeArray((ArrayEncodedValue)encodedValue);
                break;
            }
            case 23: {
                this.writeQuotedString(((StringEncodedValue)encodedValue).getValue());
                break;
            }
            case 25: {
                this.writeFieldDescriptor(((FieldEncodedValue)encodedValue).getValue());
                break;
            }
            case 27: {
                this.writeFieldDescriptor(((EnumEncodedValue)encodedValue).getValue());
                break;
            }
            case 26: {
                this.writeMethodDescriptor(((MethodEncodedValue)encodedValue).getValue());
                break;
            }
            case 24: {
                this.writeType(((TypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 21: {
                this.writeMethodProtoDescriptor(((MethodTypeEncodedValue)encodedValue).getValue());
                break;
            }
            case 22: {
                this.writeMethodHandle(((MethodHandleEncodedValue)encodedValue).getValue());
                break;
            }
            case 30: {
                this.writer.write("null");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown encoded value type");
            }
        }
    }

    protected void writeAnnotation(AnnotationEncodedValue annotation) throws IOException {
        this.writer.write("Annotation[");
        this.writeType(annotation.getType());
        Set<? extends AnnotationElement> elements = annotation.getElements();
        for (AnnotationElement annotationElement : elements) {
            this.writer.write(", ");
            this.writeSimpleName(annotationElement.getName());
            this.writer.write(61);
            this.writeEncodedValue(annotationElement.getValue());
        }
        this.writer.write(93);
    }

    protected void writeArray(ArrayEncodedValue array) throws IOException {
        this.writer.write("Array[");
        boolean first = true;
        for (EncodedValue encodedValue : array.getValue()) {
            if (first) {
                first = false;
            } else {
                this.writer.write(", ");
            }
            this.writeEncodedValue(encodedValue);
        }
        this.writer.write(93);
    }

    public void writeReference(Reference reference) throws IOException {
        if (reference instanceof StringReference) {
            this.writeQuotedString((StringReference)reference);
        } else if (reference instanceof TypeReference) {
            this.writeType((TypeReference)reference);
        } else if (reference instanceof FieldReference) {
            this.writeFieldDescriptor((FieldReference)reference);
        } else if (reference instanceof MethodReference) {
            this.writeMethodDescriptor((MethodReference)reference);
        } else if (reference instanceof MethodProtoReference) {
            this.writeMethodProtoDescriptor((MethodProtoReference)reference);
        } else if (reference instanceof MethodHandleReference) {
            this.writeMethodHandle((MethodHandleReference)reference);
        } else if (reference instanceof CallSiteReference) {
            this.writeCallSite((CallSiteReference)reference);
        } else {
            throw new IllegalArgumentException(String.format("Not a known reference type: %s", reference.getClass()));
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.writer.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.writer.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.writer.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.writer.write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.writer.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.writer.append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.writer.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

