/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.collection;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.sdedit.util.Utilities;

public class LeveledContainer<T>
implements Iterable<T> {
    private boolean reverse;
    private Map<Integer, List<T>> levels;

    public LeveledContainer() {
        this(false);
    }

    protected List<T> list(int level) {
        List<T> l = this.levels.get(level);
        if (l == null) {
            l = new LinkedList<T>();
            this.levels.put(level, l);
        }
        return l;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }

    public void add(int level, T t) {
        this.list(level).add(t);
    }

    public void remove(int level, T t) {
        List<T> list = this.list(level);
        if (list != null) {
            list.remove(t);
            if (list.isEmpty()) {
                this.levels.remove(level);
            }
        }
    }

    public LeveledContainer(boolean reverse) {
        this.reverse = reverse;
        this.levels = new TreeMap<Integer, List<T>>();
    }

    @Override
    public Iterator<T> iterator() {
        return new LCIterator();
    }

    protected class LCIterator
    implements Iterator<T> {
        private Integer[] _levels;
        private int index;
        private Iterator<T> iterator;

        protected LCIterator() {
            this._levels = LeveledContainer.this.levels.keySet().toArray(new Integer[0]);
            if (LeveledContainer.this.reverse) {
                this._levels = Utilities.reverse(this._levels);
            }
            this.index = 0;
        }

        protected Iterator<T> iterator() {
            if (this.iterator == null && this.index < this._levels.length) {
                this.iterator = ((List)LeveledContainer.this.levels.get(this._levels[this.index])).iterator();
                ++this.index;
            }
            return this.iterator;
        }

        @Override
        public boolean hasNext() {
            Iterator iterator = this.iterator();
            if (iterator == null) {
                return false;
            }
            return iterator.hasNext();
        }

        @Override
        public T next() {
            Object next = this.iterator().next();
            if (!this.iterator().hasNext()) {
                this.iterator = null;
            }
            return next;
        }

        @Override
        public void remove() {
            this.iterator().remove();
        }
    }
}

