/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.config;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.config.GlobalConfigurationStrings;
import net.sf.sdedit.config.PrintConfiguration;
import net.sf.sdedit.config.SequenceConfiguration;
import net.sf.sdedit.editor.plugin.Plugin;
import net.sf.sdedit.editor.plugin.PluginRegistry;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.util.DocUtil;
import net.sf.sdedit.util.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ConfigurationManager {
    public static final Bean<GlobalConfiguration> GLOBAL_DEFAULT;
    public static final Bean<PrintConfiguration> PRINT_DEFAULT;
    private static final Bean<GlobalConfiguration> global;
    private static final Map<String, Bean<? extends Configuration>> DEFAULT_CONF;
    private static final Map<String, Bean<? extends Configuration>> local;
    private static final Bean<PrintConfiguration> print;

    private ConfigurationManager() {
    }

    public static Bean<GlobalConfiguration> getGlobalConfigurationBean() {
        return global;
    }

    public static Bean<PrintConfiguration> getPrintConfigurationBean() {
        return print;
    }

    public static PrintConfiguration getPrintConfiguration() {
        return print.getDataObject();
    }

    public static GlobalConfiguration getGlobalConfiguration() {
        return global.getDataObject();
    }

    public static <T extends Configuration> Bean<T> getInitialDefaultConfigurationBean(Class<T> cls) {
        return ((Configuration)DEFAULT_CONF.get(cls.getName()).getDataObject().cast(cls)).getBean(cls);
    }

    public static <T extends Configuration> Bean<T> getDefaultConfigurationBean(Class<T> cls) {
        return ((Configuration)local.get(cls.getName()).getDataObject().cast(cls)).getBean(cls);
    }

    public static <T extends Configuration> T getDefaultConfiguration(Class<T> cls) {
        return (T)((Configuration)local.get(cls.getName()).getDataObject().cast(cls));
    }

    public static <T extends Configuration> Bean<T> createNewDefaultConfiguration(Class<T> cls) {
        return ConfigurationManager.getDefaultConfigurationBean(cls).copy();
    }

    private static String getElementName(Bean<?> bean) {
        if (bean.getDataObject().isA(PrintConfiguration.class)) {
            return "printer-settings";
        }
        if (bean.getDataObject().isA(GlobalConfiguration.class)) {
            return "global-settings";
        }
        if (bean.getDataObject().isA(SequenceConfiguration.class)) {
            return "default-settings";
        }
        return bean.getDataClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeConfigurations() throws IOException {
        FileOutputStream stream = new FileOutputStream(Constants.GLOBAL_CONF_FILE);
        try {
            Document document = DocUtil.newDocument();
            Element root = document.createElement("sdedit-configuration");
            document.appendChild(root);
            global.store(document, "/sdedit-configuration", ConfigurationManager.getElementName(global));
            for (Map.Entry<String, Bean<? extends Configuration>> entry : local.entrySet()) {
                Bean<? extends Configuration> conf = entry.getValue();
                conf.store(document, "/sdedit-configuration", ConfigurationManager.getElementName(conf));
            }
            print.store(document, "/sdedit-configuration", ConfigurationManager.getElementName(print));
            DocUtil.writeDocument(document, "UTF-8", stream);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            ((OutputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean getValuesFromURL(URL url, Bean<GlobalConfiguration> global, Map<String, Bean<? extends Configuration>> defaultConf, Bean<PrintConfiguration> print) throws IOException, DocUtil.XMLException {
        InputStream stream = null;
        try {
            stream = url.openStream();
            Document document = DocUtil.readDocument(stream, "UTF-8");
            global.load(document, "/sdedit-configuration/" + ConfigurationManager.getElementName(global));
            if (print != null) {
                print.load(document, "/sdedit-configuration/" + ConfigurationManager.getElementName(print));
            }
            for (Map.Entry<String, Bean<? extends Configuration>> entry : defaultConf.entrySet()) {
                Bean<? extends Configuration> conf = entry.getValue();
                conf.load(document, "/sdedit-configuration/" + ConfigurationManager.getElementName(conf));
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        return true;
    }

    static {
        ArrayList<Class> confClasses = new ArrayList<Class>();
        confClasses.add(SequenceConfiguration.class);
        for (Plugin plugin : PluginRegistry.getInstance()) {
            if (plugin.getConfigurationClass() == null) continue;
            confClasses.add(plugin.getConfigurationClass());
        }
        GLOBAL_DEFAULT = new Bean<GlobalConfiguration>(GlobalConfiguration.class, new GlobalConfigurationStrings());
        DEFAULT_CONF = new HashMap<String, Bean<? extends Configuration>>();
        for (Class cls : confClasses) {
            Bean bean = new Bean(cls, null);
            DEFAULT_CONF.put(cls.getName(), bean);
        }
        PRINT_DEFAULT = new Bean<PrintConfiguration>(PrintConfiguration.class, null);
        URL url = Utilities.getResource("default.conf");
        try {
            ConfigurationManager.getValuesFromURL(url, GLOBAL_DEFAULT, DEFAULT_CONF, PRINT_DEFAULT);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IllegalStateException();
        }
        local = new HashMap<String, Bean<? extends Configuration>>();
        global = GLOBAL_DEFAULT.copy();
        for (Map.Entry<String, Bean<? extends Configuration>> entry : DEFAULT_CONF.entrySet()) {
            local.put(entry.getKey(), entry.getValue().copy());
        }
        print = PRINT_DEFAULT.copy();
        try {
            URL globalUrl = Constants.GLOBAL_CONF_FILE.toURI().toURL();
            ConfigurationManager.getValuesFromURL(globalUrl, global, local, print);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

