/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.RetrievalCounts;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class RoutineExtRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(RoutineExtRetriever.class.getName());

    RoutineExtRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveRoutineInformation() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ROUTINES)) {
            LOGGER.log(Level.INFO, "Not retrieving routine definitions, since this was not requested");
            LOGGER.log(Level.FINE, "Routine definition SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving routine definitions");
        String name = "routine definitions";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine definitions");
        Query routineDefinitionsSql = informationSchemaViews.getQuery(InformationSchemaKey.ROUTINES);
        try (Connection connection = this.getRetrieverConnection().getConnection("routine definitions");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(routineDefinitionsSql, statement, this.getLimitMap());){
            while (results.next()) {
                String specificName;
                String routineName;
                String schemaName;
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("ROUTINE_CATALOG"));
                Optional<MutableRoutine> routineOptional = this.lookupRoutine(catalogName, schemaName = this.normalizeSchemaName(results.getString("ROUTINE_SCHEMA")), routineName = results.getString("ROUTINE_NAME"), specificName = results.getString("SPECIFIC_NAME"));
                if (!routineOptional.isPresent()) continue;
                MutableRoutine routine = routineOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving routine information for <%s>", routineName));
                RoutineBodyType routineBodyType = results.getEnum("ROUTINE_BODY", RoutineBodyType.unknown);
                String definition = results.getString("ROUTINE_DEFINITION");
                routine.setRoutineBodyType(routineBodyType);
                routine.appendDefinition(definition);
                routine.addAttributes(results.getAttributes());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routine definitions", e);
        }
        retrievalCounts.log();
    }

    void retrieveRoutineReferences() throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.ROUTINE_REFERENCES)) {
            LOGGER.log(Level.INFO, "Not retrieving routine references, since this was not requested");
            LOGGER.log(Level.FINE, "Routine references SQL statement was not provided");
            return;
        }
        LOGGER.log(Level.INFO, "Retrieving routine references");
        String name = "routine references";
        RetrievalCounts retrievalCounts = new RetrievalCounts("routine references");
        Query routineReferencesSql = informationSchemaViews.getQuery(InformationSchemaKey.ROUTINE_REFERENCES);
        try (Connection connection = this.getRetrieverConnection().getConnection("routine references");
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(routineReferencesSql, statement, this.getLimitMap());){
            while (results.next()) {
                retrievalCounts.count();
                String catalogName = this.normalizeCatalogName(results.getString("ROUTINE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("ROUTINE_SCHEMA"));
                String routineName = results.getString("ROUTINE_NAME");
                String specificName = results.getString("SPECIFIC_NAME");
                String referencedObjectCatalogName = results.getString("REFERENCED_OBJECT_CATALOG");
                String referencedObjectSchemaName = results.getString("REFERENCED_OBJECT_SCHEMA");
                String referencedObjectName = results.getString("REFERENCED_OBJECT_NAME");
                Optional<MutableRoutine> routineOptional = this.lookupRoutine(catalogName, schemaName, routineName, specificName);
                if (!routineOptional.isPresent()) continue;
                MutableRoutine routine = routineOptional.get();
                LOGGER.log(Level.FINER, new StringFormat("Retrieving routine references for <%s>", routineName));
                Optional<DatabaseObject> referencedObjectOptional = this.lookupReferencedObject(referencedObjectCatalogName, referencedObjectSchemaName, referencedObjectName, specificName);
                if (!referencedObjectOptional.isPresent()) continue;
                routine.addReferencedObject(referencedObjectOptional.get());
                retrievalCounts.countIncluded();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve routine definitions", e);
        }
        retrievalCounts.log();
    }

    private Optional<DatabaseObject> lookupReferencedObject(String catalogName, String schemaName, String objectName, String specificName) {
        Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, objectName);
        if (tableOptional.isPresent()) {
            return Optional.of((DatabaseObject)tableOptional.get());
        }
        this.lookupRoutine(catalogName, schemaName, objectName, specificName);
        if (tableOptional.isPresent()) {
            return Optional.of((DatabaseObject)tableOptional.get());
        }
        return Optional.empty();
    }
}

