/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.util.regex.Pattern;
import picocli.CommandLine;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;

@CommandLine.Command(name="grep", header={"** Grep for database object metadata"}, description={""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"grep"}, optionListHeading="Options:%n")
public final class GrepCommand
extends BaseStateHolder
implements Runnable {
    @CommandLine.Option(names={"--grep-tables"}, description={"<greptables> is a regular expression to match fully qualified table names, in the form \"CATALOGNAME.SCHEMANAME.TABLENAME\" - for example, --grep-tables=.*\\.COUPONS|.*\\.BOOKS matches tables named COUPONS or BOOKS", "Optional, default is no grep"})
    private Pattern greptables;
    @CommandLine.Option(names={"--grep-columns"}, description={"<grepcolumns> is a regular expression to match fully qualified column names, in the form \"CATALOGNAME.SCHEMANAME.TABLENAME.COLUMNNAME\" - for example, --grep-columns=.*\\.STREET|.*\\.PRICE matches columns named STREET or PRICE in any table", "Optional, default is no grep"})
    private Pattern grepcolumns;
    @CommandLine.Option(names={"--grep-def"}, description={"<grepdef> is a regular expression to match text within remarks and definitions of views, stored proedures and triggers, if available", "Optional, default is no grep"})
    private Pattern grepdef;
    @CommandLine.Option(names={"--grep-parameters"}, description={"<grepparameters> is a regular expression to match fully qualified routine parameter names, in the form \"CATALOGNAME.SCHEMANAME.ROUTINENAME.INOUTNAME\" - for example, --grep-parameters=.*\\.STREET|.*\\.PRICE matches routine parameters named STREET or PRICE in any routine", "Optional, default is no grep"})
    private Pattern grepparameters;
    @CommandLine.Option(names={"--invert-match"}, description={"Inverts the sense of matching, and shows non-matching tables and columns", "Optional, default is false"}, negatable=true)
    private Boolean invertMatch;

    public GrepCommand(ShellState state) {
        super(state);
    }

    @Override
    public void run() {
        SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getGrepOptions());
        if (this.greptables != null) {
            grepOptionsBuilder.includeGreppedTables(this.greptables);
        }
        if (this.grepcolumns != null) {
            grepOptionsBuilder.includeGreppedColumns(this.grepcolumns);
        }
        if (this.grepparameters != null) {
            grepOptionsBuilder.includeGreppedRoutineParameters(this.grepparameters);
        }
        if (this.grepdef != null) {
            grepOptionsBuilder.includeGreppedDefinitions(this.grepdef);
        }
        if (this.invertMatch != null) {
            grepOptionsBuilder.invertGrepMatch(this.invertMatch.booleanValue());
        }
        this.state.withGrepOptions(grepOptionsBuilder.toOptions());
    }
}

