/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.metadata;

import com.ibm.db2.cmx.runtime.internal.repository.metadata.PerformanceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.SourceInfo;
import com.ibm.db2.cmx.runtime.internal.repository.util.PerformanceInfoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceLocation
extends ArrayList<SourceInfo> {
    private static final long serialVersionUID = -8168223491984250676L;

    public static String generateKey(String string, String string2, int n2, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        SourceLocation.generateKey(string2, n2, stringBuilder);
        return stringBuilder.toString();
    }

    public static String generateKey(String string, int n2, StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public String generateKey() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (SourceInfo sourceInfo : this) {
            if (bl2) {
                SourceLocation.generateKey(sourceInfo.getProjectName(), sourceInfo.getPath(), sourceInfo.getLineNumber(), stringBuilder);
                bl2 = false;
                continue;
            }
            SourceLocation.generateKey(sourceInfo.getPath(), sourceInfo.getLineNumber(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String getProjectName() {
        String string = null;
        if (this.size() > 0) {
            string = ((SourceInfo)this.get(0)).getProjectName();
        }
        return string;
    }

    public boolean hasPerformanceInfo() {
        boolean bl2 = false;
        for (SourceInfo sourceInfo : this) {
            List<PerformanceInfo> list = sourceInfo.getPerformanceInfo();
            if (list == null || list.size() <= 0) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public Map<Object, List<PerformanceInfo>> getPerformanceInfoByRunId() {
        HashMap<Object, List<PerformanceInfo>> hashMap = new HashMap<Object, List<PerformanceInfo>>();
        for (SourceInfo sourceInfo : this) {
            Map<Object, List<PerformanceInfo>> map = sourceInfo.getPerformanceInfoByRunId();
            PerformanceInfoUtils.addMaps(hashMap, map);
        }
        return hashMap;
    }

    public void addPerformanceInfoFrom(SourceLocation sourceLocation) {
        if (sourceLocation.size() != this.size()) {
            return;
        }
        for (int i10 = 0; i10 < this.size(); ++i10) {
            SourceInfo sourceInfo = (SourceInfo)this.get(i10);
            SourceInfo sourceInfo2 = (SourceInfo)sourceLocation.get(i10);
            sourceInfo.addPerformanceInfoFrom(sourceInfo2);
        }
    }

    public void removePerformanceInfoFor(Object object) {
        for (SourceInfo sourceInfo : this) {
            sourceInfo.removePerformanceInfoFor(object);
        }
    }

    public SourceLocation deepClone() {
        SourceLocation sourceLocation = new SourceLocation();
        for (int i10 = 0; i10 < this.size(); ++i10) {
            try {
                SourceInfo sourceInfo = (SourceInfo)((SourceInfo)this.get(i10)).clone();
                sourceLocation.add(sourceInfo);
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return sourceLocation;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SourceLocation)) {
            return false;
        }
        SourceLocation sourceLocation = (SourceLocation)object;
        if (this.size() != sourceLocation.size()) {
            return false;
        }
        boolean bl2 = true;
        for (int i10 = 0; i10 < this.size() && bl2; ++i10) {
            bl2 = ((SourceInfo)this.get(i10)).equals(sourceLocation.get(i10));
        }
        return bl2;
    }
}

