/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxReadableType;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDecimal;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public abstract class IfxObject
implements IfmxReadableType {
    private static final Object logger = Trace.getLoggerForClass(IfxObject.class);
    protected IfxConnection conn;
    protected boolean isNull = true;
    protected Trace trace = null;
    protected int ifxType;
    protected String extendedName = "";
    protected String extendedOwner = "";
    protected int extendedID;
    protected int encodedLength = 0;
    protected int sourceType;
    boolean isDistinct = false;
    boolean isNamedRow = false;
    DataTruncation warning = null;
    protected Map<String, Class<?>> typeMap = null;
    protected boolean used_in_update = false;
    protected int jdbcType = 0;
    private static final int NO_SCALE = -1;
    private static final String FROM = "from";
    private static final HashMap<String, String> objMap = new HashMap();

    IfxObject() {
    }

    IfxObject(Object obj) throws SQLException {
        this.fromObject(obj);
    }

    private Method findMethod(Object obj, int scale, String name) throws SQLException {
        return this.findMethod(obj, scale, name, FROM);
    }

    private Method findMethod(Object obj, int scale, String name, String methodDirection) throws SQLException {
        if (obj == null) {
            throw IfxErrMsg.getSQLException(-79755);
        }
        try {
            String className = obj.getClass().getName();
            String methodName = methodDirection + objMap.get(className);
            if (TraceFlag.isTraceEnabled()) {
                this.writeTrace(3, "IfxObject.fromObject(): className = " + className);
                this.writeTrace(3, "IfxObject.fromObject(): methodName = " + methodName);
                this.writeTrace(3, "IfxObject.fromObject(): thisObject = " + this.getClass().getName());
            }
            Class<?> clsRef = this.getClass();
            Class[] classArgs = scale != -1 ? new Class[]{obj.getClass(), Integer.TYPE} : (name != null ? new Class[]{obj.getClass(), String.class} : new Class[]{obj.getClass()});
            return clsRef.getMethod(methodName, classArgs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(e, -79716);
        }
    }

    public void fromObject(Object obj) throws SQLException {
        if (obj != null) {
            try {
                Method method = this.findMethod(obj, -1, null);
                Object[] objArgs = new Object[]{obj};
                method.invoke((Object)this, objArgs);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException((Throwable)e, -79771, this.conn);
            }
        } else {
            this.nullify();
        }
    }

    public void fromObject(Object obj, int scale) throws SQLException {
        if (obj != null) {
            try {
                if (this instanceof IfxDecimal) {
                    Method method = this.findMethod(obj, scale, null);
                    Object[] objArgs = new Object[]{obj, scale};
                    method.invoke((Object)this, objArgs);
                }
                this.fromObject(obj);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            this.nullify();
        }
    }

    public void fromObject(Object obj, String name) throws SQLException {
        if (obj != null) {
            try {
                if (this instanceof IfxCollection) {
                    Method method = this.findMethod(obj, -1, name);
                    Object[] objArgs = new Object[]{obj, name};
                    method.invoke((Object)this, objArgs);
                }
                this.fromObject(obj);
            }
            catch (SQLException e) {
                throw e;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException((Throwable)e, -79716, this.conn);
            }
        } else {
            this.nullify();
        }
    }

    public void setConnection(IfxConnection conn) {
        this.conn = conn;
        this.setTrace(conn.getTrace());
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        this.typeMap = map;
    }

    @Override
    public final boolean isNull() {
        return this.isNull;
    }

    public final void nullify() {
        this.isNull = true;
    }

    public final void unnullify() {
        this.isNull = false;
    }

    public void setIfxType(int ifxType) {
        this.ifxType = ifxType;
    }

    int getIfxType() {
        return this.ifxType;
    }

    public void setExtendedTypeName(String name) {
        this.extendedName = name;
    }

    String getExtendedTypeName() {
        return this.extendedName;
    }

    void setExtendedOwner(String owner) {
        this.extendedOwner = owner;
    }

    String getExtendedOwner() {
        return this.extendedOwner;
    }

    void setExtendedId(int xid) {
        this.extendedID = xid;
    }

    int getExtendedId() {
        return this.extendedID;
    }

    void setSourceType(int sourceType) {
        this.sourceType = sourceType;
    }

    int getSourceType() {
        return this.sourceType;
    }

    public void clear() {
        this.nullify();
    }

    public short getEncodedLength() {
        return (short)this.encodedLength;
    }

    void setEncodedLength(int encodedLength) {
        this.encodedLength = encodedLength;
    }

    public DataTruncation getWarning() {
        return this.warning;
    }

    public void clearWarning() {
        this.warning = null;
    }

    void setTrace(Trace trace) {
        this.trace = trace;
    }

    void writeTrace(int level, String s) {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, level, s);
        }
    }

    void writeTrace(int level, byte[] data, char format) {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, level, data, format);
        }
    }

    void writeTrace(int level, byte[] data, int offset, char format, int length) {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, level, data, offset, format, length);
        }
    }

    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        return other instanceof IfxObject;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return super.toString();
    }

    public String toUnloadString() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80008, this.conn);
    }

    @Override
    public int toInt() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80008, this.conn);
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80014, this.conn);
    }

    @Override
    public byte toByte() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80015, this.conn);
    }

    @Override
    public byte[] toBytes() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80016, this.conn);
    }

    @Override
    public boolean toBoolean() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80018, this.conn);
    }

    @Override
    public Date toDate() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80024, this.conn);
    }

    @Override
    public float toFloat() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80020, this.conn);
    }

    @Override
    public long toLong() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80010, this.conn);
    }

    @Override
    public short toShort() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80012, this.conn);
    }

    @Override
    public Time toTime() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80025, this.conn);
    }

    @Override
    public double toDouble() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80022, this.conn);
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80026, this.conn);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80028, this.conn);
    }

    public InputStream toAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80029, this.conn);
    }

    public InputStream toBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80030, this.conn);
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80039, this.conn);
    }

    @Override
    public Blob toBlob() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80030, this.conn);
    }

    @Override
    public Clob toClob() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80030, this.conn);
    }

    public byte[] toIfx() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    public byte[] toIfxTuple() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80032, this.conn);
    }

    @Override
    public Object toObject() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80031, this.conn);
    }

    public Object toObject(boolean fromComplexType) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80031, this.conn);
    }

    @Override
    public Interval toInterval() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80038, this.conn);
    }

    @Override
    public IntervalYM toIntervalYM() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80036, this.conn);
    }

    @Override
    public IntervalDF toIntervalDF() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80037, this.conn);
    }

    public void fromIfx(byte[] b, String dbEnc) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b, int offset, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b, int offset, int length, String dbEnc) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b, short prec) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromIfx(byte[] b, int offset, int length, short prec) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromCDC(byte[] b, int offset, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80032, this.conn);
    }

    public void fromInt(int i) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80008, this.conn);
    }

    public void fromInt(Integer I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80009, this.conn);
    }

    public void fromString(String newval) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80027, this.conn);
    }

    public void fromString(String newval, boolean trimSpaces) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80027, this.conn);
    }

    public void fromDecimal(BigDecimal B) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromDecimal(BigDecimal B, int scale) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80014, this.conn);
    }

    public void fromByte(byte b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80015, this.conn);
    }

    public void fromByte(Byte B) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80017, this.conn);
    }

    public void fromBytes(byte[] b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80016, this.conn);
    }

    public void fromBoolean(boolean b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80018, this.conn);
    }

    public void fromBoolean(Boolean b) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80019, this.conn);
    }

    public void fromDate(Date D) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80024, this.conn);
    }

    public void fromFloat(float f) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80020, this.conn);
    }

    public void fromFloat(Float F) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80021, this.conn);
    }

    public void fromLong(long l) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80010, this.conn);
    }

    public void fromLong(Long L) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80011, this.conn);
    }

    public void fromShort(short s) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80012, this.conn);
    }

    public void fromShort(Short S) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80013, this.conn);
    }

    public void fromTime(Time T) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80025, this.conn);
    }

    public void fromDouble(double d) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80022, this.conn);
    }

    public void fromDouble(Double D) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80023, this.conn);
    }

    public void fromTimestamp(Timestamp T) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80026, this.conn);
    }

    public void fromAsciiStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80029, this.conn);
    }

    public void fromAsciiStream(InputStream fin, long length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80029, this.conn);
    }

    public void fromBinaryStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80030, this.conn);
    }

    public void fromBinaryStream(InputStream fin, long length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80030, this.conn);
    }

    public void fromInputStream(InputStream fin, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public void fromInputStream(InputStream fin, long length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public void fromCharacterStream(Reader reader, int length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80039, this.conn);
    }

    public void fromCharacterStream(Reader reader, long length) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80039, this.conn);
    }

    public void fromIntervalYM(IntervalYM I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80036, this.conn);
    }

    public void fromIntervalDF(IntervalDF I) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80037, this.conn);
    }

    public void fromClob(Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public void fromBlob(Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80028, this.conn);
    }

    public final void set_used_in_update(boolean setval) {
        this.used_in_update = setval;
    }

    public final boolean get_used_in_update() {
        return this.used_in_update;
    }

    void setJDBCType(int sqlType) {
        this.jdbcType = sqlType;
    }

    int getJDBCType() {
        return this.jdbcType;
    }

    public IfxBSONObject toIfxBSONObject() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79741, -80040, this.conn);
    }

    public void fromRowId(RowId rowid) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80041, this.conn);
    }

    public void fromNClob(NClob nclob) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80042, this.conn);
    }

    public void fromSQLXML(SQLXML sqlXML) throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80043, this.conn);
    }

    public RowId toRowId() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80041, this.conn);
    }

    public NClob toNClob() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80042, this.conn);
    }

    public SQLXML toSQLXML() throws SQLException {
        throw IfxErrMsg.getSQLMinorException(-79742, -80043, this.conn);
    }

    static {
        objMap.put("java.lang.Boolean", "Boolean");
        objMap.put("java.lang.Byte", "Byte");
        objMap.put("java.lang.Short", "Short");
        objMap.put("java.lang.Integer", "Int");
        objMap.put("java.math.BigInteger", "BigInt");
        objMap.put("java.lang.Long", "Long");
        objMap.put("java.lang.Float", "Float");
        objMap.put("java.lang.Double", "Double");
        objMap.put("java.lang.Number", "Double");
        objMap.put("java.lang.String", "String");
        objMap.put("java.math.BigDecimal", "Decimal");
        objMap.put("java.sql.Date", "Date");
        objMap.put("java.util.Date", "Date");
        objMap.put("java.util.Calendar", "Calendar");
        objMap.put("java.util.GregorianCalendar", "Calendar");
        objMap.put("java.sql.Time", "Time");
        objMap.put("java.sql.Timestamp", "Timestamp");
        objMap.put("[B", "Bytes");
        objMap.put("com.informix.lang.IntervalYM", "IntervalYM");
        objMap.put("com.informix.lang.IntervalDF", "IntervalDF");
        objMap.put(LocalDate.class.getCanonicalName(), LocalDate.class.getSimpleName());
        objMap.put(LocalTime.class.getCanonicalName(), LocalTime.class.getSimpleName());
        objMap.put(LocalDateTime.class.getCanonicalName(), LocalDateTime.class.getSimpleName());
    }
}

