/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.internal;

import java.io.File;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import xsbt.boot.internal.shaded.coursier.cache.CacheLocks$;
import xsbt.boot.internal.shaded.coursier.core.Classifier;
import xsbt.boot.internal.shaded.coursier.core.Dependency;
import xsbt.boot.internal.shaded.coursier.core.Module;
import xsbt.boot.internal.shaded.coursier.core.Repository;
import xsbt.boot.internal.shaded.coursier.core.Type;
import xsbt.boot.internal.shaded.coursier.params.ResolutionParams;
import xsbt.boot.internal.shaded.coursier.paths.CachePath;

public final class FetchCache
implements Serializable,
Product {
    private final Path base;

    @Override
    public final Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    public final Path base() {
        return this.base;
    }

    /*
     * WARNING - void declaration
     */
    public final Path dir(Key key) {
        void var1_1;
        return this.base().resolve(new StringBuilder(1).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(key.sha1()), 2)).append("/").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(var1_1.sha1()), 2)).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final Path resultFile(Key key) {
        void var1_1;
        return this.dir((Key)var1_1).resolve("artifacts");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Option<Seq<File>> read(Key key) {
        Option option;
        Path resultFile0 = this.resultFile(key);
        if (Files.isRegularFile(resultFile0, new LinkOption[0])) {
            void var1_1;
            Vector artifacts2 = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(new String(Files.readAllBytes(resultFile0), StandardCharsets.UTF_8))).map((Function1<String, String> & Serializable)x$1 -> x$1.trim()).filter((Function1<String, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(FetchCache.$anonfun$read$2(x$2))).map((Function1<String, Path> & Serializable)x$3 -> Paths.get(x$3, new String[0])).toVector();
            if (!artifacts2.forall((Function1<Path, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(FetchCache.$anonfun$read$4(x$4)))) return None$.MODULE$;
            option = new Some<Object>(var1_1.map((Function1<Path, File> & Serializable)x$5 -> x$5.toFile()));
            return option;
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean write(Key key, Seq<File> artifacts2) {
        void var1_1;
        void var2_2;
        void var3_3;
        Path resultFile0 = this.resultFile(key);
        Path tmpFile = CachePath.temporaryFile(resultFile0.toFile()).toPath();
        return BoxesRunTime.unboxToBoolean(CacheLocks$.MODULE$.withLockOr(this.base().toFile(), resultFile0.toFile(), () -> FetchCache.$anonfun$write$2((Path)var3_3, (Seq)var2_2, (Path)var1_1), (Function0<Some> & Serializable)() -> new Some<Boolean>(BoxesRunTime.boxToBoolean(false))));
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder b = new StringBuilder("FetchCache(");
        b.append(String.valueOf(this.base()));
        b.append(")");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean canEqual(Object obj) {
        void var1_1;
        return obj != null && var1_1 instanceof FetchCache;
    }

    public final boolean equals(Object obj) {
        block3: {
            block2: {
                Path path;
                if (this == obj) break block2;
                if (!this.canEqual(obj)) break block3;
                FetchCache other = (FetchCache)obj;
                Path path2 = this.base();
                path = ((FetchCache)((Object)path)).base();
                if (!(!(path2 != null ? !((Object)path2).equals(path) : path != null))) break block3;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int code = 17 + Statics.anyHash("FetchCache");
        code = code * 37 + Statics.anyHash(this.base());
        return (int)(var1_1 * 37);
    }

    @Override
    public final String productPrefix() {
        return "FetchCache";
    }

    @Override
    public final int productArity() {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object productElement(int n) {
        void var1_1;
        switch (n) {
            case 0: {
                return this.base();
            }
        }
        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)var1_1)).toString());
    }

    public static final /* synthetic */ boolean $anonfun$read$2(String x$2) {
        String string;
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
    }

    public static final /* synthetic */ boolean $anonfun$read$4(Path x$4) {
        return Files.isRegularFile(x$4, new LinkOption[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final void doWrite$1(Path tmpFile$1, Seq artifacts$1, Path resultFile0$1) {
        void var2_2;
        Path path;
        void var1_1;
        Files.write(tmpFile$1, ((IterableOnceOps)var1_1.map((Function1<File, String> & Serializable)x$6 -> x$6.getAbsolutePath())).mkString("\n").getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.move(path, (Path)var2_2, StandardCopyOption.ATOMIC_MOVE);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$write$2(Path tmpFile$1, Seq artifacts$1, Path resultFile0$1) {
        void var2_2;
        void var1_1;
        FetchCache.doWrite$1(tmpFile$1, (Seq)var1_1, (Path)var2_2);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public FetchCache(Path base) {
        void var1_1;
        this.base = var1_1;
        Product.$init$(this);
    }

    public static final class Key
    implements Serializable,
    Product {
        private String repr;
        private String sha1;
        private final Seq<Dependency> dependencies;
        private final Seq<Repository> repositories;
        private final ResolutionParams resolutionParams;
        private final Seq<Tuple2<Module, String>> forceVersion;
        private final Seq<Tuple2<String, String>> properties;
        private final Seq<Tuple2<String, String>> forcedProperties;
        private final Seq<String> profiles;
        private final String cacheLocation;
        private final Seq<Classifier> classifiers;
        private final Option<Object> mainArtifacts;
        private final Option<Seq<Type>> artifactTypesOpt;
        private volatile byte bitmap$0;

        public final Seq<Dependency> dependencies() {
            return this.dependencies;
        }

        public final Seq<Repository> repositories() {
            return this.repositories;
        }

        public final ResolutionParams resolutionParams() {
            return this.resolutionParams;
        }

        public final Seq<Tuple2<Module, String>> forceVersion() {
            return this.forceVersion;
        }

        public final Seq<Tuple2<String, String>> properties() {
            return this.properties;
        }

        public final Seq<Tuple2<String, String>> forcedProperties() {
            return this.forcedProperties;
        }

        public final Seq<String> profiles() {
            return this.profiles;
        }

        public final String cacheLocation() {
            return this.cacheLocation;
        }

        public final Seq<Classifier> classifiers() {
            return this.classifiers;
        }

        public final Option<Object> mainArtifacts() {
            return this.mainArtifacts;
        }

        public final Option<Seq<Type>> artifactTypesOpt() {
            return this.artifactTypesOpt;
        }

        private String repr$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.repr = this.productIterator().mkString("(", ", ", ")");
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.repr;
        }

        public final String repr() {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                return this.repr$lzycompute();
            }
            return this.repr;
        }

        private String sha1$lzycompute() {
            Key key = this;
            synchronized (key) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    byte[] b = messageDigest.digest(this.repr().getBytes(StandardCharsets.UTF_8));
                    String s = new BigInteger(1, b).toString(16);
                    this.sha1 = new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("0"), 40 - s.length())).append((String)((Object)messageDigest)).toString();
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.sha1;
        }

        public final String sha1() {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                return this.sha1$lzycompute();
            }
            return this.sha1;
        }

        @Override
        public final String productPrefix() {
            return "Key";
        }

        @Override
        public final int productArity() {
            return 11;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object productElement(int x$1) {
            void var1_1;
            switch (x$1) {
                case 0: {
                    return this.dependencies();
                }
                case 1: {
                    return this.repositories();
                }
                case 2: {
                    return this.resolutionParams();
                }
                case 3: {
                    return this.forceVersion();
                }
                case 4: {
                    return this.properties();
                }
                case 5: {
                    return this.forcedProperties();
                }
                case 6: {
                    return this.profiles();
                }
                case 7: {
                    return this.cacheLocation();
                }
                case 8: {
                    return this.classifiers();
                }
                case 9: {
                    return this.mainArtifacts();
                }
                case 10: {
                    return this.artifactTypesOpt();
                }
            }
            return Statics.ioobe((int)var1_1);
        }

        @Override
        public final Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        public final int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public final String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object x$1) {
            void var1_1;
            void var2_7;
            if (this == x$1) return true;
            Object object = x$1;
            if (object instanceof Key) {
                boolean bl = true;
            } else {
                boolean bl = false;
            }
            if (var2_7 == false) return false;
            Key key = (Key)var1_1;
            Seq<Dependency> seq = this.dependencies();
            Seq<Dependency> seq2 = key.dependencies();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<Repository> seq3 = this.repositories();
            Seq<Repository> seq4 = key.repositories();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            ResolutionParams resolutionParams = this.resolutionParams();
            ResolutionParams resolutionParams2 = key.resolutionParams();
            if (resolutionParams == null) {
                if (resolutionParams2 != null) {
                    return false;
                }
            } else if (!((Object)resolutionParams).equals(resolutionParams2)) return false;
            Seq<Tuple2<Module, String>> seq5 = this.forceVersion();
            Seq<Tuple2<Module, String>> seq6 = key.forceVersion();
            if (seq5 == null) {
                if (seq6 != null) {
                    return false;
                }
            } else if (!seq5.equals(seq6)) return false;
            Seq<Tuple2<String, String>> seq7 = this.properties();
            Seq<Tuple2<String, String>> seq8 = key.properties();
            if (seq7 == null) {
                if (seq8 != null) {
                    return false;
                }
            } else if (!seq7.equals(seq8)) return false;
            Seq<Tuple2<String, String>> seq9 = this.forcedProperties();
            Seq<Tuple2<String, String>> seq10 = key.forcedProperties();
            if (seq9 == null) {
                if (seq10 != null) {
                    return false;
                }
            } else if (!seq9.equals(seq10)) return false;
            Seq<String> seq11 = this.profiles();
            Seq<String> seq12 = key.profiles();
            if (seq11 == null) {
                if (seq12 != null) {
                    return false;
                }
            } else if (!seq11.equals(seq12)) return false;
            String string = this.cacheLocation();
            String string2 = key.cacheLocation();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Seq<Classifier> seq13 = this.classifiers();
            Seq<Classifier> seq14 = key.classifiers();
            if (seq13 == null) {
                if (seq14 != null) {
                    return false;
                }
            } else if (!seq13.equals(seq14)) return false;
            Option<Object> option = this.mainArtifacts();
            Option<Object> option2 = key.mainArtifacts();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Seq<Type>> option3 = this.artifactTypesOpt();
            Option<Seq<Type>> option4 = key.artifactTypesOpt();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Key(Seq<Dependency> dependencies, Seq<Repository> repositories, ResolutionParams resolutionParams, Seq<Tuple2<Module, String>> forceVersion, Seq<Tuple2<String, String>> properties, Seq<Tuple2<String, String>> forcedProperties, Seq<String> profiles, String cacheLocation, Seq<Classifier> classifiers, Option<Object> mainArtifacts, Option<Seq<Type>> artifactTypesOpt) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.dependencies = var1_1;
            this.repositories = var2_2;
            this.resolutionParams = var3_3;
            this.forceVersion = forceVersion;
            this.properties = properties;
            this.forcedProperties = forcedProperties;
            this.profiles = profiles;
            this.cacheLocation = cacheLocation;
            this.classifiers = classifiers;
            this.mainArtifacts = mainArtifacts;
            this.artifactTypesOpt = artifactTypesOpt;
            Product.$init$(this);
        }
    }
}

