/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util.url;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.ivy.util.Credentials;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    private Authenticator original;
    private static boolean securityWarningLogged = false;

    private IvyAuthenticator(Authenticator authenticator) {
        this.original = authenticator;
    }

    public static void install() {
        block3: {
            Authenticator authenticator = IvyAuthenticator.getOriginalAuthenticator();
            if (!(authenticator instanceof IvyAuthenticator)) {
                try {
                    Authenticator.setDefault(new IvyAuthenticator(authenticator));
                    return;
                }
                catch (SecurityException securityException) {
                    if (securityWarningLogged) break block3;
                    securityWarningLogged = true;
                    Message.warn("Not enough permissions to set the IvyAuthenticator. HTTP(S) authentication will be disabled!");
                }
            }
        }
    }

    @Override
    protected final PasswordAuthentication getPasswordAuthentication() {
        Object object = null;
        if (this.isProxyAuthentication()) {
            String string = System.getProperty("http.proxyUser");
            if (string != null && string.trim().length() > 0) {
                object = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + string + "]");
                object = new PasswordAuthentication(string, ((String)object).toCharArray());
            }
        } else {
            Credentials credentials = CredentialsStore.INSTANCE.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + credentials + "'");
            if (credentials == null) {
                credentials = CredentialsStore.INSTANCE.getCredentials(null, this.getRequestingHost());
                Message.debug("authentication: k='" + Credentials.buildKey(null, this.getRequestingHost()) + "' c='" + credentials + "'");
            }
            if (credentials != null) {
                object = credentials.getPasswd() == null ? "" : credentials.getPasswd();
                object = new PasswordAuthentication(credentials.getUserName(), ((String)object).toCharArray());
            }
        }
        if (object == null && this.original != null) {
            Authenticator.setDefault(this.original);
            try {
                object = Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme());
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return object;
    }

    private boolean isProxyAuthentication() {
        try {
            Method method = Authenticator.class.getDeclaredMethod("getRequestorType", null);
            Object object = method.invoke((Object)this, null);
            return "PROXY".equals(String.valueOf(object));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Throwable throwable) {
            Message.debug("Error occurred while checking if the authentication request is for the proxy server: " + throwable.getMessage());
        }
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if ("getHttpProxyAuthentication".equals(stackTraceElementArray[i].getMethodName())) {
                return true;
            }
            if (!"getServerAuthentication".equals(stackTraceElementArray[i].getMethodName())) continue;
            return false;
        }
        String string = System.getProperty("http.proxyHost");
        return this.getRequestingHost().equals(string);
    }

    private static Authenticator getOriginalAuthenticator() {
        if (IvyAuthenticator.isJavaVersion9Plus()) {
            return IvyAuthenticator.getDefaultAuthenticator();
        }
        return IvyAuthenticator.getTheAuthenticator();
    }

    private static Authenticator getTheAuthenticator() {
        try {
            Field field = Authenticator.class.getDeclaredField("theAuthenticator");
            field.setAccessible(true);
            return (Authenticator)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            NoSuchFieldException noSuchFieldException2 = noSuchFieldException;
            IvyAuthenticator.handleReflectionException(noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException illegalAccessException2 = illegalAccessException;
            IvyAuthenticator.handleReflectionException(illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            IvyAuthenticator.handleReflectionException0(runtimeException);
        }
        return null;
    }

    private static Authenticator getDefaultAuthenticator() {
        try {
            Method method = Authenticator.class.getDeclaredMethod("getDefault", new Class[0]);
            return (Authenticator)method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NoSuchMethodException noSuchMethodException2 = noSuchMethodException;
            IvyAuthenticator.handleReflectionException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            IvyAuthenticator.handleReflectionException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException illegalAccessException2 = illegalAccessException;
            IvyAuthenticator.handleReflectionException(illegalAccessException);
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            IvyAuthenticator.handleReflectionException0(runtimeException);
        }
        return null;
    }

    private static void handleReflectionException0(RuntimeException throwable) {
        try {
            throw throwable;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
            IvyAuthenticator.handleReflectionException(securityException);
            return;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            throwable = exceptionInInitializerError;
            IvyAuthenticator.handleReflectionException(exceptionInInitializerError);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throwable = illegalArgumentException;
            IvyAuthenticator.handleReflectionException(illegalArgumentException);
            return;
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
            IvyAuthenticator.handleReflectionException(classCastException);
            return;
        }
        catch (NullPointerException nullPointerException) {
            throwable = nullPointerException;
            IvyAuthenticator.handleReflectionException(nullPointerException);
            return;
        }
    }

    private static void handleReflectionException(Throwable throwable) {
        Message.debug("Error occurred while getting the original authenticator: " + throwable.getMessage());
    }

    private static boolean isJavaVersion9Plus() {
        return IvyAuthenticator.getJavaVersion() > 8;
    }

    private static int getJavaVersion() {
        String[] stringArray = System.getProperty("java.specification.version").split("\\.");
        int n = Integer.parseInt(stringArray[0]);
        if (n == 1) {
            return Integer.parseInt(stringArray[1]);
        }
        return n;
    }
}

