/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHelper {
    private static boolean canUseSchemaValidation = true;

    private static SAXParser newSAXParser(URL uRL, InputStream inputStream) throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(canUseSchemaValidation && uRL != null);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        if (canUseSchemaValidation && uRL != null) {
            try {
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                sAXParser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", inputStream);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                System.err.println("WARNING: problem while setting JAXP validating property on SAXParser... XML validation will not be done: " + sAXNotRecognizedException.getMessage());
                canUseSchemaValidation = false;
                sAXParserFactory.setValidating(false);
                sAXParser = sAXParserFactory.newSAXParser();
            }
        }
        sAXParser.getXMLReader().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        return sAXParser;
    }

    public static String toSystemId(URL uRL) {
        try {
            return new URI(uRL.toExternalForm()).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
    }

    public static void parse(URL uRL, URL uRL2, DefaultHandler defaultHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(uRL, uRL2, defaultHandler, null);
    }

    public static void parse(URL uRL, URL uRL2, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(XMLHelper.toSystemId(uRL));
            XMLHelper.parse(inputSource, uRL2, defaultHandler, lexicalHandler);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void parse(InputStream inputStream, URL uRL, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(new InputSource(inputStream), uRL, defaultHandler, lexicalHandler);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void parse(InputSource inputSource, URL object, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = null;
        try {
            if (object != null) {
                inputStream = URLHandlerRegistry.getDefault().openStream((URL)object);
            }
            object = XMLHelper.newSAXParser((URL)object, inputStream);
            if (lexicalHandler != null) {
                try {
                    ((SAXParser)object).setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                }
                catch (SAXException sAXException) {
                    System.err.println("WARNING: problem while setting the lexical handler property on SAXParser: " + sAXException.getMessage());
                }
            }
            ((SAXParser)object).parse(inputSource, defaultHandler);
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static String escape(String object) {
        if (object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(((String)object).length());
        object = ((String)object).toCharArray();
        block6: for (int i = 0; i < ((Object)object).length; ++i) {
            switch (object[i]) {
                case 38: {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case 60: {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case 39: {
                    stringBuffer.append("&apos;");
                    continue block6;
                }
                case 34: {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append((char)object[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Document parseToDom(InputSource inputSource, EntityResolver object) throws IOException, SAXException {
        object = XMLHelper.getDocBuilder((EntityResolver)object);
        return ((DocumentBuilder)object).parse(inputSource);
    }

    public static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        try {
            Object object = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object).setValidating(false);
            object = ((DocumentBuilderFactory)object).newDocumentBuilder();
            if (entityResolver != null) {
                ((DocumentBuilder)object).setEntityResolver(entityResolver);
            }
            return object;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }
}

