/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.File;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.StringUtils;

public class Configurator {
    private FileResolver fileResolver = FileResolver.DEFAULT;
    private Map typedefs = new HashMap();
    private Map macrodefs = new HashMap();
    private Stack objectStack = new Stack();
    private static final List TRUE_VALUES = Arrays.asList("true", "yes", "on");

    public void typeDef(String string, Class clazz) {
        this.typedefs.put(string, clazz);
    }

    public void setRoot(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.objectStack.clear();
        this.setCurrent(object, null);
    }

    public void clear() {
        this.objectStack.clear();
    }

    private void setCurrent(Object object, String string) {
        this.objectStack.push(new ObjectDescriptor(object, string));
    }

    public Object startCreateChild(String object) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        Object object2 = (ObjectDescriptor)this.objectStack.peek();
        Object object3 = ((ObjectDescriptor)object2).getObject();
        if (object3 instanceof MacroDef && !"attribute".equals(object) && !"element".equals(object)) {
            object2 = ((MacroDef)object3).recordCreateChild((String)object);
            this.setCurrent(object2, (String)object);
            return object2;
        }
        if (object3 instanceof Macro) {
            object2 = ((Macro)object3).recordCreateChild((String)object);
            this.setCurrent(object2, (String)object);
            return object2;
        }
        if (object3 instanceof MacroRecord) {
            object2 = ((MacroRecord)object3).recordChild((String)object);
            this.setCurrent(object2, (String)object);
            return object2;
        }
        Class<?> clazz = (MacroDef)this.macrodefs.get(object);
        if (clazz != null) {
            clazz = ((MacroDef)((Object)clazz)).createMacro();
            this.setCurrent(clazz, (String)object);
            return clazz;
        }
        clazz = (Class)this.typedefs.get(object);
        try {
            if (clazz != null) {
                return this.addChild((ObjectDescriptor)object2, clazz, (String)object, null);
            }
            Method method = ((ObjectDescriptor)object2).getCreateMethod((String)object);
            if (method != null) {
                object2 = method.invoke(object3, new Object[0]);
                this.setCurrent(object2, (String)object);
                return object2;
            }
            method = ((ObjectDescriptor)object2).getAddMethod((String)object);
            if (method != null) {
                clazz = method.getParameterTypes()[0];
                object2 = clazz.newInstance();
                method.invoke(object3, object2);
                this.setCurrent(object2, (String)object);
                return object2;
            }
            method = ((ObjectDescriptor)object2).getAddConfiguredMethod((String)object);
            if (method != null) {
                clazz = method.getParameterTypes()[0];
                object2 = Map.class == clazz ? new HashMap() : clazz.newInstance();
                this.setCurrent(object2, (String)object);
                return object2;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("no default constructor on " + clazz + " for adding " + (String)object + " on " + object3.getClass());
        }
        catch (Exception exception) {
            object = new IllegalArgumentException("bad method found for " + (String)object + " on " + object3.getClass());
            ((Throwable)object).initCause(exception);
            throw object;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + (String)object + " on " + object3.getClass());
    }

    public void addChild(String object, Object object2) {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before creating child");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        try {
            this.addChild(objectDescriptor, object2.getClass(), (String)object, object2);
            return;
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("no default constructor on " + object2.getClass() + " for adding " + (String)object + " on " + objectDescriptor.getObject().getClass());
        }
        catch (Exception exception) {
            object = new IllegalArgumentException("bad method found for " + (String)object + " on " + objectDescriptor.getObject().getClass());
            ((Throwable)object).initCause(exception);
            throw object;
        }
    }

    private Object addChild(ObjectDescriptor object, Class clazz, String string, Object hashMap) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object object2 = ((ObjectDescriptor)object).getObject();
        if (object2 instanceof MacroRecord) {
            MacroRecord macroRecord = (MacroRecord)object2;
            object = macroRecord.recordChild(string, hashMap);
            this.setCurrent(object, string);
            return object;
        }
        Method method = ((ObjectDescriptor)object).getAddMethod(clazz);
        if (method != null) {
            if (hashMap == null) {
                hashMap = clazz.newInstance();
            }
            method.invoke(object2, hashMap);
            this.setCurrent(hashMap, string);
            return hashMap;
        }
        method = ((ObjectDescriptor)object).getAddConfiguredMethod(clazz);
        if (method != null) {
            if (hashMap == null) {
                hashMap = Map.class == clazz ? new HashMap() : clazz.newInstance();
            }
            this.setCurrent(hashMap, string);
            return hashMap;
        }
        throw new IllegalArgumentException("no appropriate method found for adding " + string + " on " + object2.getClass());
    }

    public void setAttribute(String object, String string) {
        Object object2;
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before setting attribute");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.peek();
        if (objectDescriptor.getObject() instanceof Macro) {
            ((Macro)objectDescriptor.getObject()).defineAttribute((String)object, string);
            return;
        }
        if (objectDescriptor.getObject() instanceof MacroRecord) {
            ((MacroRecord)objectDescriptor.getObject()).recordAttribute((String)object, string);
            return;
        }
        Method method = objectDescriptor.getSetMethod((String)object);
        if (method == null) {
            if (objectDescriptor.getObject() instanceof Map) {
                ((Map)objectDescriptor.getObject()).put(object, string);
                return;
            }
            throw new IllegalArgumentException("no set method found for " + (String)object + " on " + objectDescriptor.getObject().getClass());
        }
        Class<?> clazz = method.getParameterTypes()[0];
        try {
            object2 = clazz.equals(String.class) ? string : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? Boolean.valueOf(TRUE_VALUES.contains(string)) : (clazz.equals(Character.class) || clazz.equals(Character.TYPE) ? new Character(string.length() > 0 ? string.charAt(0) : (char)' ') : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? Short.valueOf(string) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? Integer.valueOf(string) : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? Long.valueOf(string) : (clazz.equals(Class.class) ? Class.forName(string) : (clazz.equals(File.class) ? this.fileResolver.resolveFile(string, objectDescriptor.getObjectName() + "." + (String)object) : clazz.getConstructor(String.class).newInstance(string))))))));
        }
        catch (Exception exception) {
            object = new IllegalArgumentException("impossible to convert " + string + " to " + clazz + " for setting " + (String)object + " on " + objectDescriptor.getObject().getClass() + ": " + exception.getMessage());
            ((Throwable)object).initCause(exception);
            throw object;
        }
        try {
            method.invoke(objectDescriptor.getObject(), object2);
            return;
        }
        catch (Exception exception) {
            object = new IllegalArgumentException("impossible to set " + (String)object + " to " + object2 + " on " + objectDescriptor.getObject().getClass());
            ((Throwable)object).initCause(exception);
            throw object;
        }
    }

    public Object endCreateChild() {
        if (this.objectStack.isEmpty()) {
            throw new IllegalStateException("set root before ending child");
        }
        ObjectDescriptor objectDescriptor = (ObjectDescriptor)this.objectStack.pop();
        if (this.objectStack.isEmpty()) {
            this.objectStack.push(objectDescriptor);
            throw new IllegalStateException("cannot end root");
        }
        if (objectDescriptor.getObject() instanceof Macro) {
            return ((Macro)objectDescriptor.getObject()).play(this);
        }
        Object object = (ObjectDescriptor)this.objectStack.peek();
        String string = objectDescriptor.getObjectName();
        GenericDeclaration genericDeclaration = (Class)this.typedefs.get(string);
        genericDeclaration = genericDeclaration != null ? ((ObjectDescriptor)object).getAddConfiguredMethod((Class)genericDeclaration) : ((ObjectDescriptor)object).getAddConfiguredMethod(string);
        try {
            if (genericDeclaration != null) {
                ((Method)genericDeclaration).invoke(((ObjectDescriptor)object).getObject(), objectDescriptor.getObject());
            }
            return objectDescriptor.getObject();
        }
        catch (Exception exception) {
            object = new IllegalArgumentException("impossible to add configured child for " + string + " on " + ((ObjectDescriptor)object).getObject().getClass() + ": " + StringUtils.getErrorMessage(exception));
            ((Throwable)object).initCause(exception);
            throw object;
        }
    }

    public Object getCurrent() {
        if (this.objectStack.isEmpty()) {
            return null;
        }
        return ((ObjectDescriptor)this.objectStack.peek()).getObject();
    }

    public int getDepth() {
        return this.objectStack.size();
    }

    public MacroDef startMacroDef(String string) {
        MacroDef macroDef = new MacroDef(string);
        this.setCurrent(macroDef, string);
        return macroDef;
    }

    public void endMacroDef() {
        Configurator configurator = this;
        configurator.addConfiguredMacrodef((MacroDef)configurator.getCurrent());
        this.objectStack.pop();
    }

    public void addConfiguredMacrodef(MacroDef macroDef) {
        this.macrodefs.put(macroDef.getName(), macroDef);
    }

    public Class getTypeDef(String string) {
        return (Class)this.typedefs.get(string);
    }

    public void setFileResolver(FileResolver fileResolver) {
        Checks.checkNotNull(fileResolver, "fileResolver");
        this.fileResolver = fileResolver;
    }

    private static class ObjectDescriptor {
        private Object obj;
        private String objName;
        private Map createMethods = new HashMap();
        private Map addMethods = new HashMap();
        private Map addConfiguredMethods = new HashMap();
        private Map setMethods = new HashMap();
        private Map typeAddMethods = new HashMap();
        private Map typeAddConfiguredMethods = new HashMap();

        public ObjectDescriptor(Object methodArray, String string) {
            this.obj = methodArray;
            this.objName = string;
            methodArray = methodArray.getClass().getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                String string2;
                Method method = methodArray[i];
                if (method.getName().startsWith("create") && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring(6));
                    if (string2.length() == 0) continue;
                    this.addCreateMethod(string2, method);
                    continue;
                }
                if (method.getName().startsWith("addConfigured") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring(13));
                    if (string2.length() == 0) {
                        this.addAddConfiguredMethod(method);
                    }
                    this.addAddConfiguredMethod(string2, method);
                    continue;
                }
                if (method.getName().startsWith("add") && !method.getName().startsWith("addConfigured") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType())) {
                    string2 = StringUtils.uncapitalize(method.getName().substring(3));
                    if (string2.length() == 0) {
                        this.addAddMethod(method);
                    }
                    this.addAddMethod(string2, method);
                    continue;
                }
                if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1 || !Void.TYPE.equals(method.getReturnType()) || (string2 = StringUtils.uncapitalize(method.getName().substring(3))).length() == 0) continue;
                this.addSetMethod(string2, method);
            }
        }

        public void addCreateMethod(String string, Method method) {
            this.createMethods.put(string, method);
        }

        public void addAddMethod(String string, Method method) {
            this.addMethods.put(string, method);
        }

        public void addAddConfiguredMethod(String string, Method method) {
            this.addConfiguredMethods.put(string, method);
        }

        private void addAddMethod(Method method) {
            this.typeAddMethods.put(method.getParameterTypes()[0], method);
        }

        private void addAddConfiguredMethod(Method method) {
            this.typeAddConfiguredMethods.put(method.getParameterTypes()[0], method);
        }

        public void addSetMethod(String string, Method method) {
            Method method2 = (Method)this.setMethods.get(string);
            if (method2 != null && method2.getParameterTypes()[0] == String.class) {
                return;
            }
            this.setMethods.put(string, method);
        }

        public Object getObject() {
            return this.obj;
        }

        public Method getCreateMethod(String string) {
            return (Method)this.createMethods.get(string);
        }

        public Method getAddMethod(String string) {
            return (Method)this.addMethods.get(string);
        }

        public Method getAddConfiguredMethod(String string) {
            return (Method)this.addConfiguredMethods.get(string);
        }

        public Method getAddMethod(Class clazz) {
            return this.getTypeMatchingMethod(clazz, this.typeAddMethods);
        }

        public Method getAddConfiguredMethod(Class clazz) {
            return this.getTypeMatchingMethod(clazz, this.typeAddConfiguredMethods);
        }

        private Method getTypeMatchingMethod(Class clazz, Map map) {
            Method method = (Method)map.get(clazz);
            if (method != null) {
                return method;
            }
            for (Class clazz2 : map.keySet()) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return (Method)map.get(clazz2);
            }
            return null;
        }

        public Method getSetMethod(String string) {
            return (Method)this.setMethods.get(string);
        }

        public String getObjectName() {
            return this.objName;
        }
    }

    public static class MacroDef {
        private String name;
        private Map attributes = new HashMap();
        private Map elements = new HashMap();
        private MacroRecord macroRecord;

        public MacroDef(String string) {
            this.name = string;
        }

        public Attribute getAttribute(String string) {
            return (Attribute)this.attributes.get(string);
        }

        public Object play(Configurator configurator, Map map, Map map2) {
            for (Attribute attribute : this.attributes.values()) {
                String string = (String)map.get(attribute.getName());
                if (string != null) continue;
                if (attribute.getDefault() == null) {
                    throw new IllegalArgumentException("attribute " + attribute.getName() + " is required in " + this.getName());
                }
                map.put(attribute.getName(), attribute.getDefault());
            }
            return this.play(configurator, this.macroRecord, map, map2);
        }

        private Object play(Configurator configurator, MacroRecord object, Map map, Map map2) {
            Object object2;
            if (((MacroRecord)object).getObject() != null) {
                configurator.addChild(((MacroRecord)object).getName(), ((MacroRecord)object).getObject());
                configurator.endCreateChild();
                return ((MacroRecord)object).getObject();
            }
            configurator.startCreateChild(((MacroRecord)object).getName());
            Iterator iterator = ((MacroRecord)object).getAttributes();
            for (Object object32 : iterator.keySet()) {
                object2 = this.replaceParam((String)iterator.get(object32), map);
                configurator.setAttribute((String)object32, (String)object2);
            }
            for (Object object32 : ((MacroRecord)object).getChildren()) {
                object2 = (Element)this.elements.get(((MacroRecord)object32).getName());
                if (object2 != null) {
                    object = (List)map2.get(((MacroRecord)object32).getName());
                    if (object != null) {
                        object = object.iterator();
                        while (object.hasNext()) {
                            iterator = (MacroRecord)object.next();
                            for (Object object32 : ((MacroRecord)((Object)iterator)).getChildren()) {
                                this.play(configurator, (MacroRecord)object32, map, Collections.EMPTY_MAP);
                            }
                        }
                        continue;
                    }
                    if (((Element)object2).isOptional()) continue;
                    throw new IllegalArgumentException("non optional element is not specified: " + ((Element)object2).getName() + " in macro " + this.getName());
                }
                this.play(configurator, (MacroRecord)object32, map, map2);
            }
            return configurator.endCreateChild();
        }

        private String replaceParam(String string, Map map) {
            return IvyPatternHelper.substituteParams(string, map);
        }

        public String getName() {
            return this.name;
        }

        public void addConfiguredAttribute(Attribute attribute) {
            this.attributes.put(attribute.getName(), attribute);
        }

        public Macro createMacro() {
            return new Macro(this);
        }

        public void addAttribute(String string, String string2) {
            Attribute attribute = new Attribute();
            attribute.setName(string);
            attribute.setDefault(string2);
            this.addConfiguredAttribute(attribute);
        }

        public MacroRecord recordCreateChild(String string) {
            this.macroRecord = new MacroRecord(string);
            return this.macroRecord;
        }
    }

    public static class MacroRecord {
        private String name;
        private Map attributes = new LinkedHashMap();
        private List children = new ArrayList();
        private Object object;

        public MacroRecord(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void recordAttribute(String string, String string2) {
            this.attributes.put(string, string2);
        }

        public MacroRecord recordChild(String object) {
            object = new MacroRecord((String)object);
            this.children.add(object);
            return object;
        }

        public MacroRecord recordChild(String object, Object object2) {
            object = this.recordChild((String)object);
            v0.object = object2;
            return object;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public List getChildren() {
            return this.children;
        }

        public Object getObject() {
            return this.object;
        }
    }

    public static class Element {
        private String name;
        private boolean optional = false;

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDefault(String string) {
            this.defaultValue = string;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }
    }

    public static class Macro {
        private MacroDef macrodef;
        private Map attValues = new HashMap();
        private Map macroRecords = new HashMap();

        public Macro(MacroDef macroDef) {
            this.macrodef = macroDef;
        }

        public void defineAttribute(String string, String string2) {
            if (this.macrodef.getAttribute(string) == null) {
                throw new IllegalArgumentException("undeclared attribute " + string + " on macro " + this.macrodef.getName());
            }
            this.attValues.put(string, string2);
        }

        public MacroRecord recordCreateChild(String string) {
            MacroRecord macroRecord = new MacroRecord(string);
            ArrayList<MacroRecord> arrayList = (ArrayList<MacroRecord>)this.macroRecords.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<MacroRecord>();
                this.macroRecords.put(string, arrayList);
            }
            arrayList.add(macroRecord);
            return macroRecord;
        }

        public Object play(Configurator configurator) {
            return this.macrodef.play(configurator, this.attValues, this.macroRecords);
        }
    }
}

