/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;

abstract class Token {
    TokenType type;

    private Token() {
    }

    String tokenType() {
        return this.getClass().getSimpleName();
    }

    abstract Token reset();

    static void reset(StringBuilder sb) {
        if (sb != null) {
            StringBuilder stringBuilder;
            sb.delete(0, stringBuilder.length());
        }
    }

    final boolean isDoctype() {
        return this.type == TokenType.Doctype;
    }

    final Doctype asDoctype() {
        return (Doctype)this;
    }

    final boolean isStartTag() {
        return this.type == TokenType.StartTag;
    }

    final StartTag asStartTag() {
        return (StartTag)this;
    }

    final boolean isEndTag() {
        return this.type == TokenType.EndTag;
    }

    final EndTag asEndTag() {
        return (EndTag)this;
    }

    final boolean isComment() {
        return this.type == TokenType.Comment;
    }

    final Comment asComment() {
        return (Comment)this;
    }

    final boolean isCharacter() {
        return this.type == TokenType.Character;
    }

    final boolean isCData() {
        return this instanceof CData;
    }

    final Character asCharacter() {
        return (Character)this;
    }

    final boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    public static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType Doctype = new TokenType();
        public static final /* enum */ TokenType StartTag = new TokenType();
        public static final /* enum */ TokenType EndTag = new TokenType();
        public static final /* enum */ TokenType Comment = new TokenType();
        public static final /* enum */ TokenType Character = new TokenType();
        public static final /* enum */ TokenType EOF = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        static {
            $VALUES = new TokenType[]{Doctype, StartTag, EndTag, Comment, Character, EOF};
        }
    }

    static final class Doctype
    extends Token {
        final StringBuilder name = new StringBuilder();
        String pubSysKey = null;
        final StringBuilder publicIdentifier = new StringBuilder();
        final StringBuilder systemIdentifier = new StringBuilder();
        boolean forceQuirks = false;

        Doctype() {
            this.type = TokenType.Doctype;
        }

        @Override
        final Token reset() {
            Doctype.reset(this.name);
            this.pubSysKey = null;
            Doctype.reset(this.publicIdentifier);
            Doctype.reset(this.systemIdentifier);
            this.forceQuirks = false;
            return this;
        }

        final String getName() {
            return this.name.toString();
        }

        final String getPubSysKey() {
            return this.pubSysKey;
        }

        final String getPublicIdentifier() {
            return this.publicIdentifier.toString();
        }

        public final String getSystemIdentifier() {
            return this.systemIdentifier.toString();
        }

        public final boolean isForceQuirks() {
            return this.forceQuirks;
        }
    }

    static final class StartTag
    extends Tag {
        StartTag() {
            this.type = TokenType.StartTag;
        }

        @Override
        final Tag reset() {
            super.reset();
            this.attributes = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final StartTag nameAttr(String name, Attributes attributes) {
            void var2_2;
            void var1_1;
            this.tagName = var1_1;
            this.attributes = var2_2;
            this.normalName = Normalizer.lowerCase(this.tagName);
            return this;
        }

        public final String toString() {
            if (this.attributes != null && this.attributes.size() > 0) {
                return "<" + this.name() + " " + this.attributes.toString() + ">";
            }
            return "<" + this.name() + ">";
        }
    }

    static final class EndTag
    extends Tag {
        EndTag() {
            this.type = TokenType.EndTag;
        }

        public final String toString() {
            return "</" + (this.tagName != null ? this.tagName : "(unset)") + ">";
        }
    }

    static final class Comment
    extends Token {
        private final StringBuilder data = new StringBuilder();
        private String dataS;
        boolean bogus = false;

        @Override
        final Token reset() {
            Comment.reset(this.data);
            this.dataS = null;
            this.bogus = false;
            return this;
        }

        Comment() {
            this.type = TokenType.Comment;
        }

        final String getData() {
            if (this.dataS != null) {
                return this.dataS;
            }
            return this.data.toString();
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(String append) {
            this.ensureData();
            if (this.data.length() == 0) {
                this.dataS = append;
            } else {
                void var1_1;
                this.data.append((String)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(char append) {
            void var1_1;
            this.ensureData();
            this.data.append((char)var1_1);
            return this;
        }

        private void ensureData() {
            if (this.dataS != null) {
                this.data.append(this.dataS);
                this.dataS = null;
            }
        }

        public final String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    static final class CData
    extends Character {
        /*
         * WARNING - void declaration
         */
        CData(String data) {
            void var1_1;
            this.data((String)var1_1);
        }

        @Override
        public final String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    static class Character
    extends Token {
        private String data;

        Character() {
            this.type = TokenType.Character;
        }

        @Override
        Token reset() {
            this.data = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Character data(String data) {
            void var1_1;
            this.data = var1_1;
            return this;
        }

        String getData() {
            return this.data;
        }

        public String toString() {
            return this.getData();
        }
    }

    static final class EOF
    extends Token {
        EOF() {
            this.type = TokenType.EOF;
        }

        @Override
        final Token reset() {
            return this;
        }
    }

    static abstract class Tag
    extends Token {
        protected String tagName;
        protected String normalName;
        private String pendingAttributeName;
        private StringBuilder pendingAttributeValue = new StringBuilder();
        private String pendingAttributeValueS;
        private boolean hasEmptyAttributeValue = false;
        private boolean hasPendingAttributeValue = false;
        boolean selfClosing = false;
        Attributes attributes;

        Tag() {
        }

        @Override
        Tag reset() {
            this.tagName = null;
            this.normalName = null;
            this.pendingAttributeName = null;
            Tag.reset(this.pendingAttributeValue);
            this.pendingAttributeValueS = null;
            this.hasEmptyAttributeValue = false;
            this.hasPendingAttributeValue = false;
            this.selfClosing = false;
            this.attributes = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final void newAttribute() {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (this.pendingAttributeName != null) {
                this.pendingAttributeName = this.pendingAttributeName.trim();
                if (this.pendingAttributeName.length() > 0) {
                    void var1_1;
                    String value = this.hasPendingAttributeValue ? (this.pendingAttributeValue.length() > 0 ? this.pendingAttributeValue.toString() : this.pendingAttributeValueS) : (this.hasEmptyAttributeValue ? "" : null);
                    this.attributes.add(this.pendingAttributeName, (String)var1_1);
                }
            }
            this.pendingAttributeName = null;
            this.hasEmptyAttributeValue = false;
            this.hasPendingAttributeValue = false;
            Tag.reset(this.pendingAttributeValue);
            this.pendingAttributeValueS = null;
        }

        final void finaliseTag() {
            if (this.pendingAttributeName != null) {
                this.newAttribute();
            }
        }

        final String name() {
            Validate.isFalse(this.tagName == null || this.tagName.length() == 0);
            return this.tagName;
        }

        final String normalName() {
            return this.normalName;
        }

        /*
         * WARNING - void declaration
         */
        final Tag name(String name) {
            void var1_1;
            this.tagName = name;
            this.normalName = Normalizer.lowerCase((String)var1_1);
            return this;
        }

        final boolean isSelfClosing() {
            return this.selfClosing;
        }

        final Attributes getAttributes() {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            return this.attributes;
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(String append) {
            void var1_1;
            this.tagName = this.tagName == null ? append : this.tagName.concat((String)var1_1);
            this.normalName = Normalizer.lowerCase(this.tagName);
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(char append) {
            void var1_1;
            this.appendTagName(String.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(String append) {
            void var1_1;
            this.pendingAttributeName = this.pendingAttributeName == null ? append : this.pendingAttributeName.concat((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(char append) {
            void var1_1;
            this.appendAttributeName(String.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(String append) {
            void var1_1;
            this.ensureAttributeValue();
            if (this.pendingAttributeValue.length() == 0) {
                this.pendingAttributeValueS = append;
                return;
            }
            this.pendingAttributeValue.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(char append) {
            void var1_1;
            this.ensureAttributeValue();
            this.pendingAttributeValue.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(int[] appendCodepoints) {
            void var1_1;
            this.ensureAttributeValue();
            for (void codepoint : var1_1) {
                this.pendingAttributeValue.appendCodePoint((int)codepoint);
            }
        }

        final void setEmptyAttributeValue() {
            this.hasEmptyAttributeValue = true;
        }

        private void ensureAttributeValue() {
            this.hasPendingAttributeValue = true;
            if (this.pendingAttributeValueS != null) {
                this.pendingAttributeValue.append(this.pendingAttributeValueS);
                this.pendingAttributeValueS = null;
            }
        }
    }
}

