/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.sort.ModuleDescriptorSorter;
import org.apache.ivy.core.sort.SortEngineSettings;
import org.apache.ivy.core.sort.SortOptions;
import org.apache.ivy.plugins.circular.CircularDependencyException;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.circular.IgnoreCircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;

public class SortEngine {
    private SortEngineSettings settings;

    public SortEngine(SortEngineSettings sortEngineSettings) {
        if (sortEngineSettings == null) {
            throw new NullPointerException("SortEngine.settings can not be null");
        }
        this.settings = sortEngineSettings;
    }

    public List sortNodes(Collection object, SortOptions object2) {
        ArrayList<IvyNode> arrayList;
        LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>> linkedHashMap = new LinkedHashMap<ModuleDescriptor, ArrayList<IvyNode>>();
        ArrayList<IvyNode> arrayList2 = new ArrayList<IvyNode>();
        object = object.iterator();
        while (object.hasNext()) {
            IvyNode ivyNode = (IvyNode)object.next();
            if (ivyNode.getDescriptor() == null) {
                arrayList2.add(ivyNode);
                continue;
            }
            arrayList = (ArrayList<IvyNode>)linkedHashMap.get(ivyNode.getDescriptor());
            if (arrayList == null) {
                arrayList = new ArrayList<IvyNode>();
                linkedHashMap.put(ivyNode.getDescriptor(), arrayList);
            }
            arrayList.add(ivyNode);
        }
        object = this.sortModuleDescriptors(linkedHashMap.keySet(), (SortOptions)object2);
        object2 = new ArrayList((int)((double)object.size() * 1.3 + (double)arrayList2.size()));
        for (int i = 0; i < object.size(); ++i) {
            arrayList = (ModuleDescriptor)object.get(i);
            arrayList = (List)linkedHashMap.get(arrayList);
            object2.addAll(arrayList);
        }
        object2.addAll(0, arrayList2);
        return object2;
    }

    public List sortModuleDescriptors(Collection object, SortOptions sortOptions) throws CircularDependencyException {
        Checks.checkNotNull(sortOptions, "options");
        object = new ModuleDescriptorSorter((Collection)object, this.getVersionMatcher(), sortOptions.getNonMatchingVersionReporter(), sortOptions.isUseCircularDependencyStrategy() ? this.getCircularStrategy() : IgnoreCircularDependencyStrategy.getInstance());
        return ((ModuleDescriptorSorter)object).sortModuleDescriptors();
    }

    protected CircularDependencyStrategy getCircularStrategy() {
        return this.settings.getCircularDependencyStrategy();
    }

    protected VersionMatcher getVersionMatcher() {
        return this.settings.getVersionMatcher();
    }
}

