# coding: utf-8

"""
    NetHSM
    All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.   # noqa: E501
    The version of the OpenAPI document: v1
    Generated by: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator
"""

from __future__ import annotations
from nethsm.client.shared_imports.schema_imports import *  # pyright: ignore [reportWildcardImportFromLibrary]

SystemTime: typing_extensions.TypeAlias = schemas.DateTimeSchema
BackupFile: typing_extensions.TypeAlias = schemas.BinarySchema

from nethsm.client.components.schema import passphrase
Properties = typing.TypedDict(
    'Properties',
    {
        "backupPassphrase": typing.Type[passphrase.Passphrase],
        "systemTime": typing.Type[SystemTime],
    }
)


class ArgumentsDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "backupPassphrase",
        "systemTime",
    })
    
    def __new__(
        cls,
        *,
        backupPassphrase: typing.Union[
            str,
            schemas.Unset
        ] = schemas.unset,
        systemTime: typing.Union[
            str,
            datetime.datetime,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("backupPassphrase", backupPassphrase),
            ("systemTime", systemTime),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(ArgumentsDictInput, arg_)
        return Arguments.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ArgumentsDict:
        return Arguments.validate(arg, configuration=configuration)
    
    @property
    def backupPassphrase(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("backupPassphrase", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    @property
    def systemTime(self) -> typing.Union[str, schemas.Unset]:
        val = self.get("systemTime", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            str,
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
ArgumentsDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class Arguments(
    schemas.Schema[ArgumentsDict, tuple]
):
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: ArgumentsDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> ArgumentsDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

Properties2 = typing.TypedDict(
    'Properties2',
    {
        "arguments": typing.Type[Arguments],
        "backup_file": typing.Type[BackupFile],
    }
)


class RestoreRequestDict(schemas.immutabledict[str, schemas.OUTPUT_BASE_TYPES]):

    __required_keys__: typing.FrozenSet[str] = frozenset({
    })
    __optional_keys__: typing.FrozenSet[str] = frozenset({
        "arguments",
        "backup_file",
    })
    
    def __new__(
        cls,
        *,
        arguments: typing.Union[
            ArgumentsDictInput,
            ArgumentsDict,
            schemas.Unset
        ] = schemas.unset,
        backup_file: typing.Union[
            bytes,
            io.FileIO,
            io.BufferedReader,
            schemas.FileIO,
            schemas.Unset
        ] = schemas.unset,
        configuration_: typing.Optional[schema_configuration.SchemaConfiguration] = None,
        **kwargs: schemas.INPUT_TYPES_ALL,
    ):
        arg_: typing.Dict[str, typing.Any] = {}
        for key_, val in (
            ("arguments", arguments),
            ("backup_file", backup_file),
        ):
            if isinstance(val, schemas.Unset):
                continue
            arg_[key_] = val
        arg_.update(kwargs)
        used_arg_ = typing.cast(RestoreRequestDictInput, arg_)
        return RestoreRequest.validate(used_arg_, configuration=configuration_)
    
    @staticmethod
    def from_dict_(
        arg: typing.Union[
            RestoreRequestDictInput,
            RestoreRequestDict
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> RestoreRequestDict:
        return RestoreRequest.validate(arg, configuration=configuration)
    
    @property
    def arguments(self) -> typing.Union[ArgumentsDict, schemas.Unset]:
        val = self.get("arguments", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            ArgumentsDict,
            val
        )
    
    @property
    def backup_file(self) -> typing.Union[bytes, schemas.FileIO, schemas.Unset]:
        val = self.get("backup_file", schemas.unset)
        if isinstance(val, schemas.Unset):
            return val
        return typing.cast(
            typing.Union[bytes, schemas.FileIO],
            val
        )
    
    def get_additional_property_(self, name: str) -> typing.Union[schemas.OUTPUT_BASE_TYPES, schemas.Unset]:
        schemas.raise_if_key_known(name, self.__required_keys__, self.__optional_keys__)
        return self.get(name, schemas.unset)
RestoreRequestDictInput = typing.Mapping[str, schemas.INPUT_TYPES_ALL]


@dataclasses.dataclass(frozen=True)
class RestoreRequest(
    schemas.Schema[RestoreRequestDict, tuple]
):
    """NOTE: This class is auto generated by OpenAPI JSON Schema Generator.
    Ref: https://github.com/openapi-json-schema-tools/openapi-json-schema-generator

    Do not edit the class manually.
    """
    types: typing.FrozenSet[typing.Type] = frozenset({schemas.immutabledict})
    properties: Properties2 = dataclasses.field(default_factory=lambda: schemas.typed_dict_to_instance(Properties2)) # type: ignore
    type_to_output_cls: typing.Mapping[
        typing.Type,
        typing.Type
    ] = dataclasses.field(
        default_factory=lambda: {
            schemas.immutabledict: RestoreRequestDict
        }
    )

    @classmethod
    def validate(
        cls,
        arg: typing.Union[
            RestoreRequestDictInput,
            RestoreRequestDict,
        ],
        configuration: typing.Optional[schema_configuration.SchemaConfiguration] = None
    ) -> RestoreRequestDict:
        return super().validate_base(
            arg,
            configuration=configuration,
        )

