# Generated by Django 1.9.9 on 2016-09-18 17:52
import datetime

from django.conf import settings
import django.contrib.auth.models
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone

import guardian.mixins


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="CustomUser",
            fields=[
                ("password", models.CharField(max_length=128, verbose_name="password")),
                ("last_login", models.DateTimeField(blank=True, null=True, verbose_name="last login")),
                (
                    "is_superuser",
                    models.BooleanField(
                        default=False,
                        help_text="Designates that this user has all permissions without explicitly assigning them.",
                        verbose_name="superuser status",
                    ),
                ),
                (
                    "username",
                    models.CharField(
                        error_messages={"unique": "A user with that username already exists."},
                        help_text="Required. 30 characters or fewer. Letters, digits and @/./+/-/_ only.",
                        max_length=30,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^[\\w.@+-]+$",
                                "Enter a valid username. This value may contain only letters, numbers and @/./+/-/_ characters.",
                            )
                        ],
                        verbose_name="username",
                    ),
                ),
                ("first_name", models.CharField(blank=True, max_length=30, verbose_name="first name")),
                ("last_name", models.CharField(blank=True, max_length=30, verbose_name="last name")),
                ("email", models.EmailField(blank=True, max_length=254, verbose_name="email address")),
                (
                    "is_staff",
                    models.BooleanField(
                        default=False,
                        help_text="Designates whether the user can log into this admin site.",
                        verbose_name="staff status",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="active",
                    ),
                ),
                ("date_joined", models.DateTimeField(default=django.utils.timezone.now, verbose_name="date joined")),
                ("custom_id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "groups",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Group",
                        verbose_name="groups",
                    ),
                ),
                (
                    "user_permissions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Specific permissions for this user.",
                        related_name="user_set",
                        related_query_name="user",
                        to="auth.Permission",
                        verbose_name="user permissions",
                    ),
                ),
            ],
            options={
                "abstract": False,
                "verbose_name": "user",
                "verbose_name_plural": "users",
            },
            bases=(models.Model, guardian.mixins.GuardianUserMixin),
            managers=[
                ("objects", django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name="CustomUsernameUser",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                ("last_login", models.DateTimeField(blank=True, null=True, verbose_name="last login")),
                ("email", models.EmailField(max_length=100, unique=True)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model, guardian.mixins.GuardianUserMixin),
        ),
        migrations.CreateModel(
            name="Mixed",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="MixedGroupObjectPermission",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("content_object", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="testapp.Mixed")),
                ("group", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Group")),
                ("permission", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Permission")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="CharPKModel",
            fields=[
                ("char_pk", models.CharField(max_length=128, primary_key=True, serialize=False)),
            ],
        ),
        migrations.CreateModel(
            name="Post",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=64, verbose_name="title")),
            ],
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, unique=True)),
                ("created_at", models.DateTimeField(default=datetime.datetime.now)),
            ],
            options={
                "get_latest_by": "created_at",
            },
        ),
        migrations.CreateModel(
            name="ProjectGroupObjectPermission",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "content_object",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="testapp.Project"),
                ),
                ("group", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Group")),
                ("permission", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Permission")),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ProjectUserObjectPermission",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "content_object",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="testapp.Project"),
                ),
                ("permission", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Permission")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="ReverseMixed",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=128, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name="ReverseMixedUserObjectPermission",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "content_object",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="testapp.ReverseMixed"),
                ),
                ("permission", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="auth.Permission")),
                ("user", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AlterUniqueTogether(
            name="reversemixeduserobjectpermission",
            unique_together={("user", "permission", "content_object")},
        ),
        migrations.AlterUniqueTogether(
            name="projectuserobjectpermission",
            unique_together={("user", "permission", "content_object")},
        ),
        migrations.AlterUniqueTogether(
            name="projectgroupobjectpermission",
            unique_together={("group", "permission", "content_object")},
        ),
        migrations.AlterUniqueTogether(
            name="mixedgroupobjectpermission",
            unique_together={("group", "permission", "content_object")},
        ),
    ]
