/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.p3place;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import org.eclipse.elk.alg.mrtree.TreeLayoutPhases;
import org.eclipse.elk.alg.mrtree.TreeUtil;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class NodePlacer
implements ILayoutPhase<TreeLayoutPhases, TGraph> {
    private static final LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> INTERMEDIATE_PROCESSING_CONFIG = LayoutProcessorConfiguration.create().addBefore(TreeLayoutPhases.P2_NODE_ORDERING, IntermediateProcessorStrategy.ROOT_PROC).before(TreeLayoutPhases.P3_NODE_PLACEMENT).add(IntermediateProcessorStrategy.LEVEL_HEIGHT).add(IntermediateProcessorStrategy.NEIGHBORS_PROC).before(TreeLayoutPhases.P4_EDGE_ROUTING).add(IntermediateProcessorStrategy.DIRECTION_PROC).add(IntermediateProcessorStrategy.NODE_POSITION_PROC);
    private double spacing;
    private double xTopAdjustment = 0.0;
    private double yTopAdjustment = 0.0;
    private Direction direction;

    @Override
    public LayoutProcessorConfiguration<TreeLayoutPhases, TGraph> getLayoutProcessorConfiguration(TGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIG;
    }

    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Processor order nodes", 2.0f);
        this.spacing = tGraph.getProperty(MrTreeOptions.SPACING_NODE_NODE);
        this.direction = tGraph.getProperty(MrTreeOptions.DIRECTION);
        if (this.direction == Direction.UNDEFINED) {
            this.direction = Direction.DOWN;
            tGraph.setProperty(MrTreeOptions.DIRECTION, (Object)this.direction);
        }
        LinkedList<TNode> roots = new LinkedList<TNode>();
        for (TNode tNode : tGraph.getNodes()) {
            if (!tNode.getProperty(InternalProperties.ROOT).booleanValue()) continue;
            roots.add(tNode);
        }
        TNode root = (TNode)roots.getFirst();
        this.firstWalk(root, 0);
        progressMonitor.worked(1.0f);
        this.secondWalk(root, this.yTopAdjustment - root.getProperty(InternalProperties.LEVELHEIGHT) / 2.0, this.xTopAdjustment);
        progressMonitor.worked(1.0f);
        progressMonitor.done();
    }

    private void firstWalk(TNode cN, int level) {
        cN.setProperty(InternalProperties.MODIFIER, (Object)0.0);
        TNode lS = cN.getProperty(InternalProperties.LEFTSIBLING);
        if (cN.isLeaf()) {
            if (lS != null) {
                double p = lS.getProperty(InternalProperties.PRELIM) + this.spacing + this.meanNodeWidth(lS, cN);
                cN.setProperty(InternalProperties.PRELIM, (Object)p);
            } else {
                cN.setProperty(InternalProperties.PRELIM, (Object)0.0);
            }
        } else {
            for (TNode child : cN.getChildren()) {
                this.firstWalk(child, level + 1);
            }
            TNode lM = Iterables.getFirst(cN.getChildren(), null);
            TNode rM = Iterables.getLast(cN.getChildren(), null);
            double midPoint = (rM.getProperty(InternalProperties.PRELIM) + lM.getProperty(InternalProperties.PRELIM)) / 2.0;
            if (lS != null) {
                double p = lS.getProperty(InternalProperties.PRELIM) + this.spacing + this.meanNodeWidth(lS, cN);
                cN.setProperty(InternalProperties.PRELIM, (Object)p);
                cN.setProperty(InternalProperties.MODIFIER, (Object)(cN.getProperty(InternalProperties.PRELIM) - midPoint));
                this.apportion(cN, level);
            } else {
                cN.setProperty(InternalProperties.PRELIM, (Object)midPoint);
            }
        }
    }

    private void apportion(TNode cN, int level) {
        TNode leftmost = Iterables.getFirst(cN.getChildren(), null);
        TNode neighbor = leftmost != null ? leftmost.getProperty(InternalProperties.LEFTNEIGHBOR) : null;
        int compareDepth = 1;
        while (leftmost != null && neighbor != null) {
            double leftModSum = 0.0;
            double rightModSum = 0.0;
            TNode ancestorLeftmost = leftmost;
            TNode ancestorNeighbor = neighbor;
            int i = 0;
            while (i < compareDepth) {
                ancestorLeftmost = ancestorLeftmost.getParent();
                ancestorNeighbor = ancestorNeighbor.getParent();
                rightModSum += ancestorLeftmost.getProperty(InternalProperties.MODIFIER).doubleValue();
                leftModSum += ancestorNeighbor.getProperty(InternalProperties.MODIFIER).doubleValue();
                ++i;
            }
            double prN = neighbor.getProperty(InternalProperties.PRELIM);
            double prL = leftmost.getProperty(InternalProperties.PRELIM);
            double mean = this.meanNodeWidth(leftmost, neighbor);
            double moveDistance = prN + leftModSum + this.spacing + mean - prL - rightModSum;
            if (0.0 < moveDistance) {
                TNode leftSibling = cN;
                int leftSiblings = 0;
                while (leftSibling != null && leftSibling != ancestorNeighbor) {
                    ++leftSiblings;
                    leftSibling = leftSibling.getProperty(InternalProperties.LEFTSIBLING);
                }
                if (leftSibling != null) {
                    double portion = moveDistance / (double)leftSiblings;
                    leftSibling = cN;
                    while (leftSibling != ancestorNeighbor) {
                        double newPr = leftSibling.getProperty(InternalProperties.PRELIM) + moveDistance;
                        leftSibling.setProperty(InternalProperties.PRELIM, (Object)newPr);
                        double newMod = leftSibling.getProperty(InternalProperties.MODIFIER) + moveDistance;
                        leftSibling.setProperty(InternalProperties.MODIFIER, (Object)newMod);
                        moveDistance -= portion;
                        leftSibling = leftSibling.getProperty(InternalProperties.LEFTSIBLING);
                    }
                } else {
                    return;
                }
            }
            leftmost = leftmost.isLeaf() ? TreeUtil.getLeftMost(cN.getChildren(), ++compareDepth) : (TNode)Iterables.getFirst(leftmost.getChildren(), null);
            TNode tNode = neighbor = leftmost != null ? leftmost.getProperty(InternalProperties.LEFTNEIGHBOR) : null;
        }
    }

    private double meanNodeWidth(TNode leftNode, TNode rightNode) {
        double nodeWidth = 0.0;
        if (leftNode != null) {
            nodeWidth = this.direction.isVertical() ? (nodeWidth += leftNode.getSize().x / 2.0) : (nodeWidth += leftNode.getSize().y / 2.0);
        }
        if (rightNode != null) {
            nodeWidth = this.direction.isVertical() ? (nodeWidth += rightNode.getSize().x / 2.0) : (nodeWidth += rightNode.getSize().y / 2.0);
        }
        return nodeWidth;
    }

    private void secondWalk(TNode tNode, double yCoor, double modsum) {
        if (tNode != null) {
            double xTemp = tNode.getProperty(InternalProperties.PRELIM) + modsum;
            double yTemp = yCoor + tNode.getProperty(InternalProperties.LEVELHEIGHT) / 2.0;
            tNode.setProperty(InternalProperties.XCOOR, (Object)((int)Math.round(xTemp)));
            tNode.setProperty(InternalProperties.YCOOR, (Object)((int)Math.round(yTemp)));
            if (!tNode.isLeaf()) {
                this.secondWalk(Iterables.getFirst(tNode.getChildren(), null), yCoor + tNode.getProperty(InternalProperties.LEVELHEIGHT) + this.spacing, modsum + tNode.getProperty(InternalProperties.MODIFIER));
            }
            if (tNode.getProperty(InternalProperties.RIGHTSIBLING) != null) {
                this.secondWalk(tNode.getProperty(InternalProperties.RIGHTSIBLING), yCoor, modsum);
            }
        }
    }
}

