/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p1cycles;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveCycleBreaker
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore(LayeredPhases.P1_CYCLE_BREAKING, IntermediateProcessorStrategy.INTERACTIVE_EXTERNAL_PORT_POSITIONER).addAfter(LayeredPhases.P5_EDGE_ROUTING, IntermediateProcessorStrategy.REVERSED_EDGE_RESTORER);

    @Override
    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        return INTERMEDIATE_PROCESSING_CONFIGURATION;
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive cycle breaking", 1.0f);
        ArrayList<LEdge> revEdges = Lists.newArrayList();
        for (LNode source : layeredGraph.getLayerlessNodes()) {
            source.id = 1;
            double sourcex = source.getInteractiveReferencePoint().x;
            for (LPort port : source.getPorts(PortType.OUTPUT)) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    double targetx;
                    LNode target = edge.getTarget().getNode();
                    if (target == source || !((targetx = target.getInteractiveReferencePoint().x) < sourcex)) continue;
                    revEdges.add(edge);
                }
            }
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        for (LNode node : layeredGraph.getLayerlessNodes()) {
            if (node.id <= 0) continue;
            this.findCycles(node, revEdges);
        }
        for (LEdge edge : revEdges) {
            edge.reverse(layeredGraph, true);
        }
        revEdges.clear();
        monitor.done();
    }

    private void findCycles(LNode node1, List<LEdge> revEdges) {
        node1.id = -1;
        for (LPort port : node1.getPorts(PortType.OUTPUT)) {
            for (LEdge edge : port.getOutgoingEdges()) {
                LNode node2 = edge.getTarget().getNode();
                if (node1 == node2) continue;
                if (node2.id < 0) {
                    revEdges.add(edge);
                    continue;
                }
                if (node2.id <= 0) continue;
                this.findCycles(node2, revEdges);
            }
        }
        node1.id = 0;
    }
}

