/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.Objects;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.utils.Direction;

public class TextBlockArrow
extends AbstractTextBlock
implements TextBlock {
    private final double size;
    private final Direction arrow;
    private final HColor color;

    public TextBlockArrow(Direction arrow, FontConfiguration fontConfiguration) {
        this.arrow = Objects.requireNonNull(arrow);
        this.size = fontConfiguration.getFont().getSize2D();
        this.color = fontConfiguration.getColor();
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = ug.apply(this.color.bg());
        ug = ug.apply(this.color);
        int triSize = (int)(this.size * 0.8 - 3.0);
        if (triSize % 2 == 1) {
            --triSize;
        }
        UPolygon triangle = this.getTriangle(triSize);
        ug.apply(new UTranslate(2.0, this.size - (double)triSize - 2.0)).draw(triangle);
    }

    private UPolygon getTriangle(int triSize) {
        UPolygon triangle = new UPolygon();
        if (this.arrow == Direction.RIGHT) {
            triangle.addPoint(0.0, 0.0);
            triangle.addPoint(triSize, triSize / 2);
            triangle.addPoint(0.0, triSize);
            triangle.addPoint(0.0, 0.0);
        } else if (this.arrow == Direction.LEFT) {
            triangle.addPoint(triSize, 0.0);
            triangle.addPoint(0.0, triSize / 2);
            triangle.addPoint(triSize, triSize);
            triangle.addPoint(triSize, 0.0);
        } else if (this.arrow == Direction.UP) {
            triangle.addPoint(0.0, triSize);
            triangle.addPoint(triSize / 2, 0.0);
            triangle.addPoint(triSize, triSize);
            triangle.addPoint(0.0, triSize);
        } else if (this.arrow == Direction.DOWN) {
            triangle.addPoint(0.0, 0.0);
            triangle.addPoint(triSize / 2, triSize);
            triangle.addPoint(triSize, 0.0);
            triangle.addPoint(0.0, 0.0);
        } else {
            throw new IllegalStateException();
        }
        return triangle;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(this.size, this.size);
    }
}

