/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public abstract class ETile
extends AbstractTextBlock {
    protected final boolean TRACE = false;

    public static StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ebnf);
    }

    public abstract void push(ETile var1);

    @Override
    public final XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = this.getWidth(stringBounder);
        double h1 = this.getH1(stringBounder);
        double h2 = this.getH2(stringBounder);
        return new XDimension2D(width, h1 + h2);
    }

    public abstract double getWidth(StringBounder var1);

    public abstract double getH1(StringBounder var1);

    public abstract double getH2(StringBounder var1);

    protected final void drawHline(UGraphic ug, double y, double x1, double x2) {
        ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
    }

    protected final void drawHlineDirected(UGraphic ug, double y, double x1, double x2, double coef, double minimunSizeForArrow) {
        ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
        if (x2 > x1 + minimunSizeForArrow) {
            ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x1 * (1.0 - coef) + x2 * coef - 2.0, y)).draw(ETile.getArrowToRight());
        }
    }

    protected final void drawHlineAntiDirected(UGraphic ug, double y, double x1, double x2, double coef) {
        ug.apply(new UTranslate(x1, y)).draw(ULine.hline(x2 - x1));
        ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x1 * (1.0 - coef) + x2 * coef - 2.0, y)).draw(ETile.getArrowToLeft());
    }

    protected final void drawVline(UGraphic ug, double x, double y1, double y2) {
        ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
    }

    protected final void drawVlineDirected(UGraphic ug, double x, double y1, double y2) {
        ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
        ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x, y1 * 0.5 + y2 * 0.5 - 2.0)).draw(ETile.getArrowToBottom());
    }

    protected final void drawVlineAntiDirected(UGraphic ug, double x, double y1, double y2) {
        ug.apply(new UTranslate(x, y1)).draw(ULine.vline(y2 - y1));
        ug.apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(x, y1 * 0.5 + y2 * 0.5 + 2.0)).draw(ETile.getArrowToTop());
    }

    static UPath getArrowToLeft() {
        UPath arrow = UPath.none();
        arrow.moveTo(0.0, 0.0);
        arrow.lineTo(0.0, -3.0);
        arrow.lineTo(-6.0, 0.0);
        arrow.lineTo(0.0, 3.0);
        arrow.lineTo(0.0, 0.0);
        arrow.closePath();
        return arrow;
    }

    static UPath getArrowToRight() {
        UPath arrow = UPath.none();
        arrow.moveTo(0.0, 0.0);
        arrow.lineTo(0.0, -3.0);
        arrow.lineTo(6.0, 0.0);
        arrow.lineTo(0.0, 3.0);
        arrow.lineTo(0.0, 0.0);
        arrow.closePath();
        return arrow;
    }

    static UPath getArrowToBottom() {
        UPath arrow = UPath.none();
        arrow.moveTo(0.0, 0.0);
        arrow.lineTo(3.0, 0.0);
        arrow.lineTo(0.0, 6.0);
        arrow.lineTo(-3.0, 0.0);
        arrow.lineTo(0.0, 0.0);
        arrow.closePath();
        return arrow;
    }

    static UPath getArrowToTop() {
        UPath arrow = UPath.none();
        arrow.moveTo(0.0, 0.0);
        arrow.lineTo(3.0, 0.0);
        arrow.lineTo(0.0, -6.0);
        arrow.lineTo(-3.0, 0.0);
        arrow.lineTo(0.0, 0.0);
        arrow.closePath();
        return arrow;
    }

    protected void addCommentBelow(String comment) {
        System.err.println("Ignoring below comment " + comment + " " + this.getClass());
    }

    protected void addCommentAbove(String comment) {
        System.err.println("Ignoring above comment " + comment + " " + this.getClass());
    }

    protected String getRepetitionLabel() {
        return "?";
    }
}

